/*
 * Decompiled with CFR 0.152.
 */
package sdb;

import arq.cmdline.ArgDecl;
import arq.cmdline.ArgModuleGeneral;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sdb.store.StoreBaseHSQL;
import com.hp.hpl.jena.sparql.util.Timer;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.util.FileUtils;
import java.util.Iterator;
import java.util.List;
import sdb.cmd.CmdArgsDB;
import sdb.cmd.ModGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class sdbload
extends CmdArgsDB {
    private static final String usage = "sdbload --sdb <SPEC> [--graph=IRI] file";
    private static ModGraph modGraph = new ModGraph();
    private static ArgDecl argDeclTruncate = new ArgDecl(false, "truncate");
    private static ArgDecl argDeclReplace = new ArgDecl(false, "replace");
    String filename = null;

    public static void main(String ... argv) {
        new sdbload(argv).mainRun();
    }

    public sdbload(String ... args) {
        super(args);
        this.addModule((ArgModuleGeneral)modGraph);
        this.add(argDeclTruncate);
        this.add(argDeclReplace);
    }

    protected String getCommandName() {
        return Utils.className((Object)((Object)this));
    }

    protected String getSummary() {
        return this.getCommandName() + " <SPEC> [--graph IRI] file ...";
    }

    protected void processModulesAndArgs() {
        if (this.getNumPositional() == 0) {
            this.cmdError("Need filenames of RDF data to load", true);
        }
    }

    @Override
    protected void execCmd(List<String> args) {
        if (this.contains(argDeclTruncate)) {
            this.getStore().getTableFormatter().truncate();
        }
        for (String x : args) {
            this.loadOne(x, this.contains(argDeclReplace));
        }
        StoreBaseHSQL.close(this.getStore());
    }

    private void loadOne(String filename, boolean replace) {
        Monitor monitor = null;
        Model model = modGraph.getModel(this.getStore());
        Graph graph = model.getGraph();
        if (this.isVerbose() && replace) {
            System.out.println("Emptying: " + filename);
        }
        if (replace) {
            model.removeAll();
        }
        if (this.isVerbose() || this.getModTime().timingEnabled()) {
            System.out.println("Start load: " + filename);
        }
        if (this.getModTime().timingEnabled()) {
            monitor = new Monitor(this.getStore().getLoader().getChunkSize(), this.isVerbose());
            graph.getEventManager().register((GraphListener)monitor);
        }
        if (filename.indexOf(58) == -1) {
            filename = "file:" + filename;
        }
        String lang = FileUtils.guessLang((String)filename);
        this.getModTime().startTimer();
        model.read(filename, lang);
        long timeMilli = this.getModTime().endTimer();
        if (monitor != null) {
            System.out.println("Added " + monitor.addCount + " triples");
            if (this.getModTime().timingEnabled() && !this.isQuiet()) {
                System.out.printf("Loaded in %.3f seconds [%d triples/s]\n", (double)timeMilli / 1000.0, 1000L * monitor.addCount / timeMilli);
            }
            graph.getEventManager().unregister((GraphListener)monitor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Monitor
    implements GraphListener {
        int addNotePoint;
        long addCount = 0L;
        int outputCount = 0;
        private Timer timer = null;
        private long lastTime = 0L;
        private boolean displayMemory = false;

        Monitor(int addNotePoint, boolean displayMemory) {
            this.addNotePoint = addNotePoint;
            this.displayMemory = displayMemory;
            this.timer = new Timer();
            this.timer.startTimer();
        }

        public void notifyAddTriple(Graph g, Triple t) {
            this.addEvent(t);
        }

        public void notifyAddArray(Graph g, Triple[] triples) {
            for (Triple t : triples) {
                this.addEvent(t);
            }
        }

        public void notifyAddList(Graph g, List<Triple> triples) {
            this.notifyAddIterator(g, triples.iterator());
        }

        public void notifyAddIterator(Graph g, Iterator<Triple> it) {
            while (it.hasNext()) {
                this.addEvent(it.next());
            }
        }

        public void notifyAddGraph(Graph g, Graph added) {
        }

        public void notifyDeleteTriple(Graph g, Triple t) {
        }

        public void notifyDeleteList(Graph g, List<Triple> L) {
        }

        public void notifyDeleteArray(Graph g, Triple[] triples) {
        }

        public void notifyDeleteIterator(Graph g, Iterator<Triple> it) {
        }

        public void notifyDeleteGraph(Graph g, Graph removed) {
        }

        public void notifyEvent(Graph source, Object value) {
        }

        private void addEvent(Triple t) {
            ++this.addCount;
            if (this.addNotePoint > 0 && this.addCount % (long)this.addNotePoint == 0L) {
                ++this.outputCount;
                long soFar = this.timer.readTimer();
                long thisTime = soFar - this.lastTime;
                long tpsBatch = (long)this.addNotePoint * 1000L / thisTime;
                long tpsAvg = this.addCount * 1000L / soFar;
                String msg = String.format("Add: %,d triples  (Batch: %d / Run: %d)", this.addCount, tpsBatch, tpsAvg);
                if (this.displayMemory) {
                    long mem = Runtime.getRuntime().totalMemory();
                    long free = Runtime.getRuntime().freeMemory();
                    msg = msg + String.format("   [M:%,d/F:%,d]", mem, free);
                }
                System.out.println(msg);
                if (this.outputCount > 0 && this.outputCount % 10 == 0) {
                    System.out.printf("  Elapsed: %.1f seconds\n", Float.valueOf((float)soFar / 1000.0f));
                }
                this.lastTime = soFar;
            }
        }
    }
}

