/*
 * Decompiled with CFR 0.152.
 */
package sdb;

import arq.cmdline.ArgDecl;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sdb.SDBFactory;
import com.hp.hpl.jena.sdb.store.StoreBaseHSQL;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.List;
import sdb.cmd.CmdArgsDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class sdbdelete
extends CmdArgsDB {
    private static final String usage = "sdbdelete --sdb <SPEC> default | <IRI> ...";
    private static ArgDecl argDeclConfirm = new ArgDecl(false, "confirm", "force");
    String filename = null;

    public static void main(String ... argv) {
        new sdbdelete(argv).mainRun();
    }

    public sdbdelete(String ... args) {
        super(args);
        this.add(argDeclConfirm);
    }

    protected String getCommandName() {
        return Utils.className((Object)((Object)this));
    }

    protected String getSummary() {
        return this.getCommandName() + " <SPEC> default | <IRI> ...";
    }

    protected void processModulesAndArgs() {
        if (this.getNumPositional() == 0) {
            this.cmdError("Need IRIs of graphs to delete", true);
        }
    }

    @Override
    protected void execCmd(List<String> args) {
        for (String x : args) {
            this.removeOne(x);
        }
        StoreBaseHSQL.close(this.getStore());
    }

    private void removeOne(String IRI) {
        boolean removeDefault = "default".equals(IRI);
        if (this.isVerbose()) {
            if (removeDefault) {
                System.out.println("Removing default graph");
            } else {
                System.out.println("Removing graph named <" + IRI + ">");
            }
        }
        Model model = removeDefault ? SDBFactory.connectDefaultModel(this.getStore()) : SDBFactory.connectNamedModel(this.getStore(), IRI);
        model.removeAll();
    }
}

