/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.util;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sdb.SDBFactory;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.layout2.TableDescNodes;
import com.hp.hpl.jena.sdb.store.DatabaseType;
import com.hp.hpl.jena.sdb.store.TableDesc;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.util.FileManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreUtils {
    public static boolean isHSQL(Store store) {
        return store.getDatabaseType().equals((Object)DatabaseType.HSQLDB);
    }

    public static boolean isH2(Store store) {
        return store.getDatabaseType().equals((Object)DatabaseType.H2);
    }

    public static boolean isDerby(Store store) {
        return store.getDatabaseType().equals((Object)DatabaseType.Derby);
    }

    public static boolean isPostgreSQL(Store store) {
        return store.getDatabaseType().equals((Object)DatabaseType.PostgreSQL);
    }

    public static boolean isMySQL(Store store) {
        return store.getDatabaseType().equals((Object)DatabaseType.MySQL);
    }

    public static boolean isSQLServer(Store store) {
        return store.getDatabaseType().equals((Object)DatabaseType.SQLServer);
    }

    public static boolean isOracle(Store store) {
        return store.getDatabaseType().equals((Object)DatabaseType.Oracle);
    }

    public static boolean isDB2(Store store) {
        return store.getDatabaseType().equals((Object)DatabaseType.DB2);
    }

    public static void load(Store store, String filename) {
        Model model = SDBFactory.connectDefaultModel(store);
        FileManager.get().readModel(model, filename);
    }

    public static void load(Store store, String graphIRI, String filename) {
        Model model = SDBFactory.connectNamedModel(store, graphIRI);
        FileManager.get().readModel(model, filename);
    }

    public static Iterator<Node> storeGraphNames(Store store) {
        ArrayList<Node> x = new ArrayList<Node>();
        String qs = "SELECT ?g { GRAPH ?g { }}";
        QueryExecution qExec = QueryExecutionFactory.create((String)qs, (Dataset)SDBFactory.connectDataset(store));
        ResultSet rs = qExec.execSelect();
        Var var_g = Var.alloc((String)"g");
        while (rs.hasNext()) {
            Node n = rs.nextBinding().get(var_g);
            x.add(n);
        }
        return x.iterator();
    }

    public static boolean containsGraph(Store store, Node graphNode) {
        String qs = "SELECT * { GRAPH " + FmtUtils.stringForNode((Node)graphNode) + " { ?s ?p ?o }} LIMIT 1";
        Dataset ds = SDBFactory.connectDataset(store);
        QueryExecution qExec = QueryExecutionFactory.create((String)qs, (Dataset)ds);
        ResultSet rs = qExec.execSelect();
        boolean b = rs.hasNext();
        qExec.close();
        return b;
    }

    public static boolean isFormatted(Store store) throws SQLException {
        return StoreUtils.checkNodes(store) && StoreUtils.checkTuples(store);
    }

    private static boolean checkNodes(Store store) throws SQLException {
        Connection conn = store.getConnection().getSqlConnection();
        TableDescNodes nodeDesc = store.getNodeTableDesc();
        if (nodeDesc == null) {
            return true;
        }
        return StoreUtils.hasTableAndColumns(conn, nodeDesc.getTableName(), nodeDesc.getIdColName(), nodeDesc.getHashColName(), nodeDesc.getLexColName(), nodeDesc.getLangColName(), nodeDesc.getTypeColName());
    }

    private static boolean checkTuples(Store store) throws SQLException {
        Connection conn = store.getConnection().getSqlConnection();
        return StoreUtils.isTupleTableFormatted(conn, store.getTripleTableDesc()) && StoreUtils.isTupleTableFormatted(conn, store.getQuadTableDesc());
    }

    private static boolean isTupleTableFormatted(Connection conn, TableDesc desc) throws SQLException {
        if (desc == null) {
            return true;
        }
        return StoreUtils.hasTableAndColumns(conn, desc.getTableName(), desc.getColNames().toArray(new String[0]));
    }

    private static boolean hasTableAndColumns(Connection conn, String tableName, String ... colNames) throws SQLException {
        HashSet<String> cols = new HashSet<String>();
        for (String c : colNames) {
            if (c == null) continue;
            cols.add(c.toLowerCase());
        }
        return StoreUtils.hasColumns(conn, tableName, cols) || StoreUtils.hasColumns(conn, tableName.toLowerCase(), cols) || StoreUtils.hasColumns(conn, tableName.toUpperCase(), cols);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasColumns(Connection conn, String tableName, Collection<String> colNames) throws SQLException {
        java.sql.ResultSet res = null;
        try {
            res = conn.getMetaData().getColumns(null, null, tableName, null);
            while (res.next()) {
                String colName = res.getString("COLUMN_NAME");
                colNames.remove(colName.toLowerCase());
            }
            boolean bl = colNames.isEmpty();
            return bl;
        }
        finally {
            if (res != null) {
                res.close();
            }
        }
    }
}

