/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.store;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SDBConnectionHolder;
import com.hp.hpl.jena.sdb.sql.TableUtils;
import com.hp.hpl.jena.sdb.store.ConfigVocab;
import com.hp.hpl.jena.sdb.store.TaggedString;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreConfig
extends SDBConnectionHolder {
    private static Logger log = LoggerFactory.getLogger(StoreConfig.class);
    private static final String serializationFormat = "N-TRIPLE";
    public static final String defaultTag = "config";
    private boolean initialized = false;
    private Map<String, Model> cache = new HashMap<String, Model>();
    private boolean caching = true;
    TaggedString storage = null;
    private Resource rootType = ResourceFactory.createResource();

    public StoreConfig(SDBConnection sdb) {
        super(sdb);
        this.storage = new TaggedString(this.connection());
    }

    public List<String> tables() {
        return TableUtils.getTableNames(this.connection().getSqlConnection());
    }

    private Resource getRoot() {
        Model model = this.getModel();
        return GraphUtils.getResourceByType((Model)model, (Resource)ConfigVocab.typeConfig);
    }

    public void removeModel() {
        this.removeModel(defaultTag);
    }

    public void removeModel(String tag) {
        this.init();
        log.trace(".removeModel: " + tag);
        this.storage.remove(tag);
    }

    public Model getModel() {
        return this.getModel(defaultTag);
    }

    public Model getModel(String tag) {
        this.init();
        log.trace(".getModel: " + tag);
        Model m = null;
        if (this.caching && this.cache.containsKey(tag)) {
            log.trace(".getModel: cache hit for " + tag);
            return this.cache.get(tag);
        }
        log.trace(".getModel: cache miss for " + tag);
        m = this.readModel(tag);
        if (m == null) {
            return null;
        }
        if (this.caching) {
            this.cache.put(tag, m);
        }
        return m;
    }

    public void setModel(Model m) {
        this.setModel(defaultTag, m);
    }

    public void setModel(String tag, Model m) {
        this.init();
        log.trace(".setModel: " + tag);
        this.writeModel(tag, m);
        if (this.caching) {
            log.trace(".setModel: cache model for " + tag);
            this.cache.put(tag, m);
        }
    }

    public List<String> getTags() {
        this.init();
        return this.storage.tags();
    }

    public void reset() {
        this.storage.reset();
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.storage != null) {
            return;
        }
    }

    private Model readModel(String tag) {
        log.trace(".readModel: " + tag);
        String s = this.storage.get(tag);
        if (s == null) {
            return null;
        }
        Model m = ModelFactory.createDefaultModel();
        StringReader r = new StringReader(s);
        m.read((Reader)r, null, serializationFormat);
        return m;
    }

    private void writeModel(String tag, Model model) {
        log.trace(".writeModel: " + tag);
        StringWriter x = new StringWriter();
        model.write((Writer)x, serializationFormat);
        this.storage.set(tag, x.toString());
    }
}

