/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout2.index;

import com.hp.hpl.jena.sdb.layout2.index.TupleLoaderIndexBase;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.store.TableDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleLoaderIndexDB2
extends TupleLoaderIndexBase {
    private static Logger log = LoggerFactory.getLogger(TupleLoaderIndexDB2.class);

    public TupleLoaderIndexDB2(SDBConnection connection, TableDesc tableDesc, int chunkSize) {
        super(connection, tableDesc, chunkSize);
    }

    public String[] getNodeColTypes() {
        return new String[]{"BIGINT", "CLOB", "VARCHAR(10)", "VARCHAR(200)", "INTEGER"};
    }

    public String getTupleColType() {
        return "BIGINT";
    }

    public String[] getCreateTempTable() {
        return new String[]{"CREATE TABLE ", " CCSID UNICODE"};
    }

    public String getClearTempNodes() {
        return "DELETE FROM " + this.getNodeLoader();
    }

    public String getClearTempTuples() {
        return "DELETE FROM " + this.getTupleLoader();
    }

    public String getLoadTuples() {
        int i;
        StringBuilder stmt = new StringBuilder();
        stmt.append("INSERT INTO ").append(this.getTableName()).append(" \nSELECT DISTINCT ");
        for (i = 0; i < this.getTableWidth(); ++i) {
            if (i != 0) {
                stmt.append(" , ");
            }
            stmt.append("NI").append(i).append(".id");
        }
        stmt.append("\nFROM ").append(this.getTupleLoader()).append("\n");
        for (i = 0; i < this.getTableWidth(); ++i) {
            stmt.append("JOIN Nodes NI").append(i).append(" ON (");
            stmt.append(this.getTupleLoader()).append(".t").append(i).append("=NI").append(i).append(".hash)\n");
        }
        stmt.append("LEFT JOIN ").append(this.getTableName()).append(" ON (");
        for (i = 0; i < this.getTableWidth(); ++i) {
            if (i != 0) {
                stmt.append(" AND ");
            }
            stmt.append("NI").append(i).append(".id");
            stmt.append("=").append(this.getTableName()).append(".").append(this.getTableDesc().getColNames().get(i));
        }
        stmt.append(")\nWHERE\n");
        for (i = 0; i < this.getTableWidth(); ++i) {
            if (i != 0) {
                stmt.append(" OR\n");
            }
            stmt.append(this.getTableName()).append(".").append(this.getTableDesc().getColNames().get(i)).append(" IS NULL");
        }
        return stmt.toString();
    }

    public String getLoadNodes() {
        StringBuilder stmt = new StringBuilder();
        stmt.append("INSERT INTO Nodes \nSELECT (NEXT VALUE FOR nodeid) , ");
        for (int i = 0; i < this.getNodeColTypes().length; ++i) {
            if (i != 0) {
                stmt.append(" , ");
            }
            stmt.append(this.getNodeLoader()).append(".").append("n").append(i);
        }
        stmt.append("\nFROM ").append(this.getNodeLoader()).append(" LEFT JOIN Nodes ON (");
        stmt.append(this.getNodeLoader()).append(".n0=Nodes.hash) \nWHERE Nodes.hash IS NULL");
        return stmt.toString();
    }
}

