/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout2.hash;

import com.hp.hpl.jena.sdb.layout2.FmtLayout2;
import com.hp.hpl.jena.sdb.layout2.TableDescNodes;
import com.hp.hpl.jena.sdb.layout2.TableDescQuads;
import com.hp.hpl.jena.sdb.layout2.TableDescTriples;
import com.hp.hpl.jena.sdb.layout2.TablePrefixes;
import com.hp.hpl.jena.sdb.sql.MySQLEngineType;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SDBExceptionSQL;
import com.hp.hpl.jena.sdb.sql.SQLUtils;
import com.hp.hpl.jena.sdb.sql.TableUtils;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FmtLayout2HashHSQL
extends FmtLayout2 {
    private static Logger log = LoggerFactory.getLogger(FmtLayout2HashHSQL.class);
    private MySQLEngineType engineType;

    public FmtLayout2HashHSQL(SDBConnection connection) {
        super(connection);
    }

    protected void formatTableTriples() {
        this.dropTable(TableDescTriples.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescTriples.name() + " (", "    s BIGINT NOT NULL ,", "    p BIGINT NOT NULL ,", "    o BIGINT NOT NULL ,", "    PRIMARY KEY (s, p, o)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescTriples.name() + "'", ex);
        }
    }

    protected void formatTableQuads() {
        this.dropTable(TableDescQuads.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescQuads.name() + " (", "    g BIGINT NOT NULL ,", "    s BIGINT NOT NULL ,", "    p BIGINT NOT NULL ,", "    o BIGINT NOT NULL ,", "    PRIMARY KEY (g, s, p, o)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescQuads.name() + "'", ex);
        }
    }

    protected String syntaxDropIndex(String indexName, String table) {
        return String.format("DROP INDEX %s IF EXIST", indexName);
    }

    protected void formatTableNodes() {
        this.dropTable(TableDescNodes.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescNodes.name() + " (", "   hash BIGINT NOT NULL ,", "   lex VARCHAR NOT NULL ,", "   lang VARCHAR(10) default '' NOT NULL ,", "   datatype VARCHAR default '' NOT NULL ,", "   type int default 0 NOT NULL ,", "   PRIMARY KEY (hash)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException resetting table '" + TableDescNodes.name() + "'", ex);
        }
    }

    protected void formatTablePrefixes() {
        this.dropTable(TablePrefixes.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TablePrefixes.name() + " (", "    prefix  VARCHAR NOT NULL,", "    uri     VARCHAR NOT NULL,", "    PRIMARY KEY  (prefix)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException resetting table '" + TablePrefixes.name() + "'", ex);
        }
    }

    protected void truncateTable(String tableName) {
        try {
            if (TableUtils.hasTable(this.connection().getSqlConnection(), tableName, new String[0])) {
                this.connection().exec("DELETE FROM " + tableName);
            }
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException : Can't truncate table: " + tableName, ex);
        }
    }
}

