/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout1;

import com.hp.hpl.jena.sdb.SDBException;
import com.hp.hpl.jena.sdb.layout1.FormatterSimple;
import com.hp.hpl.jena.sdb.layout1.TableDescSPO;
import com.hp.hpl.jena.sdb.sql.MySQLEngineType;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SDBExceptionSQL;
import com.hp.hpl.jena.sdb.sql.SQLUtils;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatterSimpleMySQL
extends FormatterSimple {
    private static Logger log = LoggerFactory.getLogger(FormatterSimpleMySQL.class);
    private MySQLEngineType engineType;
    private static final String colDecl = "VARCHAR(200) BINARY NOT NULL";

    public FormatterSimpleMySQL(SDBConnection connection, MySQLEngineType tableType) {
        super(connection);
        this.engineType = tableType;
        if (this.engineType == null) {
            log.error("Engine type is null");
            throw new SDBException("Engine type is null");
        }
    }

    public void truncate() {
        try {
            this.connection().exec("TRUNCATE TABLE Triples");
        }
        catch (SQLException ex) {
            log.warn("Exception truncating tables");
            throw new SDBException("SQLException truncating tables", ex);
        }
    }

    public void format() {
        this.reformatPrefixesWorker(false);
        this.reformatDataWorker();
    }

    private void reformatPrefixesWorker() {
        this.reformatPrefixesWorker(false);
    }

    private void reformatPrefixesWorker(boolean loadPrefixes) {
        try {
            this.connection().exec("DROP TABLE IF EXISTS Prefixes");
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE Prefixes (", "    prefix VARCHAR(50) BINARY NOT NULL ,", "    uri VARCHAR(500) BINARY NOT NULL ,", "  PRIMARY KEY(prefix)", ") ENGINE=" + this.engineType.getEngineName()));
            if (loadPrefixes) {
                this.connection().execUpdate("INSERT INTO Prefixes VALUES ('x',       'http://example/')");
                this.connection().execUpdate("INSERT INTO Prefixes VALUES ('ex',      'http://example.org/')");
                this.connection().execUpdate("INSERT INTO Prefixes VALUES ('rdf',     'http://www.w3.org/1999/02/22-rdf-syntax-ns#')");
                this.connection().execUpdate("INSERT INTO Prefixes VALUES ('rdfs',    'http://www.w3.org/2000/01/rdf-schema#')");
                this.connection().execUpdate("INSERT INTO Prefixes VALUES ('xsd',     'http://www.w3.org/2001/XMLSchema#')");
                this.connection().execUpdate("INSERT INTO Prefixes VALUES ('owl' ,    'http://www.w3.org/2002/07/owl#')");
                this.connection().execUpdate("INSERT INTO Prefixes VALUES ('foaf',    'http://xmlns.com/foaf/0.1/')");
                this.connection().execUpdate("INSERT INTO Prefixes VALUES ('dc',      'http://purl.org/dc/elements/1.1/')");
                this.connection().execUpdate("INSERT INTO Prefixes VALUES ('dcterms', 'http://purl.org/dc/terms/')");
            }
        }
        catch (SQLException ex) {
            log.warn("Exception resetting table 'Prefixes'");
            throw new SDBException("SQLException resetting table 'Prefixes'", ex);
        }
    }

    private void reformatDataWorker() {
        try {
            this.connection().exec("DROP TABLE IF EXISTS Triples");
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE Triples", "(", "  s VARCHAR(200) BINARY NOT NULL ,", "  p VARCHAR(200) BINARY NOT NULL ,", "  o VARCHAR(200) BINARY NOT NULL ,", "  PRIMARY KEY (s,p,o)", ")", "ENGINE=" + this.engineType.getEngineName() + " CHARSET=utf8"));
        }
        catch (SQLException ex) {
            log.warn("Exception resetting table 'Triples'");
            throw new SDBException("SQLException resetting table 'Triples'", ex);
        }
    }

    public void dropIndexes() {
        try {
            this.connection().exec("DROP INDEX PredObj ON " + TableDescSPO.name());
            this.connection().exec("DROP INDEX ObjSubj ON " + TableDescSPO.name());
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException dropping indexes for table 'Triples'", ex);
        }
    }
}

