/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout1;

import com.hp.hpl.jena.sdb.SDBException;
import com.hp.hpl.jena.sdb.layout1.FormatterSimple;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SDBExceptionSQL;
import com.hp.hpl.jena.sdb.sql.SQLUtils;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatterSimpleHSQL
extends FormatterSimple {
    private static Logger log = LoggerFactory.getLogger(FormatterSimpleHSQL.class);
    private static final String colDecl = "VARCHAR";

    public FormatterSimpleHSQL(SDBConnection connection) {
        super(connection);
    }

    public void truncate() {
        try {
            this.connection().exec("DELETE FROM Triples");
        }
        catch (SQLException ex) {
            log.warn("Exception truncating tables");
            throw new SDBException("SQLException truncating tables", ex);
        }
    }

    public void format() {
        this.reformatPrefixesWorker(false);
        this.reformatDataWorker();
    }

    private void reformatPrefixesWorker() {
        this.reformatPrefixesWorker(false);
    }

    private void reformatPrefixesWorker(boolean loadPrefixes) {
        try {
            this.connection().exec("DROP TABLE IF EXISTS Prefixes");
            this.connection().exec(SQLUtils.sqlStr("CREATE CACHED TABLE Prefixes (", "    prefix VARCHAR  NOT NULL ,", "    uri    VARCHAR  NOT NULL ,", "PRIMARY KEY(prefix)", ")"));
            if (loadPrefixes) {
                this.connection().execUpdate("INSERT INTO Prefixes VALUES ('x',       'http://example/')");
                this.connection().execUpdate("INSERT INTO Prefixes VALUES ('ex',      'http://example.org/')");
                this.connection().execUpdate("INSERT INTO Prefixes VALUES ('rdf',     'http://www.w3.org/1999/02/22-rdf-syntax-ns#')");
                this.connection().execUpdate("INSERT INTO Prefixes VALUES ('rdfs',    'http://www.w3.org/2000/01/rdf-schema#')");
                this.connection().execUpdate("INSERT INTO Prefixes VALUES ('xsd',     'http://www.w3.org/2001/XMLSchema#')");
                this.connection().execUpdate("INSERT INTO Prefixes VALUES ('owl' ,    'http://www.w3.org/2002/07/owl#')");
                this.connection().execUpdate("INSERT INTO Prefixes VALUES ('foaf',    'http://xmlns.com/foaf/0.1/')");
                this.connection().execUpdate("INSERT INTO Prefixes VALUES ('dc',      'http://purl.org/dc/elements/1.1/')");
                this.connection().execUpdate("INSERT INTO Prefixes VALUES ('dcterms', 'http://purl.org/dc/terms/')");
            }
        }
        catch (SQLException ex) {
            log.warn("Exception resetting table 'Prefixes'");
            throw new SDBException("SQLException resetting table 'Prefixes'", ex);
        }
    }

    private void reformatDataWorker() {
        try {
            this.connection().exec("DROP TABLE IF EXISTS Triples");
            this.connection().exec(SQLUtils.sqlStr("CREATE CACHED TABLE Triples", "(", "  s VARCHAR ,", "  p VARCHAR ,", "  o VARCHAR ,", "  PRIMARY KEY (s,p,o)", ")"));
        }
        catch (SQLException ex) {
            log.warn("Exception resetting table 'Triples'");
            throw new SDBException("SQLException resetting table 'Triples'", ex);
        }
    }

    public void dropIndexes() {
        try {
            this.connection().exec("DROP INDEX PredObj IF EXISTS");
            this.connection().exec("DROP INDEX ObjSubj IF EXISTS");
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException dropping indexes for table 'Triples'", ex);
        }
    }
}

