/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.core;

import com.hp.hpl.jena.sdb.core.Scope;
import com.hp.hpl.jena.sdb.core.ScopeEntry;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlColumn;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeBase
implements Scope {
    private Map<Var, SqlColumn> frame = new HashMap<Var, SqlColumn>();
    private Scope parent = null;

    @Override
    public boolean hasColumnForVar(Var var) {
        if (this.frame.containsKey(var)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.hasColumnForVar(var);
        }
        return false;
    }

    @Override
    public Set<Var> getVars() {
        HashSet<Var> x = new HashSet<Var>();
        x.addAll(this.frame.keySet());
        if (this.parent != null) {
            x.addAll(this.parent.getVars());
        }
        return x;
    }

    @Override
    public boolean isEmpty() {
        return this.frame.isEmpty();
    }

    @Override
    public Set<ScopeEntry> findScopes() {
        HashSet<ScopeEntry> x = new HashSet<ScopeEntry>();
        for (Var v : this.frame.keySet()) {
            ScopeEntry e = this.findScopeForVar(v);
            x.add(e);
        }
        if (this.parent != null) {
            x.addAll(this.parent.findScopes());
        }
        return x;
    }

    @Override
    public ScopeEntry findScopeForVar(Var var) {
        if (this.frame.containsKey(var)) {
            ScopeEntry e = new ScopeEntry(var, this.frame.get(var));
            return e;
        }
        if (this.parent != null) {
            return this.parent.findScopeForVar(var);
        }
        return null;
    }

    public void setColumnForVar(Var var, SqlColumn column) {
        if (this.frame.containsKey(var)) {
            LoggerFactory.getLogger(Scope.class).warn("Already has an alias: " + var + " => " + this.findScopeForVar(var));
            return;
        }
        this.frame.put(var, column);
    }

    public String toString() {
        String str = "";
        String sep = "";
        for (Var v : this.frame.keySet()) {
            SqlColumn c = this.frame.get(v);
            str = str + sep + v + ":" + c;
            sep = " ";
        }
        if (this.parent != null) {
            str = str + "=>" + this.parent.toString();
        }
        return str;
    }
}

