/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.core;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sdb.SDB;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.core.Generator;
import com.hp.hpl.jena.sdb.core.Gensym;
import com.hp.hpl.jena.sdb.store.StoreHolder;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarAlloc;
import com.hp.hpl.jena.sparql.util.Context;
import java.util.HashMap;
import java.util.Map;

public class SDBRequest
extends StoreHolder {
    private PrefixMapping prefixMapping;
    private Query query;
    private VarAlloc varAlloc = new VarAlloc("V");
    public boolean LeftJoinTranslation = true;
    public boolean LimitOffsetTranslation = true;
    public boolean DistinctTranslation = true;
    private Context context;
    private Map<String, Generator> generators = new HashMap<String, Generator>();

    public SDBRequest(Store store, Query query2, Context context) {
        super(store);
        this.query = query2;
        this.prefixMapping = null;
        if (query2 != null) {
            this.prefixMapping = query2.getPrefixMapping();
        }
        if (context == null) {
            context = SDB.getContext();
        }
        this.context = new Context(context);
    }

    public SDBRequest(Store store, Query query2) {
        this(store, query2, null);
    }

    public Context getContext() {
        return this.context;
    }

    public PrefixMapping getPrefixMapping() {
        return this.prefixMapping;
    }

    public Query getQuery() {
        return this.query;
    }

    public Store getStore() {
        return this.store();
    }

    public Generator generator(String base) {
        Generator g = this.generators.get(base);
        if (g == null) {
            g = Gensym.create(base);
            this.generators.put(base, g);
        }
        return g;
    }

    public String genId(String base) {
        Generator gen = this.generator(base);
        return gen.next();
    }

    public Var genVar() {
        return this.varAlloc.allocVar();
    }
}

