/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.test.misc;

import com.hp.hpl.jena.sdb.SDBFactory;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.StoreDesc;
import com.hp.hpl.jena.sdb.graph.PrefixMappingSDB;
import com.hp.hpl.jena.sdb.sql.JDBC;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestPrefixMappingSDB {
    static final String hsql = "jdbc:hsqldb:mem:aname";
    static final String defaultPrefixURI = "";
    static SDBConnection sdb = null;

    @BeforeClass
    public static void setUpClass() {
        JDBC.loadDriverHSQL();
        sdb = SDBFactory.createConnection((String)hsql, (String)"sa", (String)defaultPrefixURI);
        StoreDesc desc = new StoreDesc("Layout2", "HSQLDB", null);
        Store store = SDBFactory.connectStore((SDBConnection)sdb, (StoreDesc)desc);
        store.getTableFormatter().format();
    }

    @AfterClass
    public static void teardownClass() {
        if (sdb != null) {
            sdb = null;
        }
    }

    @Test
    public void prefix1() {
        PrefixMappingSDB pmap = new PrefixMappingSDB(defaultPrefixURI, sdb);
    }

    @Test
    public void prefix2() {
        PrefixMappingSDB pmap = new PrefixMappingSDB(defaultPrefixURI, sdb);
        pmap.setNsPrefix("ex", "http://example/");
        Assert.assertNotNull((Object)pmap.getNsPrefixURI("ex"));
    }

    @Test
    public void prefix3() {
        String uri = "http://example/";
        PrefixMappingSDB pmap = new PrefixMappingSDB(defaultPrefixURI, sdb);
        pmap.setNsPrefix("ex", uri);
        PrefixMappingSDB pmap2 = new PrefixMappingSDB(defaultPrefixURI, sdb);
        String x = pmap2.getNsPrefixURI("ex");
        Assert.assertNotNull((Object)x);
        Assert.assertEquals((Object)uri, (Object)x);
    }

    @Test
    public void prefix4() {
        String uri = "http://example/";
        PrefixMappingSDB pmap = new PrefixMappingSDB(defaultPrefixURI, sdb);
        pmap.setNsPrefix("ex", uri);
        Assert.assertEquals((Object)"ex", (Object)pmap.getNsURIPrefix("http://example/"));
    }

    @Test
    public void prefix5() {
        String uri = "http://example/";
        PrefixMappingSDB pmap = new PrefixMappingSDB(defaultPrefixURI, sdb);
        pmap.setNsPrefix("ex", uri);
        Assert.assertEquals((Object)(uri + "foo"), (Object)pmap.expandPrefix("ex:foo"));
    }

    @Test
    public void prefix6() {
        String uri = "http://example/";
        PrefixMappingSDB pmap = new PrefixMappingSDB(defaultPrefixURI, sdb);
        pmap.setNsPrefix("ex", uri);
        Assert.assertEquals((Object)"ex:foo", (Object)pmap.qnameFor("http://example/foo"));
    }

    @Test
    public void prefix7() {
        String uri1 = "http://example/";
        String uri2 = "http://example/ns#";
        PrefixMappingSDB pmap = new PrefixMappingSDB(defaultPrefixURI, sdb);
        pmap.setNsPrefix("ex1", uri1);
        pmap.setNsPrefix("ex2", uri2);
        Assert.assertEquals((Object)"ex2:foo", (Object)pmap.qnameFor("http://example/ns#foo"));
    }
}

