/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.test.misc;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sdb.SDBFactory;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SDBConnectionFactory;
import com.hp.hpl.jena.sdb.store.DatabaseType;
import com.hp.hpl.jena.sdb.store.LayoutType;
import com.hp.hpl.jena.sdb.store.StoreFactory;
import com.hp.hpl.jena.sdb.test.junit.ParamAllStores;
import com.hp.hpl.jena.sparql.sse.SSE;
import java.sql.Connection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestConnectionPooled
extends ParamAllStores {
    Connection conn;

    public TestConnectionPooled(String name, Store store) {
        super(name, store);
    }

    @Before
    public void before() {
        this.store.getTableFormatter().create();
        this.conn = this.store.getConnection().getSqlConnection();
    }

    @After
    public void after() {
    }

    @Test
    public void reuseJDBCConection() {
        Triple t1 = SSE.parseTriple((String)"(:x1 :p :z)");
        Triple t2 = SSE.parseTriple((String)"(:x2 :p :z)");
        boolean explicitTransactions = false;
        SDBConnection sConn1 = SDBConnectionFactory.create((Connection)this.conn);
        Store store1 = StoreFactory.create((SDBConnection)sConn1, (LayoutType)this.store.getLayoutType(), (DatabaseType)this.store.getDatabaseType());
        if (explicitTransactions) {
            store1.getConnection().getTransactionHandler().begin();
        }
        Graph graph1 = SDBFactory.connectDefaultGraph((Store)store1);
        graph1.add(t1);
        Assert.assertTrue((boolean)graph1.contains(t1));
        if (explicitTransactions) {
            store1.getConnection().getTransactionHandler().commit();
            Assert.assertTrue((boolean)graph1.contains(t1));
        }
        SDBConnection sConn2 = SDBConnectionFactory.create((Connection)this.conn);
        Store store2 = StoreFactory.create((SDBConnection)sConn2, (LayoutType)this.store.getLayoutType(), (DatabaseType)this.store.getDatabaseType());
        if (explicitTransactions) {
            store2.getConnection().getTransactionHandler().begin();
        }
        Graph graph2 = SDBFactory.connectDefaultGraph((Store)store2);
        Assert.assertTrue((boolean)graph2.contains(t1));
        graph2.add(t2);
        Assert.assertTrue((boolean)graph2.contains(t2));
        if (explicitTransactions) {
            store2.getConnection().getTransactionHandler().commit();
        }
        System.exit(0);
    }
}

