/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.test.misc;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sdb.SDBFactory;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.StoreDesc;
import com.hp.hpl.jena.sdb.store.DatasetStoreGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.util.FileManager;
import java.sql.Connection;
import org.junit.Assert;
import org.junit.Test;

public class TestAssembler {
    static final String dir = "testing/Assembler/";

    @Test
    public void dataset_1() {
        Dataset ds = DatasetFactory.assemble((String)"testing/Assembler/dataset.ttl");
        Assert.assertNotNull((Object)ds);
        DatasetGraph dsg = ds.asDatasetGraph();
        Assert.assertTrue((boolean)(dsg instanceof DatasetStoreGraph));
    }

    @Test
    public void connection_1() {
        Connection jdbc = SDBFactory.createSqlConnection((String)"testing/Assembler/connection.ttl");
        Assert.assertNotNull((Object)jdbc);
    }

    @Test
    public void store_1() {
        Store store = SDBFactory.connectStore((String)"testing/Assembler/store.ttl");
        Assert.assertNotNull((Object)store);
    }

    @Test
    public void model_1() {
        Model assem = FileManager.get().loadModel("testing/Assembler/graph-assembler.ttl");
        Resource x = assem.getResource("http://example/test#graphDft");
        Model model = (Model)Assembler.general.open(x);
        Assert.assertNotNull((Object)model);
    }

    @Test
    public void model_2() {
        Model assem = FileManager.get().loadModel("testing/Assembler/graph-assembler.ttl");
        Resource x = assem.getResource("http://example/test#graphNamed");
        Model model = (Model)Assembler.general.open(x);
        Assert.assertNotNull((Object)model);
    }

    private Store create(Model assem) {
        Dataset ds = DatasetFactory.assemble((Model)assem);
        Store store = ((DatasetStoreGraph)ds.asDatasetGraph()).getStore();
        store.getTableFormatter().create();
        return store;
    }

    @Test
    public void model_3() {
        Model model2;
        Model assem = FileManager.get().loadModel("testing/Assembler/graph-assembler.ttl");
        Resource xDft = assem.getResource("http://example/test#graphDft");
        Resource xNamed = assem.getResource("http://example/test#graphNamed");
        Store store = this.create(assem);
        Model model1 = (Model)Assembler.general.open(xDft);
        Assert.assertNotNull((Object)(model1 != (model2 = (Model)Assembler.general.open(xNamed)) ? 1 : 0));
    }

    @Test
    public void model_4() {
        Model assem = FileManager.get().loadModel("testing/Assembler/graph-assembler.ttl");
        Resource xDft = assem.getResource("http://example/test#graphDft");
        Resource xNamed = assem.getResource("http://example/test#graphNamed");
        Store store = this.create(assem);
        Model model1 = (Model)Assembler.general.open(xDft);
        Model model2 = (Model)Assembler.general.open(xNamed);
        Resource s = model1.createResource();
        Property p = model1.createProperty("http://example/p");
        Literal o = model1.createLiteral("foo");
        model1.add(s, p, (RDFNode)o);
        Assert.assertTrue((boolean)model1.contains(s, p, (RDFNode)o));
        Assert.assertTrue((model1.size() == 1L ? 1 : 0) != 0);
        Assert.assertTrue((model2.size() == 0L ? 1 : 0) != 0);
        Assert.assertFalse((boolean)model1.isIsomorphicWith(model2));
    }

    @Test
    public void model_5() {
        Model assem = FileManager.get().loadModel("testing/Assembler/graph-assembler.ttl");
        Resource xDft = assem.getResource("http://example/test#graphDft");
        Store store = this.create(assem);
        Model model2 = (Model)Assembler.general.open(xDft);
        Model model3 = (Model)Assembler.general.open(xDft);
        Resource s = model2.createResource();
        Property p = model2.createProperty("http://example/p");
        Literal o2 = model2.createLiteral("xyz");
        model2.add(s, p, (RDFNode)o2);
        Assert.assertTrue((boolean)model3.contains(s, p, (RDFNode)o2));
    }

    @Test
    public void model_6() {
        Model assem = FileManager.get().loadModel("testing/Assembler/graph-assembler.ttl");
        Resource xNamed = assem.getResource("http://example/test#graphNamed");
        Store store = this.create(assem);
        Model model2 = (Model)Assembler.general.open(xNamed);
        Model model3 = (Model)Assembler.general.open(xNamed);
        Resource s = model2.createResource();
        Property p = model2.createProperty("http://example/p");
        Literal o2 = model2.createLiteral("xyz");
        model2.add(s, p, (RDFNode)o2);
        Assert.assertTrue((boolean)model3.contains(s, p, (RDFNode)o2));
    }

    @Test
    public void pool_1() {
        Connection conn = SDBFactory.createSqlConnection((String)"testing/Assembler/connection.ttl");
        StoreDesc desc = StoreDesc.read((String)"testing/Assembler/dataset2.ttl");
        Store store = SDBFactory.connectStore((Connection)conn, (StoreDesc)desc);
    }
}

