/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.test.junit;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.StoreDesc;
import com.hp.hpl.jena.sdb.store.StoreFactory;
import com.hp.hpl.jena.sdb.util.Pair;
import com.hp.hpl.jena.sdb.util.Vocab;
import com.hp.hpl.jena.util.FileManager;
import java.util.ArrayList;
import java.util.List;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.iterator.Transform;
import org.openjena.atlas.lib.StrUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreList {
    static Property description = Vocab.property((String)"http://jena.hpl.hp.com/2007/sdb#", (String)"description");
    static Property list = Vocab.property((String)"http://jena.hpl.hp.com/2007/sdb#", (String)"list");
    static Resource storeListClass = Vocab.property((String)"http://jena.hpl.hp.com/2007/sdb#", (String)"StoreList");
    static boolean formatStores = false;
    static String queryString = StrUtils.strjoinNL((String[])new String[]{"PREFIX sdb:      <http://jena.hpl.hp.com/2007/sdb#>", "PREFIX rdf:      <http://www.w3.org/1999/02/22-rdf-syntax-ns#>", "PREFIX rdfs:     <http://www.w3.org/2000/01/rdf-schema#>", "PREFIX list:     <http://jena.hpl.hp.com/ARQ/list#>", "SELECT ?desc ?label", "{ [] rdf:type sdb:StoreList ;", "     sdb:list ?l .", "  ?l list:member [ rdfs:label ?label ; sdb:description ?desc ]", "}"});
    static Transform<Pair<String, String>, Pair<String, StoreDesc>> t1 = new Transform<Pair<String, String>, Pair<String, StoreDesc>>(){

        public Pair<String, StoreDesc> convert(Pair<String, String> pair) {
            return new Pair(pair.car(), (Object)StoreDesc.read((String)((String)pair.cdr())));
        }
    };
    static Transform<Pair<String, StoreDesc>, Pair<String, Store>> t2 = new Transform<Pair<String, StoreDesc>, Pair<String, Store>>(){

        public Pair<String, Store> convert(Pair<String, StoreDesc> pair) {
            Store store = StoreList.testStore((StoreDesc)pair.cdr());
            return new Pair(pair.car(), (Object)store);
        }
    };

    public static Store testStore(StoreDesc desc) {
        boolean isInMem;
        Store store = StoreFactory.create((StoreDesc)desc);
        String jdbcURL = store.getConnection().getJdbcURL();
        boolean bl = isInMem = jdbcURL == null ? false : jdbcURL.contains(":mem:");
        if (formatStores || StoreList.inMem(store)) {
            store.getTableFormatter().create();
        }
        return store;
    }

    public static boolean inMem(Store store) {
        String jdbcURL = store.getConnection().getJdbcURL();
        return jdbcURL == null ? false : jdbcURL.contains(":mem:");
    }

    public static List<Pair<String, StoreDesc>> stores(String fn) {
        List<Pair<String, String>> x = StoreList.storesByQuery(fn);
        List z = Iter.iter(x).map(t1).toList();
        return z;
    }

    public static List<Pair<String, StoreDesc>> storeDesc(String fn) {
        List<Pair<String, String>> x = StoreList.storesByQuery(fn);
        List y = Iter.iter(x).map(t1).toList();
        return y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Pair<String, String>> storesByQuery(String fn) {
        Model model = FileManager.get().loadModel(fn);
        ArrayList<Pair<String, String>> data = new ArrayList<Pair<String, String>>();
        Query query = QueryFactory.create((String)queryString);
        QueryExecution qExec = QueryExecutionFactory.create((Query)query, (Model)model);
        try {
            ResultSet rs = qExec.execSelect();
            while (rs.hasNext()) {
                QuerySolution qs = rs.nextSolution();
                String label = qs.getLiteral("label").getLexicalForm();
                String desc = qs.getResource("desc").getURI();
                data.add((Pair<String, String>)new Pair((Object)label, (Object)desc));
            }
        }
        finally {
            qExec.close();
        }
        return data;
    }
}

