/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.test;

import com.hp.hpl.jena.sdb.SDBFactory;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.StoreDesc;
import com.hp.hpl.jena.sdb.layout2.hash.StoreTriplesNodesHashDB2;
import com.hp.hpl.jena.sdb.layout2.hash.StoreTriplesNodesHashDerby;
import com.hp.hpl.jena.sdb.layout2.hash.StoreTriplesNodesHashHSQL;
import com.hp.hpl.jena.sdb.layout2.hash.StoreTriplesNodesHashMySQL;
import com.hp.hpl.jena.sdb.layout2.hash.StoreTriplesNodesHashOracle;
import com.hp.hpl.jena.sdb.layout2.hash.StoreTriplesNodesHashPGSQL;
import com.hp.hpl.jena.sdb.layout2.hash.StoreTriplesNodesHashSQLServer;
import com.hp.hpl.jena.sdb.layout2.index.StoreTriplesNodesIndexDB2;
import com.hp.hpl.jena.sdb.layout2.index.StoreTriplesNodesIndexDerby;
import com.hp.hpl.jena.sdb.layout2.index.StoreTriplesNodesIndexHSQL;
import com.hp.hpl.jena.sdb.layout2.index.StoreTriplesNodesIndexMySQL;
import com.hp.hpl.jena.sdb.layout2.index.StoreTriplesNodesIndexOracle;
import com.hp.hpl.jena.sdb.layout2.index.StoreTriplesNodesIndexPGSQL;
import com.hp.hpl.jena.sdb.layout2.index.StoreTriplesNodesIndexSQLServer;
import com.hp.hpl.jena.sdb.sql.JDBC;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.store.DatabaseType;
import com.hp.hpl.jena.sdb.store.LayoutType;

public class StoreCreator {
    private static StoreTriplesNodesHashPGSQL sdbpgh;
    private static StoreTriplesNodesIndexPGSQL sdbpgi;
    private static StoreTriplesNodesHashMySQL sdbmsh;
    private static StoreTriplesNodesIndexMySQL sdbmsi;
    private static StoreTriplesNodesIndexSQLServer sdbssi;
    private static StoreTriplesNodesHashSQLServer sdbssh;
    private static StoreTriplesNodesIndexHSQL sdbhsi;
    private static StoreTriplesNodesHashHSQL sdbhsh;
    private static StoreTriplesNodesHashDerby sdbdh;
    private static StoreTriplesNodesIndexDerby sdbdi;
    private static StoreTriplesNodesHashOracle sdboh;
    private static StoreTriplesNodesIndexOracle sdboi;
    private static StoreTriplesNodesIndexDB2 sdbdb2i;
    private static StoreTriplesNodesHashDB2 sdbdb2h;
    private static final String MSSQL_url = "jdbc:sqlserver://localhost\\SQLEXPRESS;databaseName=";
    private static final String MSSQL_user = "user";
    private static final String MSSQL_password = "password";

    public static Store getIndexMySQL() {
        if (sdbmsi == null) {
            JDBC.loadDriverMySQL();
            SDBConnection sdb = SDBFactory.createConnection((String)"jdbc:mysql://localhost/test2-index", (String)MSSQL_user, (String)MSSQL_password);
            StoreDesc desc = new StoreDesc(LayoutType.LayoutTripleNodesIndex, DatabaseType.MySQL);
            sdbmsi = new StoreTriplesNodesIndexMySQL(sdb, desc);
            sdbmsi.getTableFormatter().create();
        } else {
            sdbmsi.getTableFormatter().truncate();
        }
        return sdbmsi;
    }

    public static Store getHashMySQL() {
        if (sdbmsh == null) {
            JDBC.loadDriverMySQL();
            SDBConnection sdb = SDBFactory.createConnection((String)"jdbc:mysql://localhost/test2-hash", (String)MSSQL_user, (String)MSSQL_password);
            StoreDesc desc = new StoreDesc(LayoutType.LayoutTripleNodesHash, DatabaseType.MySQL);
            sdbmsh = new StoreTriplesNodesHashMySQL(sdb, desc);
            sdbmsh.getTableFormatter().create();
        } else {
            sdbmsh.getTableFormatter().truncate();
        }
        return sdbmsh;
    }

    public static Store getIndexHSQL() {
        if (sdbhsi == null) {
            JDBC.loadDriverHSQL();
            SDBConnection sdb = SDBFactory.createConnection((String)"jdbc:hsqldb:mem:aname", (String)"sa", (String)"");
            StoreDesc desc = new StoreDesc(LayoutType.LayoutTripleNodesIndex, DatabaseType.HSQLDB);
            sdbhsi = new StoreTriplesNodesIndexHSQL(sdb, desc);
            sdbhsi.getTableFormatter().create();
        } else {
            sdbhsi.getTableFormatter().truncate();
        }
        return sdbhsi;
    }

    public static Store getHashHSQL() {
        if (sdbhsh == null) {
            JDBC.loadDriverHSQL();
            SDBConnection sdb = SDBFactory.createConnection((String)"jdbc:hsqldb:mem:bname", (String)"sa", (String)"");
            StoreDesc desc = new StoreDesc(LayoutType.LayoutTripleNodesHash, DatabaseType.HSQLDB);
            sdbhsh = new StoreTriplesNodesHashHSQL(sdb, desc);
            sdbhsh.getTableFormatter().create();
        } else {
            sdbhsh.getTableFormatter().truncate();
        }
        return sdbhsh;
    }

    public static Store getIndexPgSQL() {
        if (sdbpgi == null) {
            JDBC.loadDriverPGSQL();
            SDBConnection sdb = SDBFactory.createConnection((String)"jdbc:postgresql://localhost/test2-index", (String)MSSQL_user, (String)MSSQL_password);
            StoreDesc desc = new StoreDesc(LayoutType.LayoutTripleNodesIndex, DatabaseType.PostgreSQL);
            sdbpgi = new StoreTriplesNodesIndexPGSQL(sdb, desc);
            sdbpgi.getTableFormatter().create();
        } else {
            sdbpgi.getTableFormatter().truncate();
        }
        return sdbpgi;
    }

    public static Store getHashPgSQL() {
        if (sdbpgh == null) {
            JDBC.loadDriverPGSQL();
            SDBConnection sdb = SDBFactory.createConnection((String)"jdbc:postgresql://localhost/test2-hash", (String)MSSQL_user, (String)MSSQL_password);
            StoreDesc desc = new StoreDesc(LayoutType.LayoutTripleNodesHash, DatabaseType.PostgreSQL);
            sdbpgh = new StoreTriplesNodesHashPGSQL(sdb, desc);
            sdbpgh.getTableFormatter().create();
        } else {
            sdbpgh.getTableFormatter().truncate();
        }
        return sdbpgh;
    }

    public static Store getIndexSQLServer() {
        if (sdbssi == null) {
            JDBC.loadDriverSQLServer();
            SDBConnection sdb = SDBFactory.createConnection((String)"jdbc:sqlserver://localhost\\SQLEXPRESS;databaseName=test2-index", (String)MSSQL_user, (String)MSSQL_password);
            StoreDesc desc = new StoreDesc(LayoutType.LayoutTripleNodesIndex, DatabaseType.SQLServer);
            sdbssi = new StoreTriplesNodesIndexSQLServer(sdb, desc);
            sdbssi.getTableFormatter().create();
        } else {
            sdbssi.getTableFormatter().truncate();
        }
        return sdbssi;
    }

    public static Store getHashSQLServer() {
        if (sdbssh == null) {
            JDBC.loadDriverSQLServer();
            SDBConnection sdb = SDBFactory.createConnection((String)"jdbc:sqlserver://localhost\\SQLEXPRESS;databaseName=test2-hash", (String)MSSQL_user, (String)MSSQL_password);
            StoreDesc desc = new StoreDesc(LayoutType.LayoutTripleNodesHash, DatabaseType.SQLServer);
            sdbssh = new StoreTriplesNodesHashSQLServer(sdb, desc);
            sdbssh.getTableFormatter().create();
        } else {
            sdbssh.getTableFormatter().truncate();
        }
        return sdbssh;
    }

    public static Store getHashDerby() {
        if (sdbdh == null) {
            JDBC.loadDriverDerby();
            String url = JDBC.makeURL((String)"derby", (String)"localhost", (String)"DB/test2-hash");
            SDBConnection sdb = new SDBConnection(url, null, null);
            StoreDesc desc = new StoreDesc(LayoutType.LayoutTripleNodesHash, DatabaseType.Derby);
            sdbdh = new StoreTriplesNodesHashDerby(sdb, desc);
            sdbdh.getTableFormatter().create();
        } else {
            sdbdh.getTableFormatter().truncate();
        }
        return sdbdh;
    }

    public static Store getIndexDerby() {
        if (sdbdi == null) {
            JDBC.loadDriverDerby();
            String url = JDBC.makeURL((String)"derby", (String)"localhost", (String)"DB/test2-index");
            SDBConnection sdb = new SDBConnection(url, null, null);
            StoreDesc desc = new StoreDesc(LayoutType.LayoutTripleNodesIndex, DatabaseType.Derby);
            sdbdi = new StoreTriplesNodesIndexDerby(sdb, desc);
            sdbdi.getTableFormatter().create();
        } else {
            sdbdi.getTableFormatter().truncate();
        }
        return sdbdi;
    }

    public static Store getHashOracle() {
        if (sdboh == null) {
            JDBC.loadDriverOracle();
            String url = JDBC.makeURL((String)"oracle:thin", (String)"localhost:1521", (String)"XE");
            SDBConnection sdb = new SDBConnection(url, "test2-hash", "test2-hash");
            StoreDesc desc = new StoreDesc(LayoutType.LayoutTripleNodesHash, DatabaseType.Oracle);
            sdboh = new StoreTriplesNodesHashOracle(sdb, desc);
            sdboh.getTableFormatter().create();
        } else {
            sdboh.getTableFormatter().truncate();
        }
        return sdboh;
    }

    public static Store getIndexOracle() {
        if (sdboi == null) {
            JDBC.loadDriverOracle();
            String url = JDBC.makeURL((String)"oracle:thin", (String)"localhost:1521", (String)"XE");
            SDBConnection sdb = new SDBConnection(url, "test2-index", "test2-index");
            StoreDesc desc = new StoreDesc(LayoutType.LayoutTripleNodesIndex, DatabaseType.Oracle);
            sdboi = new StoreTriplesNodesIndexOracle(sdb, desc);
            sdboi.getTableFormatter().create();
        } else {
            sdboi.getTableFormatter().truncate();
        }
        return sdboi;
    }

    public static Store getHashDB2() {
        if (sdbdb2h == null) {
            JDBC.loadDriverDB2();
            String url = JDBC.makeURL((String)"db2", (String)"sweb-sdb-4:50000", (String)"TEST2H");
            SDBConnection sdb = new SDBConnection(url, MSSQL_user, MSSQL_password);
            StoreDesc desc = new StoreDesc(LayoutType.LayoutTripleNodesHash, DatabaseType.DB2);
            sdbdb2h = new StoreTriplesNodesHashDB2(sdb, desc);
            sdbdb2h.getTableFormatter().create();
        } else {
            sdbdb2h.getTableFormatter().truncate();
        }
        return sdbdb2h;
    }

    public static Store getIndexDB2() {
        if (sdbdb2i == null) {
            JDBC.loadDriverDB2();
            String url = JDBC.makeURL((String)"db2", (String)"sweb-sdb-4:50000", (String)"TEST2I");
            SDBConnection sdb = new SDBConnection(url, MSSQL_user, MSSQL_password);
            StoreDesc desc = new StoreDesc(LayoutType.LayoutTripleNodesIndex, DatabaseType.DB2);
            sdbdb2i = new StoreTriplesNodesIndexDB2(sdb, desc);
            sdbdb2i.getTableFormatter().create();
        }
        sdbdb2i.getTableFormatter().truncate();
        return sdbdb2i;
    }
}

