/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.tokens;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.junit.Test;
import org.openjena.atlas.io.PeekReader;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.StrUtils;
import org.openjena.riot.RiotParseException;
import org.openjena.riot.tokens.Token;
import org.openjena.riot.tokens.TokenType;
import org.openjena.riot.tokens.Tokenizer;
import org.openjena.riot.tokens.TokenizerFactory;
import org.openjena.riot.tokens.TokenizerText;

public class TestTokenizer
extends BaseTest {
    private static Tokenizer tokenizer(String string) {
        PeekReader r = PeekReader.readString((String)string);
        TokenizerText tokenizer = new TokenizerText(r);
        return tokenizer;
    }

    private static Token token(String string) {
        Tokenizer tokenizer = TestTokenizer.tokenizer(string);
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
        return token;
    }

    @Test
    public void tokenUnit_iri1() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("<x>");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.IRI, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"x", (Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenUnit_iri2() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("   <>   ");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.IRI, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"", (Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenUnit_iri3() {
        try {
            Tokenizer tokenizer = TestTokenizer.tokenizer("   <abc\\>   123");
        }
        catch (RiotParseException ex) {
            String x = ex.getMessage();
            TestTokenizer.assertTrue((boolean)"illegal escape sequence value: >".equalsIgnoreCase(x));
        }
    }

    @Test
    public void tokenUnit_str1() {
        Token token = TestTokenizer.token("   'abc'   ");
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.STRING1, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"abc", (Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
    }

    @Test
    public void tokenUnit_str2() {
        Token token = TestTokenizer.token("''");
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.STRING1, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"", (Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
    }

    @Test
    public void tokenUnit_str3() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'\\u0020'");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.STRING1, (Object)token.getType());
        TestTokenizer.assertEquals((Object)" ", (Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenUnit_str4() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'a\\'\\\"\\n\\t\\r'");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.STRING1, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"a'\"\n\t\r", (Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test(expected=RiotParseException.class)
    public void tokenUnit_str5() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'\n'");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
    }

    @Test
    public void tokenUnit_str6() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("   \"abc\"   ");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.STRING2, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"abc", (Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenUnit_str7() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("\"\"");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.STRING2, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"", (Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test(expected=RiotParseException.class)
    public void tokenUnit_str8() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("\"");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
    }

    @Test(expected=RiotParseException.class)
    public void tokenUnit_str9() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'abc");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenUnit_str10() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'\\'abc'");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.STRING1, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"'abc", (Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenUnit_str11() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'\\U00000020'");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.STRING1, (Object)token.getType());
        TestTokenizer.assertEquals((Object)" ", (Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenUnit_str_long1() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'''aaa'''");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.LONG_STRING1, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"aaa", (Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenUnit_str_long2() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("\"\"\"aaa\"\"\"");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.LONG_STRING2, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"aaa", (Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenUnit_str_long3() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("''''1234'''");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.LONG_STRING1, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"'1234", (Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenUnit_str_long4() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'''''1234'''");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.LONG_STRING1, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"''1234", (Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenUnit_str_long5() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'''\\'''1234'''");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.LONG_STRING1, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"'''1234", (Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenUnit_str_long6() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("\"\"\"\"1234\"\"\"");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.LONG_STRING2, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"\"1234", (Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenUnit_str_long7() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("\"\"\"\"\"1234\"\"\"");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.LONG_STRING2, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"\"\"1234", (Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenUnit_str_long8() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("''''''");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.LONG_STRING1, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"", (Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenUnit_str_long9() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("\"\"\"'''''''''''''''''\"\"\"");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.LONG_STRING2, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"'''''''''''''''''", (Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test(expected=RiotParseException.class)
    public void tokenUnit_str_long10() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("\"\"\"abcdef");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
    }

    @Test(expected=RiotParseException.class)
    public void tokenUnit_str_long11() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'''");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
    }

    public void tokenUnit_str_long12() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'''x'''@en");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
    }

    public void tokenUnit_str_long13() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'''123'''^^<xyz>");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenUnit_bNode1() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("_:abc");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.BNODE, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"abc", (Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenUnit_bNode2() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("_:123 ");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.BNODE, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"123", (Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test(expected=RiotParseException.class)
    public void tokenUnit_bNode3() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("_:");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
    }

    @Test
    public void tokenUnit_bNode4() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("_:1-2-Z ");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.BNODE, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"1-2-Z", (Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenUnit_bNode5() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("_:x.    ");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.BNODE, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"x", (Object)token.getImage());
        token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.DOT, (Object)token.getType());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenUnit_bNode6() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("_:x:a.    ");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.BNODE, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"x", (Object)token.getImage());
        token = tokenizer.next();
        TestTokenizer.assertEquals((Object)TokenType.PREFIXED_NAME, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"", (Object)token.getImage());
        TestTokenizer.assertEquals((Object)"a", (Object)token.getImage2());
        token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.DOT, (Object)token.getType());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenUnit_cntrl1() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("*S");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.CNTRL, (Object)token.getType());
        TestTokenizer.assertEquals((long)83L, (long)token.getCntrlCode());
        TestTokenizer.assertNull((Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenUnit_cntr2() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("*SXYZ");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.CNTRL, (Object)token.getType());
        TestTokenizer.assertEquals((long)83L, (long)token.getCntrlCode());
        TestTokenizer.assertNull((Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
    }

    @Test
    public void tokenUnit_cntrl3() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("*S<x>");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.CNTRL, (Object)token.getType());
        TestTokenizer.assertEquals((long)83L, (long)token.getCntrlCode());
        TestTokenizer.assertNull((Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token2 = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token2);
        TestTokenizer.assertEquals((Object)TokenType.IRI, (Object)token2.getType());
        TestTokenizer.assertEquals((Object)"x", (Object)token2.getImage());
        TestTokenizer.assertNull((Object)token2.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenUnit_syntax1() {
        Tokenizer tokenizer = TestTokenizer.tokenizer(".");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.DOT, (Object)token.getType());
        TestTokenizer.assertNull((Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
    }

    @Test
    public void tokenUnit_syntax2() {
        Tokenizer tokenizer = TestTokenizer.tokenizer(".;,");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.DOT, (Object)token.getType());
        TestTokenizer.assertNull((Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token2 = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token2);
        TestTokenizer.assertEquals((Object)TokenType.SEMICOLON, (Object)token2.getType());
        TestTokenizer.assertEquals((Object)";", (Object)token2.getImage());
        TestTokenizer.assertNull((Object)token2.getImage2());
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token3 = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token3);
        TestTokenizer.assertEquals((Object)TokenType.COMMA, (Object)token3.getType());
        TestTokenizer.assertEquals((Object)",", (Object)token3.getImage());
        TestTokenizer.assertNull((Object)token3.getImage2());
    }

    @Test
    public void tokenUnit_pname1() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("a:b.c");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        this.pnameToken(token, "a", "b.c");
    }

    @Test
    public void tokenUnit_pname2() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("a:b.");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        this.pnameToken(token, "a", "b");
    }

    @Test
    public void tokenUnit_pname3() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("a:b123");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        this.pnameToken(token, "a", "b123");
    }

    @Test
    public void tokenUnit_pname4() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("a:");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        this.pnameToken(token, "a", "");
    }

    @Test
    public void tokenUnit_pname5() {
        Tokenizer tokenizer = TestTokenizer.tokenizer(":");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        this.pnameToken(token, "", "");
    }

    @Test
    public void tokenUnit_pname6() {
        Tokenizer tokenizer = TestTokenizer.tokenizer(":a");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        this.pnameToken(token, "", "a");
    }

    @Test
    public void tokenUnit_pname7() {
        Tokenizer tokenizer = TestTokenizer.tokenizer(":123");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        this.pnameToken(token, "", "123");
    }

    @Test
    public void tokenUnit_pname8() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("a123:456");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        this.pnameToken(token, "a123", "456");
    }

    @Test
    public void tokenUnit_pname9() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("a123:-456");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        this.pnameToken(token, "a123", "");
        token = tokenizer.next();
        TestTokenizer.assertEquals((Object)TokenType.INTEGER, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"-456", (Object)token.getImage());
    }

    private void pnameToken(Token token, String string1, String string2) {
        TestTokenizer.assertEquals((Object)TokenType.PREFIXED_NAME, (Object)token.getType());
        TestTokenizer.assertEquals((Object)string1, (Object)token.getImage());
        TestTokenizer.assertEquals((Object)string2, (Object)token.getImage2());
    }

    @Test
    public void tokenUnit_num1() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("123");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertEquals((Object)TokenType.INTEGER, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"123", (Object)token.getImage());
    }

    @Test
    public void tokenUnit_num2() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("123.");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertEquals((Object)TokenType.DECIMAL, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"123.", (Object)token.getImage());
    }

    @Test
    public void tokenUnit_num3() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("+123.456");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertEquals((Object)TokenType.DECIMAL, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"+123.456", (Object)token.getImage());
    }

    @Test
    public void tokenUnit_num4() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("-1");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertEquals((Object)TokenType.INTEGER, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"-1", (Object)token.getImage());
    }

    @Test
    public void tokenUnit_num5() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("-1e0");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertEquals((Object)TokenType.DOUBLE, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"-1e0", (Object)token.getImage());
    }

    @Test
    public void tokenUnit_num6() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("1e+1");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertEquals((Object)TokenType.DOUBLE, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"1e+1", (Object)token.getImage());
    }

    @Test
    public void tokenUnit_num7() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("1.3e+1");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertEquals((Object)TokenType.DOUBLE, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"1.3e+1", (Object)token.getImage());
    }

    @Test
    public void tokenUnit_num8() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("1.3.4");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertEquals((Object)TokenType.DECIMAL, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"1.3", (Object)token.getImage());
    }

    @Test
    public void tokenUnit_num9() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("1.3e67.7");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertEquals((Object)TokenType.DOUBLE, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"1.3e67", (Object)token.getImage());
    }

    @Test(expected=RiotParseException.class)
    public void tokenUnit_num10() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("+");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertEquals((Object)TokenType.KEYWORD, (Object)token.getType());
    }

    @Test(expected=RiotParseException.class)
    public void tokenUnit_num11() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("+-");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertEquals((Object)TokenType.KEYWORD, (Object)token.getType());
    }

    @Test
    public void tokenUnit_num12() {
        Tokenizer tokenizer = TestTokenizer.tokenizer(".");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertEquals((Object)TokenType.DOT, (Object)token.getType());
    }

    @Test
    public void tokenUnit_num13() {
        Tokenizer tokenizer = TestTokenizer.tokenizer(".a");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertEquals((Object)TokenType.DOT, (Object)token.getType());
    }

    @Test
    public void tokenUnit_num14() {
        Tokenizer tokenizer = TestTokenizer.tokenizer(".1");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertEquals((Object)TokenType.DECIMAL, (Object)token.getType());
        TestTokenizer.assertEquals((Object)".1", (Object)token.getImage());
    }

    @Test
    public void tokenUnit_num15() {
        Tokenizer tokenizer = TestTokenizer.tokenizer(".1e0");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertEquals((Object)TokenType.DOUBLE, (Object)token.getType());
        TestTokenizer.assertEquals((Object)".1e0", (Object)token.getImage());
    }

    @Test
    public void tokenUnit_num16() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("000A     .");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertEquals((Object)TokenType.INTEGER, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"000", (Object)token.getImage());
        Token token2 = tokenizer.next();
        TestTokenizer.assertEquals((Object)TokenType.KEYWORD, (Object)token2.getType());
        TestTokenizer.assertEquals((Object)"A", (Object)token2.getImage());
    }

    @Test
    public void tokenUnit_var1() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("?x ?y");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertEquals((Object)TokenType.VAR, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"x", (Object)token.getImage());
    }

    @Test
    public void tokenUnit_var2() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("? x");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertEquals((Object)TokenType.VAR, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"", (Object)token.getImage());
    }

    @Test
    public void tokenUnit_hex1() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("0xABC");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertEquals((Object)TokenType.HEX, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"0xABC", (Object)token.getImage());
    }

    @Test
    public void tokenUnit_hex2() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("0xABCXYZ");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertEquals((Object)TokenType.HEX, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"0xABC", (Object)token.getImage());
    }

    @Test(expected=RiotParseException.class)
    public void tokenUnit_hex3() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("0xXYZ");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenUnit_hex4() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("0Xabc");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertEquals((Object)TokenType.HEX, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"0Xabc", (Object)token.getImage());
    }

    @Test
    public void tokenLiteralDT_0() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'123'^^<x> ");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.LITERAL_DT, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"123", (Object)token.getImage());
        Token token2 = token.getSubToken();
        TestTokenizer.assertEquals((Object)TokenType.IRI, (Object)token2.getType());
        TestTokenizer.assertEquals((Object)"x", (Object)token2.getImage());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenLiteralDT_1() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'123'^^x:y");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.LITERAL_DT, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"123", (Object)token.getImage());
        Token token2 = token.getSubToken();
        TestTokenizer.assertEquals((Object)TokenType.PREFIXED_NAME, (Object)token2.getType());
        TestTokenizer.assertEquals((Object)"x", (Object)token2.getImage());
        TestTokenizer.assertEquals((Object)"y", (Object)token2.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenLiteralDT_2() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'123'^^:y");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.LITERAL_DT, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"123", (Object)token.getImage());
        Token token2 = token.getSubToken();
        TestTokenizer.assertEquals((Object)TokenType.PREFIXED_NAME, (Object)token2.getType());
        TestTokenizer.assertEquals((Object)"", (Object)token2.getImage());
        TestTokenizer.assertEquals((Object)"y", (Object)token2.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test(expected=RiotParseException.class)
    public void tokenLiteralDT_bad_1() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'123'^^ <x> ");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
    }

    @Test(expected=RiotParseException.class)
    public void tokenLiteralDT_bad_2() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'123' ^^<x> ");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.STRING1, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"123", (Object)token.getImage());
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token2 = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token2);
    }

    @Test(expected=RiotParseException.class)
    public void tokenLiteralDT_bad_3() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'123'^ ^<x> ");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
    }

    @Test(expected=RiotParseException.class)
    public void tokenLiteralDT_bad_4() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'123'^^ x:y");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
    }

    @Test
    public void tokenLiteralLang_0() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'a'@en");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.LITERAL_LANG, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"a", (Object)token.getImage());
        TestTokenizer.assertEquals((Object)"en", (Object)token.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenLiteralLang_1() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'a'@en-UK ");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.LITERAL_LANG, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"a", (Object)token.getImage());
        TestTokenizer.assertEquals((Object)"en-UK", (Object)token.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenLiteralLang_2() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'' @lang ");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.STRING1, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"", (Object)token.getImage());
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token2 = tokenizer.next();
        TestTokenizer.assertEquals((Object)TokenType.DIRECTIVE, (Object)token2.getType());
        TestTokenizer.assertEquals((Object)"lang", (Object)token2.getImage());
        TestTokenizer.assertNotNull((Object)token2);
    }

    @Test(expected=RiotParseException.class)
    public void tokenLiteralLang_3() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("''@ lang ");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
    }

    @Test(expected=RiotParseException.class)
    public void tokenLiteralLang_4() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("''@lang- ");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
    }

    @Test(expected=RiotParseException.class)
    public void tokenLiteralLang_5() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("''@- ");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
    }

    @Test
    public void tokenLiteralLang_6() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("''@a-b-c ");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.LITERAL_LANG, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"", (Object)token.getImage());
        TestTokenizer.assertEquals((Object)"a-b-c", (Object)token.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenLiteralLang_7() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("''@a-b9z-c99 ");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.LITERAL_LANG, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"", (Object)token.getImage());
        TestTokenizer.assertEquals((Object)"a-b9z-c99", (Object)token.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test(expected=RiotParseException.class)
    public void tokenLiteralLang_8() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("''@9-b");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
    }

    @Test
    public void tokenComment_01() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("_:123 # Comment");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.BNODE, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"123", (Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenComment_02() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'foo # Non-Comment'");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.STRING1, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"foo # Non-Comment", (Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenComment_03() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'foo' # Comment\n'bar'");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.STRING1, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"foo", (Object)token.getImage());
        TestTokenizer.assertNull((Object)token.getImage2());
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token2 = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token2);
        TestTokenizer.assertEquals((Object)TokenType.STRING1, (Object)token2.getType());
        TestTokenizer.assertEquals((Object)"bar", (Object)token2.getImage());
        TestTokenizer.assertNull((Object)token2.getImage2());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenWord_01() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("abc");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.KEYWORD, (Object)token.getType());
    }

    @Test
    public void token_multiple() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("<x><y>");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.IRI, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"x", (Object)token.getImage());
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token2 = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token2);
        TestTokenizer.assertEquals((Object)TokenType.IRI, (Object)token2.getType());
        TestTokenizer.assertEquals((Object)"y", (Object)token2.getImage());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    private static ByteArrayInputStream bytes(String string) {
        byte[] b = StrUtils.asUTF8bytes((String)string);
        return new ByteArrayInputStream(b);
    }

    @Test
    public void tokenizer_charset_1() {
        ByteArrayInputStream in = TestTokenizer.bytes("'abc'");
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerASCII((InputStream)in);
        Token t = tokenizer.next();
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test(expected=RiotParseException.class)
    public void tokenizer_charset_2() {
        ByteArrayInputStream in = TestTokenizer.bytes("'abcd\u00e9'");
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerASCII((InputStream)in);
        Token t = tokenizer.next();
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test(expected=RiotParseException.class)
    public void tokenizer_charset_3() {
        ByteArrayInputStream in = TestTokenizer.bytes("<http://example/abcd\u00e9>");
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerASCII((InputStream)in);
        Token t = tokenizer.next();
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    private static void testSymbol(String string, TokenType expected) {
        Tokenizer tokenizer = TestTokenizer.tokenizer(string);
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertEquals((Object)expected, (Object)token.getType());
    }

    @Test
    public void tokenizer_symbol_05() {
        TestTokenizer.testSymbol(">", TokenType.GT);
    }

    @Test
    public void tokenizer_symbol_06() {
        TestTokenizer.testSymbol("=", TokenType.EQUALS);
    }
}

