/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.out;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.sse.SSE;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.riot.out.OutputLangUtils;
import org.openjena.riot.system.Prologue;

public class TestOutput
extends BaseTest {
    static Prologue prologue = new Prologue(null);

    @Test
    public void output_01() {
        TestOutput.testStringForNode("<http://example/>");
    }

    @Test
    public void output_02() {
        TestOutput.testStringForNode("''");
    }

    @Test
    public void output_03() {
        TestOutput.testStringForNode("'abc'@en");
    }

    @Test
    public void output_04() {
        TestOutput.testStringForNode("'abc'^^<http://exmaple/dt>");
    }

    @Test
    public void output_05() {
        TestOutput.testStringForNode("'\u00e9'", "\"\\u00E9\"");
    }

    @Test
    public void output_06() {
        TestOutput.testStringForNode("'\\n\\t\\f'", "\"\\n\\t\\f\"");
    }

    @Test
    public void output_10() {
        TestOutput.testStringForNode("<http://example/>", ":", prologue);
    }

    @Test
    public void output_11() {
        TestOutput.testStringForNode("<http://example/abc>", "x:bc", prologue);
    }

    @Test
    public void output_12() {
        TestOutput.testStringForNode("123", "\"123\"^^xsd:integer", prologue);
    }

    private static void testStringForNode(String nodeStr) {
        String expected = nodeStr.replace("'", "\"");
        TestOutput.testStringForNode(nodeStr, expected);
    }

    private static void testStringForNode(String nodeStr, String expected) {
        TestOutput.testStringForNode(nodeStr, expected, null);
    }

    private static void testStringForNode(String nodeStr, String expected, Prologue prologue) {
        String x = TestOutput.stringForNode(nodeStr, prologue, "ASCII");
        TestOutput.assertEquals((Object)expected, (Object)x);
    }

    private static String stringForNode(String nodeStr) {
        return TestOutput.stringForNode(nodeStr, null, "ASCII");
    }

    private static String stringForNode(String nodeStr, Prologue prologue, String encoding) {
        Node node = SSE.parseNode((String)nodeStr);
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)bytes, encoding);
            OutputLangUtils.output((Writer)w, (Node)node, (Prologue)prologue);
            ((Writer)w).flush();
            return bytes.toString(encoding);
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    static {
        prologue.getPrefixMap().add("", "http://example/");
        prologue.getPrefixMap().add("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        prologue.getPrefixMap().add("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        prologue.getPrefixMap().add("owl", "http://www.w3.org/2002/07/owl#");
        prologue.getPrefixMap().add("xsd", "http://www.w3.org/2001/XMLSchema#");
        prologue.getPrefixMap().add("x", "http://example/a");
    }
}

