/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.lang;

import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.lib.DatasetLib;
import junit.framework.TestCase;
import org.openjena.riot.Lang;
import org.openjena.riot.RiotLoader;
import org.openjena.riot.RiotParseException;

public class UnitTestTrig
extends TestCase {
    String input;
    String output;
    String baseIRI;

    public UnitTestTrig(String name, String input, String output, String baseIRI) {
        super(name);
        this.input = input;
        this.output = output;
        this.baseIRI = baseIRI;
    }

    public void runTest() {
        try {
            DatasetGraph dsg = DatasetLib.createDatasetGraphMem();
            RiotLoader.read((String)this.input, (DatasetGraph)dsg, (Lang)Lang.TRIG, (String)this.baseIRI);
            DatasetGraph dsg2 = DatasetLib.createDatasetGraphMem();
            RiotLoader.read((String)this.output, (DatasetGraph)dsg2, (Lang)Lang.NQUADS, null);
            boolean b = DatasetLib.isomorphic((DatasetGraph)dsg, (DatasetGraph)dsg2);
            if (!b) {
                System.out.println("---- Parsed");
                DatasetLib.dump((DatasetGraph)dsg);
                System.out.println("---- Expected");
                DatasetLib.dump((DatasetGraph)dsg2);
                System.out.println("--------");
            }
            UnitTestTrig.assertTrue((String)"Datasets are not isomorphic", (boolean)b);
        }
        catch (RiotParseException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            ex.printStackTrace(System.err);
            throw ex;
        }
    }
}

