/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.lang;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.StrUtils;
import org.openjena.riot.ErrorHandlerTestLib;
import org.openjena.riot.RiotException;
import org.openjena.riot.tokens.Tokenizer;
import org.openjena.riot.tokens.TokenizerFactory;

public abstract class TestLangNTuples
extends BaseTest {
    @Test
    public void tuple_0() {
        long count = this.parseCount("");
        TestLangNTuples.assertEquals((long)0L, (long)count);
    }

    @Test
    public void tuple_1() {
        long count = this.parseCount("<x> <y> <z>.");
        TestLangNTuples.assertEquals((long)1L, (long)count);
    }

    @Test
    public void tuple_2() {
        long count = this.parseCount("<x> <y> \"z\".");
        TestLangNTuples.assertEquals((long)1L, (long)count);
    }

    @Test
    public void tuple_3() {
        long count = this.parseCount("<x> <y> <z>. <x> <y> <z>.");
        TestLangNTuples.assertEquals((long)2L, (long)count);
    }

    @Test
    public void tuple_4() {
        long count = this.parseCount("<x> <y> \"123\"^^<int>.");
        TestLangNTuples.assertEquals((long)1L, (long)count);
    }

    @Test
    public void tuple_5() {
        long count = this.parseCount("<x> <y> \"123\"@lang.");
        TestLangNTuples.assertEquals((long)1L, (long)count);
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void tuple_bad_01() {
        this.parseCount("<x> <y> <z>");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void tuple_bad_02() {
        this.parseCount("<x> _:a <z> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void tuple_bad_03() {
        this.parseCount("<x> \"p\" <z> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void tuple_bad_4() {
        this.parseCount("\"x\" <p> <z> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void tuple_bad_5() {
        this.parseCount("<x> <p> ?var .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void tuple_bad_6() {
        this.parseCount("<x> <p> 123 .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void tuple_bad_7() {
        this.parseCount("<x> <p> x:y .");
    }

    @Test
    public void tuple_bad_10() {
        this.parseCount("<x> <p> <bad uri> .");
    }

    @Test
    public void tuple_bad_11() {
        this.parseCount("<x> <p> \"9000\"^^<http://www.w3.org/2001/XMLSchema#byte> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExError.class)
    public void tuple_bad_21() {
        this.parseCheck("<x> <p> <z> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void tuple_bad_22() {
        this.parseCheck("<http://example/x> <http://example/p> <http://example/bad uri> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void tuple_bad_23() {
        this.parseCheck("<http://example/x> <http://example/p> \"9000\"^^<http://www.w3.org/2001/XMLSchema#byte> .");
    }

    @Test
    public void tuple_charset_1() {
        this.parseCheck("<http://example/x\\u00E9> <http://example/p> <http://example/s> .");
    }

    @Test(expected=RiotException.class)
    public void tuple_charset_2() {
        this.parseCheck("<http://example/\u00e9> <http://example/p> \"\u00e9\" .");
    }

    protected static Tokenizer tokenizer(String string) {
        byte[] b = StrUtils.asUTF8bytes((String)string);
        ByteArrayInputStream in = new ByteArrayInputStream(b);
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerASCII((InputStream)in);
        return tokenizer;
    }

    protected abstract long parseCount(String ... var1);

    protected abstract void parseCheck(String ... var1);
}

