/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.lang;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.lib.DatasetLib;
import org.junit.Test;
import org.openjena.atlas.lib.Sink;
import org.openjena.atlas.lib.SinkCounting;
import org.openjena.atlas.lib.SinkNull;
import org.openjena.atlas.lib.StrUtils;
import org.openjena.riot.ErrorHandler;
import org.openjena.riot.ErrorHandlerTestLib;
import org.openjena.riot.RiotLoader;
import org.openjena.riot.RiotReader;
import org.openjena.riot.lang.LangNQuads;
import org.openjena.riot.lang.TestLangNTuples;
import org.openjena.riot.system.RiotLib;
import org.openjena.riot.tokens.Tokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestLangNQuads
extends TestLangNTuples {
    @Test
    public void quad_1() {
        this.parseCount("<x> <p> <s> <g> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void quad_2() {
        this.parseCount("<x> <p> <s> <g>");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void nq_only_1() {
        this.parseCount("<x> <p> <s> <g> <c> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void nq_only_2() {
        this.parseCount("@base <http://example/> . <x> <p> <s> .");
    }

    @Test
    public void dataset_1() {
        DatasetGraph dsg = TestLangNQuads.parseToDataset("<x> <p> <s> <g> .");
        TestLangNQuads.assertEquals((long)1L, (long)dsg.size());
        TestLangNQuads.assertEquals((long)1L, (long)dsg.getGraph(Node.createURI((String)"g")).size());
        TestLangNQuads.assertEquals((long)0L, (long)dsg.getDefaultGraph().size());
    }

    @Override
    protected long parseCount(String ... strings) {
        SinkCounting sink = new SinkCounting();
        TestLangNQuads.parse((Sink<Quad>)sink, strings);
        return sink.getCount();
    }

    private static DatasetGraph parseToDataset(String string) {
        DatasetGraph dsg = DatasetLib.createDatasetGraphMem();
        Sink sink = RiotLoader.datasetSink((DatasetGraph)dsg);
        TestLangNQuads.parse((Sink<Quad>)sink, string);
        return dsg;
    }

    private static void parse(Sink<Quad> sink, String ... strings) {
        String string = StrUtils.strjoin((String)"\n", (String[])strings);
        Tokenizer tokenizer = TestLangNQuads.tokenizer(string);
        LangNQuads parser = RiotReader.createParserNQuads((Tokenizer)tokenizer, sink);
        parser.getProfile().setHandler((ErrorHandler)new ErrorHandlerTestLib.ErrorHandlerEx());
        parser.parse();
        sink.flush();
    }

    @Override
    protected void parseCheck(String ... strings) {
        String string = StrUtils.strjoin((String)"\n", (String[])strings);
        Tokenizer tokenizer = TestLangNQuads.tokenizer(string);
        SinkNull sink = new SinkNull();
        LangNQuads parser = RiotReader.createParserNQuads((Tokenizer)tokenizer, (Sink)sink);
        parser.setProfile(RiotLib.profile(null, (boolean)false, (boolean)true, (ErrorHandler)new ErrorHandlerTestLib.ErrorHandlerEx()));
        parser.parse();
    }
}

