/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.lang;

import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.vocabulary.VocabTestQuery;
import com.hp.hpl.jena.util.junit.TestFactoryManifest;
import com.hp.hpl.jena.util.junit.TestUtils;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.openjena.riot.TestVocabRIOT;
import org.openjena.riot.lang.UnitTestSupressed;
import org.openjena.riot.lang.UnitTestTrig;
import org.openjena.riot.lang.UnitTestTrigBadSyntax;
import org.openjena.riot.lang.UnitTestTrigSyntax;

public class FactoryTestRiotTriG
extends TestFactoryManifest {
    private Resource dftTestType;
    private String labelPrefix;

    public static TestSuite make(String manifest, Resource dftTestType, String labelPrefix) {
        return new FactoryTestRiotTriG(dftTestType, labelPrefix).process(manifest);
    }

    public FactoryTestRiotTriG(Resource dftTestType, String labelPrefix) {
        this.dftTestType = dftTestType;
        this.labelPrefix = labelPrefix;
    }

    public Test makeTest(Resource manifest, Resource item, String testName, Resource action, Resource result) {
        try {
            Resource r = TestUtils.getResource((Resource)item, (Property)RDF.type);
            if (r == null) {
                r = this.dftTestType;
            }
            if (this.labelPrefix != null) {
                testName = this.labelPrefix + testName;
            }
            Resource input = TestUtils.getResource((Resource)action, (Property)VocabTestQuery.data);
            Resource output = result;
            String baseIRI = TestVocabRIOT.assumedBaseURI;
            String x = input.getLocalName();
            baseIRI = baseIRI + x;
            if (r.equals(TestVocabRIOT.TestInOut)) {
                return new UnitTestTrig(testName, input.getURI(), output.getURI(), baseIRI);
            }
            if (r.equals(TestVocabRIOT.TestSyntax)) {
                return new UnitTestTrigSyntax(testName, input.getURI());
            }
            if (r.equals(TestVocabRIOT.TestBadSyntax)) {
                return new UnitTestTrigBadSyntax(testName, input.getURI());
            }
            if (r.equals(TestVocabRIOT.TestSurpressed)) {
                return new UnitTestSupressed(testName, null);
            }
            System.err.println("Unrecognized test : " + testName);
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.err.println("Failed to grok test : " + testName);
            return null;
        }
    }
}

