/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot;

import com.hp.hpl.jena.iri.IRIFactory;
import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.riot.system.PrefixMap;

public class TestPrefixMap
extends BaseTest {
    static IRIFactory factory = IRIFactory.iriImplementation();

    @Test
    public void prefixMap1() {
        PrefixMap pmap = new PrefixMap();
        TestPrefixMap.add(pmap, "", "http://example/");
        String x = pmap.expand("", "x");
        TestPrefixMap.assertEquals((Object)"http://example/x", (Object)x);
    }

    @Test
    public void prefixMap2() {
        PrefixMap pmap = new PrefixMap();
        TestPrefixMap.add(pmap, "ex", "http://example/");
        String x = pmap.expand("", "x");
        TestPrefixMap.assertNull((Object)x);
    }

    @Test
    public void prefixMap3() {
        PrefixMap pmap = new PrefixMap();
        TestPrefixMap.add(pmap, "ex", "http://example/");
        TestPrefixMap.add(pmap, "ex", "http://elsewhere/ns#");
        String x = pmap.expand("ex", "x");
        TestPrefixMap.assertEquals((Object)"http://elsewhere/ns#x", (Object)x);
    }

    static void add(PrefixMap pmap, String prefix, String uri) {
        pmap.add(prefix, factory.create(uri));
    }
}

