/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.openjena.riot.LangTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class TestLangTag {
    private String input;
    private String[] parts;
    private String output;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"en", "en", new String[]{"en", null, null, null, null}}, {"en-uk", "en-UK", new String[]{"en", null, "UK", null, null}}, {"es-419", "es-419", new String[]{"es", null, "419", null, null}}, {"zh-Hant", "zh-Hant", new String[]{"zh", "Hant", null, null, null}}, {"sr-Latn-CS", "sr-Latn-CS", new String[]{"sr", "Latn", "CS", null, null}}, {"sl-nedis", "sl-nedis", new String[]{"sl", null, null, "nedis", null}}, {"sl-IT-nedis", "sl-IT-nedis", new String[]{"sl", null, "IT", "nedis", null}}, {"sl-Latn-IT-nedis", "sl-Latn-IT-nedis", new String[]{"sl", "Latn", "IT", "nedis", null}}, {"de-CH-x-Phonebk", "de-CH-x-Phonebk", new String[]{"de", null, "CH", null, "x-Phonebk"}}, {"zh-cn-a-myExt-x-private", "zh-CN-a-myExt-x-private", new String[]{"zh", null, "CN", null, "a-myExt-x-private"}}, {"12345", "12345", null});
    }

    public TestLangTag(String input, String output, String[] parts) {
        this.input = input;
        this.output = output;
        this.parts = parts;
    }

    @Test
    public void verify() {
        Object[] parts = LangTag.parse((String)this.input);
        String output = LangTag.canonical((String)this.input);
        Assert.assertArrayEquals((Object[])this.parts, (Object[])parts);
        Assert.assertEquals((Object)this.output, (Object)output);
    }
}

