/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.lib;

import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.NumberUtils;

public class TestNumberUtils
extends BaseTest {
    @Test
    public void int_format_01() {
        TestNumberUtils.testInt(1, 1, "1");
    }

    @Test
    public void int_format_02() {
        TestNumberUtils.testInt(1, 2, "01");
    }

    @Test
    public void int_format_03() {
        TestNumberUtils.testInt(0, 1, "0");
    }

    @Test
    public void int_format_04() {
        TestNumberUtils.testInt(0, 2, "00");
    }

    @Test
    public void int_format_05() {
        TestNumberUtils.testInt(-1, 2, "-1");
    }

    @Test
    public void int_format_06() {
        TestNumberUtils.testInt(-1, 3, "-01");
    }

    @Test
    public void int_format_11() {
        TestNumberUtils.testSigned(1, 2, "+1");
    }

    @Test
    public void int_format_12() {
        TestNumberUtils.testSigned(1, 3, "+01");
    }

    @Test
    public void int_format_13() {
        TestNumberUtils.testSigned(0, 2, "+0");
    }

    @Test
    public void int_format_14() {
        TestNumberUtils.testSigned(0, 3, "+00");
    }

    @Test
    public void int_format_15() {
        TestNumberUtils.testSigned(-1, 2, "-1");
    }

    @Test
    public void int_format_16() {
        TestNumberUtils.testSigned(-1, 3, "-01");
    }

    @Test
    public void int_format_21() {
        TestNumberUtils.testInt(1, "1");
    }

    @Test
    public void int_format_22() {
        TestNumberUtils.testInt(0, "0");
    }

    @Test
    public void int_format_23() {
        TestNumberUtils.testInt(-1, "-1");
    }

    @Test
    public void int_format_24() {
        TestNumberUtils.testInt(10, "10");
    }

    @Test
    public void int_format_25() {
        TestNumberUtils.testInt(100, "100");
    }

    @Test
    public void int_format_26() {
        TestNumberUtils.testInt(-10, "-10");
    }

    @Test
    public void int_format_27() {
        TestNumberUtils.testInt(-100, "-100");
    }

    private static void testInt(int value, String expected) {
        StringBuilder sb = new StringBuilder();
        NumberUtils.formatInt((StringBuilder)sb, (int)value);
        String result = sb.toString();
        TestNumberUtils.assertEquals((Object)expected, (Object)result);
    }

    private static void testInt(int value, int width, String expected) {
        StringBuilder sb = new StringBuilder();
        NumberUtils.formatInt((StringBuilder)sb, (int)value, (int)width);
        String result = sb.toString();
        TestNumberUtils.assertEquals((Object)expected, (Object)result);
    }

    private static void testSigned(int value, int width, String expected) {
        StringBuilder sb = new StringBuilder();
        NumberUtils.formatSignedInt((StringBuilder)sb, (int)value, (int)width);
        String result = sb.toString();
        TestNumberUtils.assertEquals((Object)expected, (Object)result);
    }
}

