/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.lib;

import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.FileOps;
import org.openjena.atlas.lib.Tuple;

public class TestFileOps
extends BaseTest {
    static void test(String fn, String path, String basename, String ext) {
        Tuple t = FileOps.splitDirBaseExt((String)fn);
        TestFileOps.assertEquals((Object)path, (Object)t.get(0));
        TestFileOps.assertEquals((Object)basename, (Object)t.get(1));
        TestFileOps.assertEquals((Object)ext, (Object)t.get(2));
    }

    @Test
    public void split01() {
        TestFileOps.test("/aa/bb/cc.ext", "/aa/bb", "cc", "ext");
    }

    @Test
    public void split02() {
        TestFileOps.test("/a/b/c", "/a/b", "c", null);
    }

    @Test
    public void split03() {
        TestFileOps.test("cc.ext", null, "cc", "ext");
    }

    @Test
    public void split04() {
        TestFileOps.test("/cc.ext", "", "cc", "ext");
    }

    @Test
    public void split05() {
        TestFileOps.test("/", "", "", null);
    }

    @Test
    public void split06() {
        TestFileOps.test("", null, "", null);
    }

    @Test
    public void split07() {
        TestFileOps.test("xyz", null, "xyz", null);
    }

    @Test
    public void split08() {
        TestFileOps.test("/xyz", "", "xyz", null);
    }

    @Test
    public void split09() {
        TestFileOps.test("xyz/", "xyz", "", null);
    }
}

