/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.lib;

import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.ColumnMap;
import org.openjena.atlas.lib.Tuple;

public class TestColumnMap
extends BaseTest {
    @Test
    public void remap1() {
        ColumnMap x = new ColumnMap("SPO->POS", new int[]{2, 0, 1});
        Object[] array = new Integer[]{0, 1, 2};
        TestColumnMap.assertEquals((Object)2, (Object)x.mapSlot(0, array));
        TestColumnMap.assertEquals((Object)0, (Object)x.mapSlot(1, array));
        TestColumnMap.assertEquals((Object)1, (Object)x.mapSlot(2, array));
    }

    @Test
    public void remap2() {
        ColumnMap x = new ColumnMap("SPO->POS", new int[]{2, 0, 1});
        Object[] array = new Integer[]{0, 1, 2};
        TestColumnMap.assertEquals((Object)1, (Object)x.fetchSlot(0, array));
        TestColumnMap.assertEquals((Object)2, (Object)x.fetchSlot(1, array));
        TestColumnMap.assertEquals((Object)0, (Object)x.fetchSlot(2, array));
    }

    @Test
    public void remap3() {
        ColumnMap x = new ColumnMap("POS", new int[]{2, 0, 1});
        Tuple tuple = Tuple.create((Object[])new String[]{"S", "P", "O"});
        Tuple mapped = x.map(tuple);
        Tuple expected = Tuple.create((Object[])new String[]{"P", "O", "S"});
        TestColumnMap.assertEquals((Object)expected, (Object)mapped);
    }

    @Test
    public void remap4() {
        ColumnMap x = new ColumnMap("POS", new int[]{2, 0, 1});
        Tuple tuple = Tuple.create((Object[])new String[]{"S", "P", "O"});
        Tuple tuple2 = x.map(tuple);
        tuple2 = x.unmap(tuple2);
        TestColumnMap.assertEquals((Object)tuple, (Object)tuple2);
    }

    @Test
    public void compile1() {
        int[] x = ColumnMap.compileMapping((String)"SPO", (String)"POS");
        int[] expected = new int[]{2, 0, 1};
        TestColumnMap.assertArrayEquals((int[])expected, (int[])x);
    }

    @Test
    public void compile2() {
        int[] x = ColumnMap.compileMapping((String)"SPOG", (String)"GOPS");
        int[] expected = new int[]{3, 2, 1, 0};
        TestColumnMap.assertArrayEquals((int[])expected, (int[])x);
    }

    @Test
    public void map1() {
        ColumnMap cmap = new ColumnMap("GSPO", "OSPG");
        Tuple tuple = Tuple.create((Object[])new String[]{"G", "S", "P", "O"});
        Tuple mapped = cmap.map(tuple);
        Tuple expected = Tuple.create((Object[])new String[]{"O", "S", "P", "G"});
        TestColumnMap.assertEquals((Object)expected, (Object)mapped);
        Tuple unmapped = cmap.unmap(mapped);
        TestColumnMap.assertEquals((Object)Tuple.create((Object[])new String[]{"G", "S", "P", "O"}), (Object)unmapped);
    }

    @Test
    public void map2() {
        Object[] x = new String[]{"G", "S", "P", "O"};
        Object[] y = new String[]{"O", "S", "P", "G"};
        ColumnMap cmap = new ColumnMap("Test", x, y);
        Tuple tuple = Tuple.create((Object[])x);
        Tuple mapped = cmap.map(tuple);
        Tuple expected = Tuple.create((Object[])y);
        TestColumnMap.assertEquals((Object)expected, (Object)mapped);
        Tuple unmapped = cmap.unmap(mapped);
        TestColumnMap.assertEquals((Object)Tuple.create((Object[])x), (Object)unmapped);
    }
}

