/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.iterator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.Test;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.iterator.PushbackIterator;
import org.openjena.atlas.junit.BaseTest;

public class TestIteratorPushback
extends BaseTest {
    static List<String> data = new ArrayList<String>();

    @Test(expected=IllegalArgumentException.class)
    public void pushback01() {
        new PushbackIterator(null);
    }

    @Test
    public void pushback02() {
        PushbackIterator iter = new PushbackIterator(data.iterator());
        TestIteratorPushback.assertEquals((Object)"a", (Object)iter.next());
        TestIteratorPushback.assertEquals((Object)"b", (Object)iter.next());
        TestIteratorPushback.assertEquals((Object)"c", (Object)iter.next());
        TestIteratorPushback.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void pushback03() {
        PushbackIterator iter = new PushbackIterator(data.iterator());
        iter.pushback((Object)"x");
        TestIteratorPushback.assertEquals((Object)"x", (Object)iter.next());
        TestIteratorPushback.assertEquals((Object)"a", (Object)iter.next());
        TestIteratorPushback.assertEquals((long)2L, (long)Iter.count((Iterator)iter));
    }

    @Test
    public void pushback04() {
        PushbackIterator iter = new PushbackIterator(data.iterator());
        TestIteratorPushback.assertEquals((Object)"a", (Object)iter.next());
        iter.pushback((Object)"x");
        TestIteratorPushback.assertEquals((Object)"x", (Object)iter.next());
        TestIteratorPushback.assertEquals((Object)"b", (Object)iter.next());
        TestIteratorPushback.assertEquals((long)1L, (long)Iter.count((Iterator)iter));
    }

    @Test
    public void pushback05() {
        PushbackIterator iter = new PushbackIterator(data.iterator());
        TestIteratorPushback.assertEquals((Object)"a", (Object)iter.next());
        iter.pushback((Object)"x");
        iter.pushback((Object)"y");
        TestIteratorPushback.assertEquals((Object)"y", (Object)iter.next());
        TestIteratorPushback.assertEquals((Object)"x", (Object)iter.next());
        TestIteratorPushback.assertEquals((Object)"b", (Object)iter.next());
        TestIteratorPushback.assertEquals((long)1L, (long)Iter.count((Iterator)iter));
    }

    @Test
    public void pushback06() {
        PushbackIterator iter = new PushbackIterator(data.iterator());
        TestIteratorPushback.assertEquals((long)3L, (long)Iter.count((Iterator)iter));
        iter.pushback((Object)"x");
        iter.pushback((Object)"y");
        TestIteratorPushback.assertEquals((Object)"y", (Object)iter.next());
        TestIteratorPushback.assertEquals((Object)"x", (Object)iter.next());
        TestIteratorPushback.assertFalse((boolean)iter.hasNext());
    }

    static {
        data.add("a");
        data.add("b");
        data.add("c");
    }
}

