/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.iterator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openjena.atlas.iterator.Iter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestIter {
    List<String> data0 = new ArrayList<String>();
    List<String> data1 = new ArrayList<String>();
    List<String> data2;
    static Iter.Folder<String, String> f1 = new Iter.Folder<String, String>(){

        public String eval(String acc, String arg) {
            return acc + arg;
        }
    };

    public TestIter() {
        this.data1.add("a");
        this.data2 = new ArrayList<String>();
        this.data2.add("x");
        this.data2.add("y");
        this.data2.add("z");
    }

    @Test
    public void append_1() {
        Iterator iter = Iter.append(this.data1, this.data0);
        this.test(iter, "a");
    }

    @Test
    public void append_2() {
        Iterator iter = Iter.append(this.data0, this.data1);
        this.test(iter, "a");
    }

    @Test
    public void append_3() {
        Iterator iter = Iter.append(this.data1, this.data2);
        this.test(iter, "a", "x", "y", "z");
    }

    @Test
    public void asString_1() {
        String x = Iter.asString(this.data0, (String)"");
        Assert.assertEquals((Object)"", (Object)x);
    }

    @Test
    public void asString_2() {
        String x = Iter.asString(this.data1, (String)"");
        Assert.assertEquals((Object)"a", (Object)x);
    }

    @Test
    public void asString_3() {
        String x = Iter.asString(this.data1, (String)"/");
        Assert.assertEquals((Object)"a", (Object)x);
    }

    @Test
    public void asString_4() {
        String x = Iter.asString(this.data2, (String)"/");
        Assert.assertEquals((Object)"x/y/z", (Object)x);
    }

    private void test(Iterator<?> iter, Object ... items) {
        for (Object x : items) {
            Assert.assertTrue((boolean)iter.hasNext());
            Assert.assertEquals((Object)x, iter.next());
        }
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void fold_01() {
        String[] x = new String[]{"a", "b", "c"};
        String z = (String)Iter.foldLeft(Arrays.asList(x), f1, (Object)"X");
        Assert.assertEquals((Object)"Xabc", (Object)z);
    }

    @Test
    public void fold_02() {
        String[] x = new String[]{"a", "b", "c"};
        String z = (String)Iter.foldRight(Arrays.asList(x), f1, (Object)"X");
        Assert.assertEquals((Object)"Xcba", (Object)z);
    }

    @Test
    public void fold_03() {
        String[] x = new String[]{};
        String z = (String)Iter.foldLeft(Arrays.asList(x), f1, (Object)"X");
        Assert.assertEquals((Object)"X", (Object)z);
    }

    @Test
    public void fold_04() {
        String[] x = new String[]{};
        String z = (String)Iter.foldRight(Arrays.asList(x), f1, (Object)"X");
        Assert.assertEquals((Object)"X", (Object)z);
    }
}

