/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.junit.Test;
import org.openjena.atlas.io.StreamUTF8;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.Chars;

public class TestStreamUTF8
extends BaseTest {
    static Charset utf8 = Chars.charsetUTF8;
    static CharsetDecoder dec = utf8.newDecoder();
    static CharsetEncoder enc = utf8.newEncoder();
    private static final String asciiBase = "abc";
    private static final String latinBase = "\u00c0\u00e9\u00ed\u00ff";
    private static final String latinExtraBase = "\u1ef9\ufb01\ufb02";
    private static final String greekBase = "\u03b1\u03b2\u03b3";
    private static final String hewbrewBase = "\u05d0\u05d1\u05d2";
    private static final String arabicBase = "\u0621\u0622\u0623";
    private static final String symbolsBase = "\u263a\u263b\u266a\u266b";
    private static final String chineseBase = "\u5b6b\u5b50\u5175\u6cd5";
    private static final String japaneseBase = "\u65e5\u672c";

    @Test
    public void test_01() {
        TestStreamUTF8.test(asciiBase);
    }

    @Test
    public void test_02() {
        TestStreamUTF8.test(latinBase);
    }

    @Test
    public void test_03() {
        TestStreamUTF8.test(latinExtraBase);
    }

    @Test
    public void test_04() {
        TestStreamUTF8.test(greekBase);
    }

    @Test
    public void test_05() {
        TestStreamUTF8.test(hewbrewBase);
    }

    @Test
    public void test_06() {
        TestStreamUTF8.test(arabicBase);
    }

    @Test
    public void test_07() {
        TestStreamUTF8.test(symbolsBase);
    }

    @Test
    public void test_08() {
        TestStreamUTF8.test(chineseBase);
    }

    @Test
    public void test_09() {
        TestStreamUTF8.test(japaneseBase);
    }

    static void test(String x) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, utf8);
            out.write(x);
            ((Writer)out).close();
            byte[] bytes = bout.toByteArray();
            ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
            StreamUTF8 r = new StreamUTF8((InputStream)bin);
            char[] cbuff = new char[x.length() * 10];
            int len = r.read(cbuff);
            String str = new String(cbuff, 0, len);
            TestStreamUTF8.assertEquals((Object)x, (Object)str);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

