/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Test;
import org.openjena.atlas.io.InputStreamBuffered;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.Bytes;

public class TestInputStreamBuffered
extends BaseTest {
    @Test
    public void test_01() throws IOException {
        InputStream in = TestInputStreamBuffered.stream("");
        InputStreamBuffered in2 = new InputStreamBuffered(in);
        int x = TestInputStreamBuffered.count((InputStream)in2);
        TestInputStreamBuffered.assertEquals((long)0L, (long)x);
    }

    @Test
    public void test_02() throws IOException {
        InputStream in = TestInputStreamBuffered.stream(1, 2, 3, 4);
        InputStreamBuffered in2 = new InputStreamBuffered(in);
        TestInputStreamBuffered.check((InputStream)in2, 1, 2, 3, 4);
    }

    @Test
    public void test_03() throws IOException {
        InputStream in = TestInputStreamBuffered.stream(1, 2, 3, 4);
        InputStreamBuffered in2 = new InputStreamBuffered(in, 2);
        TestInputStreamBuffered.check((InputStream)in2, 1, 2, 3, 4);
    }

    @Test
    public void test_04() throws IOException {
        InputStream in = TestInputStreamBuffered.stream(1, 2, 3, 4);
        InputStreamBuffered in2 = new InputStreamBuffered(in, 1);
        TestInputStreamBuffered.check((InputStream)in2, 1, 2, 3, 4);
        TestInputStreamBuffered.assertEquals((long)-1L, (long)in.read());
    }

    private static InputStream stream(String data) {
        byte[] b = Bytes.string2bytes((String)data);
        return new ByteArrayInputStream(b);
    }

    private static InputStream stream(byte ... bytes) {
        return new ByteArrayInputStream(bytes);
    }

    private static InputStream stream(int ... bytes) {
        return TestInputStreamBuffered.stream(TestInputStreamBuffered.ints2bytes(bytes));
    }

    private static byte[] ints2bytes(int ... values) {
        byte[] b = new byte[values.length];
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)values[i];
        }
        return b;
    }

    private static int count(InputStream in) throws IOException {
        int count = 0;
        while (in.read() != -1) {
            ++count;
        }
        return count;
    }

    private static void check(InputStream in, int ... bytes) throws IOException {
        TestInputStreamBuffered.check(in, TestInputStreamBuffered.ints2bytes(bytes));
    }

    private static void check(InputStream in, byte ... bytes) throws IOException {
        for (byte b : bytes) {
            TestInputStreamBuffered.assertEquals((long)b, (long)((byte)in.read()));
        }
    }
}

