/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.io;

import java.nio.ByteBuffer;
import org.junit.Test;
import org.openjena.atlas.io.BufferingWriter;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.Bytes;
import org.openjena.atlas.lib.Sink;

public class TestBufferingWriter
extends BaseTest {
    ByteBuffer bb = null;
    BufferingWriter w = null;

    public void create(int size, int blobSize) {
        this.bb = ByteBuffer.allocate(2048);
        BufferingWriter.SinkBuffer sink = new BufferingWriter.SinkBuffer(this.bb);
        this.w = new BufferingWriter((Sink)sink, size, blobSize);
    }

    public String string() {
        this.bb.flip();
        return Bytes.fromByteBuffer((ByteBuffer)this.bb);
    }

    @Test
    public void write_01() {
        this.create(10, 5);
        this.w.output((CharSequence)"x");
        this.w.flush();
        String x = this.string();
        TestBufferingWriter.assertEquals((Object)"x", (Object)x);
    }

    @Test
    public void write_02() {
        this.create(10, 5);
        this.w.output((CharSequence)"foofoo");
        this.w.flush();
        String x = this.string();
        TestBufferingWriter.assertEquals((Object)"foofoo", (Object)x);
    }

    @Test
    public void write_03() {
        this.create(10, 8);
        this.w.output((CharSequence)"a");
        this.w.output((CharSequence)"b");
        this.w.output((CharSequence)"c");
        this.w.flush();
        String x = this.string();
        TestBufferingWriter.assertEquals((Object)"abc", (Object)x);
    }

    @Test
    public void write_04() {
        this.create(10, 8);
        this.w.output((CharSequence)"abcdefghijklmnopqrstuvwxyz");
        this.w.output((CharSequence)"XYZ");
        this.w.flush();
        String x = this.string();
        TestBufferingWriter.assertEquals((Object)"abcdefghijklmnopqrstuvwxyzXYZ", (Object)x);
    }

    @Test
    public void write_05() {
        this.create(10, 8);
        this.w.output((CharSequence)"");
        this.w.flush();
        String x = this.string();
        TestBufferingWriter.assertEquals((Object)"", (Object)x);
    }
}

