/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.builders.BuilderResultSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.openjena.atlas.lib.StrUtils;

public class TestResultSetFormat {
    static String[] $rs1 = new String[]{"(resultset (?a ?b ?c)", "  (row (?a 1) (?b 2))", "  (row (?a 1) (?b 4) (?c 3))", ")"};
    static String[] $rs2 = new String[]{"(resultset (?a ?b ?c)", "  (row (?a 1) (?b 4) (?c 3))", "  (row (?a 1) (?b 2))", ")"};

    public static Test suite() {
        return new JUnit4TestAdapter(TestResultSetFormat.class);
    }

    static ResultSet make(String ... strings) {
        if (strings.length == 0) {
            throw new IllegalArgumentException();
        }
        String x = StrUtils.strjoinNL((String[])strings);
        Item item = SSE.parse((String)x);
        return BuilderResultSet.build((Item)item);
    }

    @org.junit.Test
    public void resultset_01() {
        ResultSet rs = TestResultSetFormat.make($rs1);
        ResultSetFormatter.asText((ResultSet)rs);
    }

    @org.junit.Test
    public void resultset_02() {
        ResultSet rs = TestResultSetFormat.make($rs1);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsXML((OutputStream)out, (ResultSet)rs);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ResultSet rs2 = ResultSetFactory.fromXML((InputStream)in);
    }

    @org.junit.Test
    public void resultset_03() {
        ResultSet rs = TestResultSetFormat.make($rs1);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsJSON((OutputStream)out, (ResultSet)rs);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ResultSet rs2 = ResultSetFactory.fromJSON((InputStream)in);
    }
}

