/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.modify.TestUpdateBase;
import com.hp.hpl.jena.sparql.modify.request.UpdateCreate;
import com.hp.hpl.jena.sparql.modify.request.UpdateDrop;
import com.hp.hpl.jena.sparql.util.graph.GraphFactory;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.Update;
import com.hp.hpl.jena.update.UpdateAction;
import com.hp.hpl.jena.update.UpdateException;
import org.junit.Test;

public abstract class TestUpdateGraphMgt
extends TestUpdateBase {
    static final Node graphIRI = Node.createURI((String)"http://example/graph");

    @Test
    public void testCreateDrop1() {
        GraphStore gStore = this.getEmptyGraphStore();
        UpdateCreate u = new UpdateCreate(graphIRI);
        UpdateAction.execute((Update)u, (GraphStore)gStore);
        TestUpdateGraphMgt.assertTrue((boolean)gStore.containsGraph(graphIRI));
        TestUpdateGraphMgt.assertTrue((boolean)TestUpdateGraphMgt.graphEmpty(gStore.getGraph(graphIRI)));
        boolean silentMode = true;
        if (!silentMode) {
            try {
                UpdateAction.execute((Update)u, (GraphStore)gStore);
                TestUpdateGraphMgt.fail();
            }
            catch (UpdateException ex) {
                // empty catch block
            }
        }
        u = new UpdateDrop(graphIRI);
        UpdateAction.execute((Update)u, (GraphStore)gStore);
        TestUpdateGraphMgt.assertFalse((boolean)gStore.containsGraph(graphIRI));
        if (!silentMode) {
            try {
                UpdateAction.execute((Update)u, (GraphStore)gStore);
                TestUpdateGraphMgt.fail();
            }
            catch (UpdateException ex) {
                // empty catch block
            }
        }
    }

    @Test
    public void testCreateDrop2() {
        GraphStore gStore = this.getEmptyGraphStore();
        UpdateCreate u = new UpdateCreate(graphIRI);
        UpdateAction.execute((Update)u, (GraphStore)gStore);
        u = new UpdateCreate(graphIRI, true);
        UpdateAction.execute((Update)u, (GraphStore)gStore);
        TestUpdateGraphMgt.assertTrue((boolean)gStore.containsGraph(graphIRI));
        TestUpdateGraphMgt.assertTrue((boolean)TestUpdateGraphMgt.graphEmpty(gStore.getGraph(graphIRI)));
        u = new UpdateDrop(graphIRI);
        UpdateAction.execute((Update)u, (GraphStore)gStore);
        TestUpdateGraphMgt.assertFalse((boolean)gStore.containsGraph(graphIRI));
        u = new UpdateDrop(graphIRI, true);
        UpdateAction.execute((Update)u, (GraphStore)gStore);
    }

    @Test
    public void testCreateDrop3() {
        GraphStore gStore = this.getEmptyGraphStore();
        TestUpdateGraphMgt.script(gStore, "create-1.ru");
        TestUpdateGraphMgt.assertTrue((boolean)gStore.containsGraph(graphIRI));
        TestUpdateGraphMgt.assertTrue((boolean)TestUpdateGraphMgt.graphEmpty(gStore.getGraph(graphIRI)));
    }

    @Test
    public void testCreateDrop4() {
        GraphStore gStore = this.getEmptyGraphStore();
        gStore.addGraph(graphIRI, GraphFactory.createDefaultGraph());
        TestUpdateGraphMgt.script(gStore, "drop-1.ru");
        TestUpdateGraphMgt.assertFalse((boolean)gStore.containsGraph(graphIRI));
    }
}

