/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.modify.TestUpdateBase;
import com.hp.hpl.jena.sparql.modify.submission.UpdateDelete;
import com.hp.hpl.jena.sparql.modify.submission.UpdateDeleteData;
import com.hp.hpl.jena.sparql.modify.submission.UpdateInsert;
import com.hp.hpl.jena.sparql.modify.submission.UpdateInsertData;
import com.hp.hpl.jena.sparql.modify.submission.UpdateModify;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.syntax.TemplateGroup;
import com.hp.hpl.jena.sparql.syntax.TemplateTriple;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import com.hp.hpl.jena.sparql.util.graph.GraphFactory;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.Update;
import com.hp.hpl.jena.update.UpdateAction;
import com.hp.hpl.jena.update.UpdateExecutionFactory;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateProcessor;
import com.hp.hpl.jena.update.UpdateRequest;
import org.junit.Test;

public abstract class TestUpdateGraph
extends TestUpdateBase {
    protected static Node s = NodeFactory.parseNode((String)"<http://example/r>");
    protected static Node p = NodeFactory.parseNode((String)"<http://example/p>");
    protected static Node q = NodeFactory.parseNode((String)"<http://example/q>");
    protected static Node v = NodeFactory.parseNode((String)"<http://example/v>");
    protected static Node o1 = NodeFactory.parseNode((String)"2007");
    protected static Triple triple1 = new Triple(s, p, o1);
    protected static Node o2 = NodeFactory.parseNode((String)"1066");
    protected static Triple triple2 = new Triple(s, p, o2);
    protected static Graph graph1 = TestUpdateGraph.data1();
    protected static Node graphIRI = NodeFactory.parseNode((String)"<http://example/graph>");

    @Test
    public void testInsertData1() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, graph1);
        UpdateInsertData insert = new UpdateInsertData();
        insert.setData(TestUpdateGraph.data2());
        UpdateProcessor uProc = UpdateExecutionFactory.create((Update)insert, (GraphStore)gStore);
        uProc.execute();
        TestUpdateGraph.assertFalse((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple1));
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple2));
    }

    @Test
    public void testDeleteData1() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, graph1);
        UpdateDeleteData delete = new UpdateDeleteData();
        delete.setData(TestUpdateGraph.data2());
        UpdateProcessor uProc = UpdateExecutionFactory.create((Update)delete, (GraphStore)gStore);
        uProc.execute();
        TestUpdateGraph.assertFalse((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple1));
        TestUpdateGraph.assertFalse((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple2));
    }

    @Test
    public void testDeleteData2() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, graph1);
        UpdateDeleteData delete = new UpdateDeleteData();
        delete.setData(TestUpdateGraph.data1());
        UpdateProcessor uProc = UpdateExecutionFactory.create((Update)delete, (GraphStore)gStore);
        uProc.execute();
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
        TestUpdateGraph.assertFalse((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple1));
    }

    @Test
    public void testInsert1() {
        GraphStore gStore = this.getEmptyGraphStore();
        UpdateInsert insert = new UpdateInsert();
        insert.setInsertTemplate((Template)new TemplateGroup());
        UpdateAction.execute((Update)insert, (GraphStore)gStore);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testInsert2() {
        GraphStore gStore = this.getEmptyGraphStore();
        UpdateInsert insert = new UpdateInsert();
        insert.setInsertTemplate((Template)new TemplateTriple(triple1));
        UpdateAction.execute((Update)insert, (GraphStore)gStore);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple1));
    }

    @Test
    public void testInsert3() {
        GraphStore gStore = this.getEmptyGraphStore();
        UpdateInsert insert = new UpdateInsert(graph1);
        UpdateAction.execute((Update)insert, (GraphStore)gStore);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple1));
    }

    @Test
    public void testInsert4() {
        GraphStore gStore = this.getEmptyGraphStore();
        gStore.addGraph(graphIRI, Factory.createDefaultGraph());
        UpdateInsert insert = new UpdateInsert(triple1);
        insert.addGraphName(graphIRI);
        UpdateAction.execute((Update)insert, (GraphStore)gStore);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getGraph(graphIRI), triple1));
    }

    @Test
    public void testInsert5() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, graph1);
        Element element = QueryFactory.createElement((String)"{ ?s <http://example/p> 2007 }");
        Template template = QueryFactory.createTemplate((String)"{ ?s <http://example/p> 1066 }");
        UpdateInsert insert = new UpdateInsert();
        insert.setPattern(element);
        insert.setInsertTemplate(template);
        UpdateAction.execute((Update)insert, (GraphStore)gStore);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple2));
    }

    @Test
    public void testDelete1() {
        GraphStore gStore = this.getEmptyGraphStore();
        UpdateDelete insert = new UpdateDelete();
        insert.setDeleteTemplate((Template)new TemplateGroup());
        UpdateAction.execute((Update)insert, (GraphStore)gStore);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testDelete2() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, graph1);
        UpdateDelete delete = new UpdateDelete();
        delete.setDeleteTemplate((Template)new TemplateGroup());
        UpdateAction.execute((Update)delete, (GraphStore)gStore);
        TestUpdateGraph.assertFalse((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testDelete3() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, graph1);
        UpdateDelete delete = new UpdateDelete(triple1);
        UpdateAction.execute((Update)delete, (GraphStore)gStore);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testDelete4() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.namedGraphData(gStore, graphIRI, TestUpdateGraph.data1());
        UpdateDelete delete = new UpdateDelete(triple1);
        delete.addGraphName(graphIRI);
        UpdateAction.execute((Update)delete, (GraphStore)gStore);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getGraph(graphIRI)));
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testDelete5() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, TestUpdateGraph.data2());
        this.namedGraphData(gStore, graphIRI, TestUpdateGraph.data1());
        UpdateDelete delete = new UpdateDelete();
        delete.setPattern("{ ?s <http://example/p> ?o } ");
        delete.setDeleteTemplate("{ ?s <http://example/p> 2007 }");
        delete.addGraphName(graphIRI);
        UpdateAction.execute((Update)delete, (GraphStore)gStore);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getGraph(graphIRI)));
        TestUpdateGraph.assertFalse((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testModify1() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, TestUpdateGraph.data2());
        this.namedGraphData(gStore, graphIRI, Factory.createDefaultGraph());
        UpdateModify modify = new UpdateModify();
        modify.addGraphName(graphIRI);
        modify.setPattern("{ ?s <http://example/p> ?o } ");
        modify.setDeleteTemplate("{ ?s <http://example/p> ?o}");
        modify.setInsertTemplate((Template)new TemplateTriple(triple1));
        UpdateAction.execute((Update)modify, (GraphStore)gStore);
        TestUpdateGraph.assertFalse((boolean)TestUpdateGraph.graphEmpty(gStore.getGraph(graphIRI)));
        TestUpdateGraph.assertFalse((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getGraph(graphIRI), triple1));
    }

    @Test
    public void testUpdateScript1() {
        GraphStore gStore = this.getEmptyGraphStore();
        TestUpdateGraph.script(gStore, "update-1.ru");
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), new Triple(s, p, NodeFactory.parseNode((String)"123"))));
    }

    @Test
    public void testUpdateScript2() {
        GraphStore gStore = this.getEmptyGraphStore();
        TestUpdateGraph.script(gStore, "update-2.ru");
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getGraph(Node.createURI((String)"http://example/g1")), new Triple(s, p, NodeFactory.parseNode((String)"123"))));
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testUpdateScript3() {
        GraphStore gStore = this.getEmptyGraphStore();
        TestUpdateGraph.script(gStore, "update-3.ru");
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getGraph(Node.createURI((String)"http://example/g1"))));
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testUpdateScript4() {
        GraphStore gStore = this.getEmptyGraphStore();
        TestUpdateGraph.script(gStore, "data-1.ru");
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), new Triple(s, p, NodeFactory.parseNode((String)"123"))));
    }

    @Test
    public void testUpdateScript5() {
        GraphStore gStore = this.getEmptyGraphStore();
        TestUpdateGraph.script(gStore, "data-2.ru");
        Graph g = GraphFactory.createPlainGraph();
        Node b = Node.createAnon();
        g.add(new Triple(s, p, b));
        g.add(new Triple(b, q, v));
        TestUpdateGraph.assertTrue((boolean)g.isIsomorphicWith(gStore.getDefaultGraph()));
    }

    @Test
    public void testUpdateScript6() {
        GraphStore gStore = this.getEmptyGraphStore();
        TestUpdateGraph.script(gStore, "data-3.ru");
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getGraph(graphIRI), new Triple(s, p, NodeFactory.parseNode((String)"123"))));
    }

    @Test
    public void testUpdateScript7() {
        GraphStore gStore = this.getEmptyGraphStore();
        TestUpdateGraph.script(gStore, "data-4.ru");
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), new Triple(s, p, NodeFactory.parseNode((String)"123"))));
        Graph g = gStore.getGraph(graphIRI);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getGraph(graphIRI), new Triple(s, p, o2)));
    }

    private Graph testUpdateInitialBindingWorker(Var v, Node n) {
        GraphStore gStore = this.getEmptyGraphStore();
        UpdateRequest req = UpdateFactory.create();
        UpdateInsert ins = new UpdateInsert();
        TemplateGroup template = new TemplateGroup();
        template.addTriple(triple1);
        template.addTriple(triple2);
        ins.setInsertTemplate((Template)template);
        req.add((Update)ins);
        UpdateDelete delete = new UpdateDelete();
        delete.setPattern("{ ?s <http://example/p> ?o } ");
        delete.setDeleteTemplate("{ ?s <http://example/p> ?o}");
        req.add((Update)delete);
        Binding b = BindingFactory.binding(null, (Var)v, (Node)n);
        UpdateAction.execute((UpdateRequest)req, (GraphStore)gStore, (Binding)b);
        return gStore.getDefaultGraph();
    }

    @Test
    public void testUpdateInitialBinding1() {
        Graph graph = this.testUpdateInitialBindingWorker(Var.alloc((String)"o"), o1);
        TestUpdateGraph.assertEquals((int)graph.size(), (int)1);
        TestUpdateGraph.assertFalse((boolean)TestUpdateGraph.graphContains(graph, triple1));
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(graph, triple2));
    }

    @Test
    public void testUpdateInitialBinding2() {
        Graph graph = this.testUpdateInitialBindingWorker(Var.alloc((String)"o"), o2);
        TestUpdateGraph.assertEquals((int)graph.size(), (int)1);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(graph, triple1));
        TestUpdateGraph.assertFalse((boolean)TestUpdateGraph.graphContains(graph, triple2));
    }

    @Test
    public void testUpdateInitialBinding3() {
        Graph graph = this.testUpdateInitialBindingWorker(Var.alloc((String)"FF"), o1);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(graph));
    }

    @Test
    public void testUpdateInitialBinding4() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, graph1);
        String update = "DELETE WHERE { ?x <http://example/p> 2007 } ; INSERT { ?x <http://example/p> 1999 } WHERE {}";
        UpdateRequest req = UpdateFactory.create((String)update);
        Binding b = BindingFactory.binding((Var)Var.alloc((String)"x"), (Node)s);
        UpdateAction.execute((UpdateRequest)req, (GraphStore)gStore, (Binding)b);
        TestUpdateGraph.assertEquals((int)1, (int)gStore.getDefaultGraph().size());
        TestUpdateGraph.assertTrue((boolean)gStore.getDefaultGraph().contains(s, p, NodeFactory.parseNode((String)"1999")));
    }

    private static Graph data1() {
        Graph graph = Factory.createDefaultGraph();
        graph.add(triple1);
        return graph;
    }

    private static Graph data2() {
        Graph graph = Factory.createDefaultGraph();
        graph.add(triple2);
        return graph;
    }
}

