/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.graph;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;
import org.junit.Test;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.junit.BaseTest;

public abstract class GraphsTests
extends BaseTest {
    protected static final String graph1 = "http://example/g1";
    protected static final String graph2 = "http://example/g2";
    protected static final String graph3 = "http://example/g3";
    static Dataset ds;
    static Model calcUnion;
    String queryString = "SELECT * {?s ?p ?o}";

    protected abstract Dataset createDataset();

    protected Dataset getDataset() {
        if (ds == null) {
            ds = this.createDataset();
            ds.getDefaultModel().getGraph().add(SSE.parseTriple((String)"(<x> <p> 'Default graph')"));
            Model m1 = ds.getNamedModel(graph1);
            m1.getGraph().add(SSE.parseTriple((String)"(<x> <p> 'Graph 1')"));
            m1.getGraph().add(SSE.parseTriple((String)"(<x> <p> 'ZZZ')"));
            Model m2 = ds.getNamedModel(graph2);
            m2.getGraph().add(SSE.parseTriple((String)"(<x> <p> 'Graph 2')"));
            m2.getGraph().add(SSE.parseTriple((String)"(<x> <p> 'ZZZ')"));
            calcUnion.add(m1);
            calcUnion.add(m2);
        }
        return ds;
    }

    @Test
    public void graph1() {
        int x = this.query(this.queryString, this.getDataset().getDefaultModel());
        GraphsTests.assertEquals((long)1L, (long)x);
    }

    @Test
    public void graph2() {
        int x = this.query(this.queryString, this.getDataset().getNamedModel(graph1));
        GraphsTests.assertEquals((long)2L, (long)x);
    }

    @Test
    public void graph3() {
        int x = this.query(this.queryString, this.getDataset().getNamedModel(graph3));
        GraphsTests.assertEquals((long)0L, (long)x);
    }

    @Test
    public void graph4() {
        int x = this.query(this.queryString, this.getDataset().getNamedModel(Quad.unionGraph.getURI()));
        GraphsTests.assertEquals((long)3L, (long)x);
        Model m = this.getDataset().getNamedModel(Quad.unionGraph.getURI());
        m.isIsomorphicWith(calcUnion);
    }

    @Test
    public void graph5() {
        int x = this.query(this.queryString, this.getDataset().getNamedModel(Quad.defaultGraphIRI.getURI()));
        GraphsTests.assertEquals((long)1L, (long)x);
    }

    @Test
    public void graph6() {
        int x = this.query(this.queryString, this.getDataset().getNamedModel(Quad.defaultGraphNodeGenerated.getURI()));
        GraphsTests.assertEquals((long)1L, (long)x);
    }

    @Test
    public void graph_api1() {
        int x = this.api(this.getDataset().getDefaultModel());
        GraphsTests.assertEquals((long)1L, (long)x);
    }

    @Test
    public void graph_api2() {
        int x = this.api(this.getDataset().getNamedModel(graph1));
        GraphsTests.assertEquals((long)2L, (long)x);
    }

    @Test
    public void graph_api3() {
        int x = this.api(this.getDataset().getNamedModel(graph3));
        GraphsTests.assertEquals((long)0L, (long)x);
    }

    @Test
    public void graph_api4() {
        int x = this.api(this.getDataset().getNamedModel(Quad.unionGraph.getURI()));
        GraphsTests.assertEquals((long)3L, (long)x);
        Model m = this.getDataset().getNamedModel(Quad.unionGraph.getURI());
        m.isIsomorphicWith(calcUnion);
    }

    @Test
    public void graph_api5() {
        int x = this.api(this.getDataset().getNamedModel(Quad.defaultGraphIRI.getURI()));
        GraphsTests.assertEquals((long)1L, (long)x);
    }

    @Test
    public void graph_api6() {
        int x = this.api(this.getDataset().getNamedModel(Quad.defaultGraphNodeGenerated.getURI()));
        GraphsTests.assertEquals((long)1L, (long)x);
    }

    private int query(String str, Model model) {
        Query q = QueryFactory.create((String)str, (Syntax)Syntax.syntaxARQ);
        QueryExecution qexec = QueryExecutionFactory.create((Query)q, (Model)model);
        ResultSet rs = qexec.execSelect();
        int x = ResultSetFormatter.consume((ResultSet)rs);
        qexec.close();
        return x;
    }

    private int api(Model model) {
        ExtendedIterator iter = model.getGraph().find(Node.ANY, Node.ANY, Node.ANY);
        int x = (int)Iter.count((Iterator)iter);
        return x;
    }

    static {
        calcUnion = ModelFactory.createDefaultModel();
    }
}

