/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprEvalTypeException;
import com.hp.hpl.jena.sparql.expr.ExprNotComparableException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueDecimal;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueDouble;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueFloat;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueInteger;
import com.hp.hpl.jena.sparql.expr.nodevalue.XSDFuncOp;
import com.hp.hpl.jena.sparql.util.Symbol;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import junit.framework.TestCase;
import org.junit.Assert;

public class TestXSDFuncOp
extends TestCase {
    private static final double accuracyExact_D = 0.0;
    private static final double accuracyExact_F = 0.0;
    private static final double accuracyClose_D = 1.0E-6;
    private static final double accuracyClose_F = (double)1.0E-6f;
    private static NodeValue nv_dt = NodeValue.makeNode((String)"2010-03-22T20:31:54.5", (XSDDatatype)XSDDatatype.XSDdateTime);
    private static NodeValue nv_d = NodeValue.makeNode((String)"2010-03-22", (XSDDatatype)XSDDatatype.XSDdate);
    private static NodeValue nv_gy = NodeValue.makeNode((String)"2010", (XSDDatatype)XSDDatatype.XSDgYear);
    private static NodeValue nv_gym = NodeValue.makeNode((String)"2010-03", (XSDDatatype)XSDDatatype.XSDgYearMonth);
    private static NodeValue nv_gmd = NodeValue.makeNode((String)"--03-22", (XSDDatatype)XSDDatatype.XSDgMonthDay);
    private static NodeValue nv_gm = NodeValue.makeNode((String)"--03", (XSDDatatype)XSDDatatype.XSDgMonth);
    private static NodeValue nv_gd = NodeValue.makeNode((String)"---22", (XSDDatatype)XSDDatatype.XSDgDay);
    private static NodeValue nv_t = NodeValue.makeNode((String)"20:31:54.5", (XSDDatatype)XSDDatatype.XSDtime);

    public static Test suite() {
        return new JUnit4TestAdapter(TestXSDFuncOp.class);
    }

    @org.junit.Test
    public void testAddIntegerInteger() {
        NodeValue nv1 = NodeValue.makeInteger((long)5L);
        NodeValue nv2 = NodeValue.makeInteger((long)7L);
        NodeValue r = XSDFuncOp.add((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertTrue((String)("Not an integer: " + r), (boolean)r.isInteger());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueInteger: " + r), (boolean)(r instanceof NodeValueInteger));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (long)12L, (long)r.getInteger().longValue());
    }

    @org.junit.Test
    public void testAddDecimalDecimal() {
        NodeValue nv1 = NodeValue.makeDecimal((double)4.3);
        NodeValue nv2 = NodeValue.makeDecimal((double)3.7);
        NodeValue r = XSDFuncOp.add((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (double)8.0, (double)r.getDecimal().doubleValue(), (double)0.0);
    }

    @org.junit.Test
    public void testAddFloatFloat() {
        NodeValue nv1 = NodeValue.makeFloat((float)7.5f);
        NodeValue nv2 = NodeValue.makeFloat((float)2.5f);
        NodeValue r = XSDFuncOp.add((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertTrue((String)("Not a float: " + r), (boolean)r.isDouble());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (double)10.0, (double)r.getFloat(), (double)0.0);
        TestXSDFuncOp.assertEquals((String)"Wrong result (as doubles)", (double)10.0, (double)r.getDouble(), (double)0.0);
    }

    @org.junit.Test
    public void testAddDoubleDouble() {
        NodeValue nv1 = NodeValue.makeDouble((double)7.5);
        NodeValue nv2 = NodeValue.makeDouble((double)2.5);
        NodeValue r = XSDFuncOp.add((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (double)10.0, (double)r.getDouble(), (double)0.0);
    }

    @org.junit.Test
    public void testAddIntegerDecimal() {
        NodeValue nv1 = NodeValue.makeInteger((long)5L);
        NodeValue nv2 = NodeValue.makeDecimal((long)7L);
        NodeValue r = XSDFuncOp.add((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (long)12L, (long)r.getDecimal().longValue());
    }

    @org.junit.Test
    public void testAddDecimalInteger() {
        NodeValue nv1 = NodeValue.makeDecimal((long)7L);
        NodeValue nv2 = NodeValue.makeInteger((long)5L);
        NodeValue r = XSDFuncOp.add((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (long)12L, (long)r.getDecimal().longValue());
    }

    @org.junit.Test
    public void testAddIntegerFloat() {
        NodeValue nv1 = NodeValue.makeInteger((long)5L);
        NodeValue nv2 = NodeValue.makeFloat((float)7.0f);
        NodeValue r = XSDFuncOp.add((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertTrue((String)("Not a float: " + r), (boolean)r.isFloat());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (double)12.0, (double)r.getDouble(), (double)0.0);
    }

    @org.junit.Test
    public void testAddFloatInteger() {
        NodeValue nv1 = NodeValue.makeFloat((float)7.0f);
        NodeValue nv2 = NodeValue.makeInteger((long)5L);
        NodeValue r = XSDFuncOp.add((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertTrue((String)("Not a float: " + r), (boolean)r.isFloat());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (double)12.0, (double)r.getDouble(), (double)0.0);
    }

    @org.junit.Test
    public void testAddIntegerDouble() {
        NodeValue nv1 = NodeValue.makeInteger((long)5L);
        NodeValue nv2 = NodeValue.makeDouble((double)7.0);
        NodeValue r = XSDFuncOp.add((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (double)12.0, (double)r.getDouble(), (double)0.0);
    }

    @org.junit.Test
    public void testAddDoubleInteger() {
        NodeValue nv1 = NodeValue.makeDouble((double)7.0);
        NodeValue nv2 = NodeValue.makeInteger((long)5L);
        NodeValue r = XSDFuncOp.add((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (double)12.0, (double)r.getDouble(), (double)0.0);
    }

    @org.junit.Test
    public void testAddDecimalFloat() {
        NodeValue nv1 = NodeValue.makeDecimal((double)3.5);
        NodeValue nv2 = NodeValue.makeFloat((float)4.5f);
        NodeValue r = XSDFuncOp.add((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertTrue((String)("Not a Float: " + r), (boolean)r.isFloat());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (double)8.0, (double)r.getFloat(), (double)0.0);
    }

    @org.junit.Test
    public void testAddFloatDecimal() {
        NodeValue nv1 = NodeValue.makeFloat((float)4.5f);
        NodeValue nv2 = NodeValue.makeDecimal((double)3.5);
        NodeValue r = XSDFuncOp.add((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertTrue((String)("Not a Float: " + r), (boolean)r.isFloat());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (double)8.0, (double)r.getFloat(), (double)0.0);
    }

    @org.junit.Test
    public void testAddDecimalDouble() {
        NodeValue nv1 = NodeValue.makeDecimal((double)3.5);
        NodeValue nv2 = NodeValue.makeDouble((double)4.5);
        NodeValue r = XSDFuncOp.add((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (double)8.0, (double)r.getDouble(), (double)0.0);
    }

    @org.junit.Test
    public void testAddDoubleDecimal() {
        NodeValue nv1 = NodeValue.makeDouble((double)4.5);
        NodeValue nv2 = NodeValue.makeDecimal((double)3.5);
        NodeValue r = XSDFuncOp.add((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (double)8.0, (double)r.getDouble(), (double)0.0);
    }

    @org.junit.Test
    public void testAddDoubleFloat() {
        NodeValue nv1 = NodeValue.makeDouble((double)4.5);
        NodeValue nv2 = NodeValue.makeFloat((float)3.5f);
        NodeValue r = XSDFuncOp.add((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (double)8.0, (double)r.getDouble(), (double)0.0);
    }

    @org.junit.Test
    public void testAddFloatDouble() {
        NodeValue nv1 = NodeValue.makeFloat((float)4.5f);
        NodeValue nv2 = NodeValue.makeDouble((double)3.5);
        NodeValue r = XSDFuncOp.add((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (double)8.0, (double)r.getDouble(), (double)0.0);
    }

    @org.junit.Test
    public void testDivideIntegerInteger() {
        NodeValue nv1 = NodeValue.makeInteger((long)25L);
        NodeValue nv2 = NodeValue.makeInteger((long)2L);
        NodeValue r = XSDFuncOp.divide((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (double)12.5, (double)r.getDecimal().doubleValue(), (double)0.0);
    }

    @org.junit.Test
    public void testDivideByZero1() {
        NodeValue nv1 = NodeValue.makeInteger((long)1L);
        NodeValue nv2 = NodeValue.makeInteger((long)0L);
        try {
            NodeValue r = XSDFuncOp.divide((NodeValue)nv1, (NodeValue)nv2);
            TestXSDFuncOp.fail((String)"No expection from .divide");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testDivideByZero2() {
        NodeValue nv1 = NodeValue.makeInteger((long)1L);
        NodeValue nv2 = NodeValue.makeDouble((double)0.0);
        NodeValue r = XSDFuncOp.divide((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestXSDFuncOp.assertTrue((String)("Not a +INF: " + r), (r.getDouble() == Double.POSITIVE_INFINITY ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testDivideByZero4() {
        NodeValue nv1 = NodeValue.makeInteger((long)-1L);
        NodeValue nv2 = NodeValue.makeDouble((double)0.0);
        NodeValue r = XSDFuncOp.divide((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestXSDFuncOp.assertTrue((String)("Not a -INF: " + r), (r.getDouble() == Double.NEGATIVE_INFINITY ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testSubtractDoubleDecimal() {
        NodeValue nv1 = NodeValue.makeDouble((double)4.5);
        NodeValue nv2 = NodeValue.makeDecimal((double)3.5);
        NodeValue r = XSDFuncOp.subtract((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (double)1.0, (double)r.getDouble(), (double)0.0);
    }

    @org.junit.Test
    public void testSubtractDecimalInteger() {
        NodeValue nv1 = NodeValue.makeDecimal((double)3.5);
        NodeValue nv2 = NodeValue.makeInteger((long)2L);
        NodeValue r = XSDFuncOp.subtract((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestXSDFuncOp.assertTrue((String)"Wrong result", (boolean)NodeValue.sameAs((NodeValue)NodeValue.makeDecimal((double)1.5), (NodeValue)r));
    }

    @org.junit.Test
    public void testMultiplyDoubleDecimal() {
        NodeValue nv1 = NodeValue.makeDouble((double)4.5);
        NodeValue nv2 = NodeValue.makeDecimal((double)3.5);
        NodeValue r = XSDFuncOp.multiply((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (double)15.75, (double)r.getDouble(), (double)0.0);
    }

    @org.junit.Test
    public void testMultiplyDecimalInteger() {
        NodeValue nv1 = NodeValue.makeDecimal((double)3.5);
        NodeValue nv2 = NodeValue.makeInteger((long)2L);
        NodeValue r = XSDFuncOp.multiply((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (long)7L, (long)r.getDecimal().longValue());
    }

    @org.junit.Test
    public void testCompare1() {
        NodeValue nv5 = NodeValue.makeInteger((long)5L);
        NodeValue nv7 = NodeValue.makeInteger((long)7L);
        TestXSDFuncOp.assertEquals((String)("Does not compare " + nv5 + " & " + nv7), (int)-1, (int)NodeValue.compare((NodeValue)nv5, (NodeValue)nv7));
        NodeValue nv5b = NodeValue.makeInteger((long)5L);
        TestXSDFuncOp.assertEquals((String)("Does not compare " + nv5 + " & " + nv5b), (int)0, (int)NodeValue.compare((NodeValue)nv5, (NodeValue)nv5b));
    }

    @org.junit.Test
    public void testCompare2() {
        NodeValue nv5 = NodeValue.makeInteger((long)5L);
        NodeValue nv7 = NodeValue.makeNodeInteger((long)7L);
        TestXSDFuncOp.assertEquals((String)("Does not compare " + nv5 + " & " + nv7), (int)-1, (int)NodeValue.compare((NodeValue)nv5, (NodeValue)nv7));
        NodeValue nv5b = NodeValue.makeNodeInteger((long)5L);
        TestXSDFuncOp.assertEquals((String)("Does not compare " + nv5 + " & " + nv5b), (int)0, (int)NodeValue.compare((NodeValue)nv5, (NodeValue)nv5b));
    }

    @org.junit.Test
    public void testCompare3() {
        NodeValue nv5 = NodeValue.makeInteger((long)5L);
        NodeValue nv7 = NodeValue.makeDouble((double)7.0);
        TestXSDFuncOp.assertEquals((String)("Does not compare " + nv5 + " & " + nv7), (int)-1, (int)NodeValue.compare((NodeValue)nv5, (NodeValue)nv7));
    }

    @org.junit.Test
    public void testCompare4() {
        NodeValue nv5 = NodeValue.makeInteger((long)5L);
        NodeValue nv7 = NodeValue.makeFloat((float)7.0f);
        TestXSDFuncOp.assertEquals((String)("Does not compare " + nv5 + " & " + nv7), (int)-1, (int)NodeValue.compare((NodeValue)nv5, (NodeValue)nv7));
    }

    @org.junit.Test
    public void testCompare5() {
        NodeValue nv5 = NodeValue.makeInteger((long)5L);
        NodeValue nv7 = NodeValue.makeDecimal((long)7L);
        TestXSDFuncOp.assertEquals((String)("Does not compare " + nv5 + " & " + nv7), (int)-1, (int)NodeValue.compare((NodeValue)nv5, (NodeValue)nv7));
    }

    @org.junit.Test
    public void testCompare10() {
        NodeValue nv1 = NodeValue.makeDateTime((String)"2005-10-14T13:09:43Z");
        NodeValue nv2 = NodeValue.makeNodeDateTime((String)"2005-10-14T14:09:43Z");
        TestXSDFuncOp.assertEquals((String)("Does not compare " + nv1 + " & " + nv2), (int)-1, (int)NodeValue.compare((NodeValue)nv1, (NodeValue)nv2));
    }

    @org.junit.Test
    public void testCompare11() {
        NodeValue nv1 = NodeValue.makeDateTime((String)"2005-10-14T13:09:43-08:00");
        NodeValue nv2 = NodeValue.makeNodeDateTime((String)"2005-10-14T13:09:43+01:00");
        TestXSDFuncOp.assertEquals((String)("Does not compare " + nv1 + " & " + nv2), (int)1, (int)NodeValue.compare((NodeValue)nv1, (NodeValue)nv2));
    }

    @org.junit.Test
    public void testCompare12() {
        if (!ARQ.isTrue((Symbol)ARQ.strictSPARQL)) {
            NodeValue nv1 = NodeValue.makeDate((String)"2006-07-21-08:00");
            NodeValue nv2 = NodeValue.makeNodeDate((String)"2006-07-21+01:00");
            TestXSDFuncOp.assertEquals((String)("Does not compare " + nv1 + " & " + nv2), (int)1, (int)NodeValue.compare((NodeValue)nv1, (NodeValue)nv2));
        }
    }

    @org.junit.Test
    public void testCompare15() {
        NodeValue nv1 = NodeValue.makeDate((String)"2005-10-14Z");
        NodeValue nv2 = NodeValue.makeNodeDateTime((String)"2005-10-14T14:09:43Z");
        try {
            NodeValue.compare((NodeValue)nv1, (NodeValue)nv2);
            TestXSDFuncOp.assertFalse((String)("Compared the uncomparable: " + nv1 + " & " + nv2), (boolean)true);
        }
        catch (ExprNotComparableException exprNotComparableException) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testCompare16() {
        NodeValue nv1 = NodeValue.makeDateTime((String)"2007-08-31T16:20:03");
        NodeValue nv2 = NodeValue.makeDateTime((String)"2007-08-31T16:20:03Z");
        try {
            NodeValue.compare((NodeValue)nv1, (NodeValue)nv2);
            TestXSDFuncOp.assertFalse((String)("Compared the uncomparable: " + nv1 + " & " + nv2), (boolean)true);
        }
        catch (ExprNotComparableException exprNotComparableException) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testCompare17() {
        NodeValue nv1 = NodeValue.makeDate((String)"2007-08-31");
        NodeValue nv2 = NodeValue.makeDate((String)"2007-08-31Z");
        try {
            NodeValue.compare((NodeValue)nv1, (NodeValue)nv2);
            TestXSDFuncOp.assertFalse((String)("Compared the uncomparable: " + nv1 + " & " + nv2), (boolean)true);
        }
        catch (ExprNotComparableException exprNotComparableException) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testCompare18() {
        NodeValue nv1 = NodeValue.makeDateTime((String)"2007-08-31T16:20:03");
        NodeValue nv2 = NodeValue.makeDateTime((String)"2007-08-31T01:20:03Z");
        TestXSDFuncOp.assertEquals((int)1, (int)NodeValue.compare((NodeValue)nv1, (NodeValue)nv2));
    }

    @org.junit.Test
    public void testCompare20() {
        NodeValue nv1 = NodeValue.makeString((String)"abcd");
        NodeValue nv2 = NodeValue.makeNodeString((String)"abc");
        TestXSDFuncOp.assertEquals((String)("Does not compare " + nv1 + " & " + nv2), (int)1, (int)NodeValue.compare((NodeValue)nv1, (NodeValue)nv2));
    }

    @org.junit.Test
    public void testCompare21() {
        NodeValue nv5 = NodeValue.makeInteger((long)5L);
        NodeValue nv7 = NodeValue.makeString((String)"5");
        try {
            NodeValue.compare((NodeValue)nv5, (NodeValue)nv7);
            TestXSDFuncOp.fail((String)("Should not compare (but did) " + nv5 + " & " + nv7));
        }
        catch (ExprEvalException ex) {
            // empty catch block
        }
        int x = NodeValue.compareAlways((NodeValue)nv5, (NodeValue)nv7);
        TestXSDFuncOp.assertEquals((String)("Does not compare " + nv5 + " & " + nv7), (int)1, (int)NodeValue.compareAlways((NodeValue)nv5, (NodeValue)nv7));
    }

    @org.junit.Test
    public void testCompare22() {
        NodeValue nv1 = NodeValue.makeNodeString((String)"aaa");
        NodeValue nv2 = NodeValue.makeString((String)"aaabbb");
        int x = NodeValue.compare((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertEquals((String)"Not CMP_LESS", (int)x, (int)-1);
        TestXSDFuncOp.assertTrue((String)"It's CMP_GREATER", (x != 1 ? 1 : 0) != 0);
        TestXSDFuncOp.assertTrue((String)"It's CMP_EQUAL", (x != 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testCompare23() {
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createAnon());
        NodeValue nv2 = NodeValue.makeString((String)"5");
        try {
            NodeValue.compare((NodeValue)nv1, (NodeValue)nv2);
            TestXSDFuncOp.fail((String)("Should not compare (but did) " + nv1 + " & " + nv2));
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testSameUnknown_1() {
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createURI((String)"test:abc"));
        NodeValue nv2 = NodeValue.makeNode((Node)Node.createURI((String)"test:abc"));
        TestXSDFuncOp.assertTrue((boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        TestXSDFuncOp.assertFalse((boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
        try {
            NodeValue.compare((NodeValue)nv1, (NodeValue)nv2);
            TestXSDFuncOp.fail((String)("Should not compare (but did) " + nv1 + " & " + nv2));
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testSameUnknown_2() {
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createAnon());
        NodeValue nv2 = NodeValue.makeNode((Node)Node.createURI((String)"test:abc"));
        TestXSDFuncOp.assertFalse((boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        TestXSDFuncOp.assertTrue((boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
        try {
            NodeValue.compare((NodeValue)nv1, (NodeValue)nv2);
            TestXSDFuncOp.fail((String)("Should not compare (but did) " + nv1 + " & " + nv2));
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testSameDateTime_1() {
        NodeValue nv1 = NodeValue.makeDateTime((String)"2007-09-04T09:22:03");
        NodeValue nv2 = NodeValue.makeDateTime((String)"2007-09-04T09:22:03");
        TestXSDFuncOp.assertTrue((boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        TestXSDFuncOp.assertFalse((boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
    }

    @org.junit.Test
    public void testSameDateTime_2() {
        NodeValue nv1 = NodeValue.makeDateTime((String)"2007-09-04T09:22:03");
        NodeValue nv2 = NodeValue.makeDateTime((String)"2007-09-04T19:00:00");
        TestXSDFuncOp.assertFalse((boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        TestXSDFuncOp.assertTrue((boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
    }

    @org.junit.Test
    public void testSameDateTime_3() {
        NodeValue nv1 = NodeValue.makeDateTime((String)"2007-09-04T10:22:03+01:00");
        NodeValue nv2 = NodeValue.makeDateTime((String)"2007-09-04T09:22:03Z");
        TestXSDFuncOp.assertTrue((boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        TestXSDFuncOp.assertFalse((boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
    }

    @org.junit.Test
    public void testSameDateTime_4() {
        NodeValue nv1 = NodeValue.makeDateTime((String)"2007-09-04T10:22:03+01:00");
        NodeValue nv2 = NodeValue.makeDateTime((String)"2007-09-04T10:22:03Z");
        TestXSDFuncOp.assertFalse((boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        TestXSDFuncOp.assertTrue((boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
    }

    @org.junit.Test
    public void testSameDateTime_5() {
        NodeValue nv1 = NodeValue.makeDateTime((String)"2007-09-04T10:22:03+01:00");
        NodeValue nv2 = NodeValue.makeDateTime((String)"2007-09-04T09:22:03");
        try {
            NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2);
            TestXSDFuncOp.fail((String)("Should not sameValueAs (but did) " + nv1 + " & " + nv2));
        }
        catch (ExprEvalException ex) {
            // empty catch block
        }
        try {
            NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2);
            TestXSDFuncOp.fail((String)("Should not notSameValueAs (but did) " + nv1 + " & " + nv2));
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testSameDate_1() {
        NodeValue nv1 = NodeValue.makeDate((String)"2007-09-04");
        NodeValue nv2 = NodeValue.makeDate((String)"2007-09-04");
        TestXSDFuncOp.assertTrue((boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        TestXSDFuncOp.assertFalse((boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
    }

    @org.junit.Test
    public void testSameDate_2() {
        NodeValue nv1 = NodeValue.makeDate((String)"2007-09-04Z");
        NodeValue nv2 = NodeValue.makeDate((String)"2007-09-04+00:00");
        TestXSDFuncOp.assertTrue((boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        TestXSDFuncOp.assertFalse((boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
    }

    @org.junit.Test
    public void testSameDate_3() {
        NodeValue nv1 = NodeValue.makeDate((String)"2007-09-04Z");
        NodeValue nv2 = NodeValue.makeDate((String)"2007-09-04");
        try {
            NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2);
            TestXSDFuncOp.fail((String)("Should not sameValueAs (but did) " + nv1 + " & " + nv2));
        }
        catch (ExprEvalException ex) {
            // empty catch block
        }
        try {
            NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2);
            TestXSDFuncOp.fail((String)("Should not notSameValueAs (but did) " + nv1 + " & " + nv2));
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testCompareGeneral1() {
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createAnon());
        NodeValue nv2 = NodeValue.makeString((String)"5");
        int x = NodeValue.compareAlways((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertEquals((String)("Does not compare " + nv1 + " & " + nv2), (int)-1, (int)NodeValue.compareAlways((NodeValue)nv1, (NodeValue)nv2));
    }

    @org.junit.Test
    public void testCompareGeneral2() {
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createAnon());
        NodeValue nv2 = NodeValue.makeNode((Node)Node.createURI((String)"test:abc"));
        int x = NodeValue.compareAlways((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertEquals((String)("Does not compare " + nv1 + " & " + nv2), (int)-1, (int)NodeValue.compareAlways((NodeValue)nv1, (NodeValue)nv2));
    }

    @org.junit.Test
    public void testCompareGeneral3() {
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createLiteral((String)"test:abc"));
        NodeValue nv2 = NodeValue.makeNode((Node)Node.createURI((String)"test:abc"));
        int x = NodeValue.compareAlways((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertEquals((String)("Does not compare " + nv1 + " & " + nv2), (int)1, (int)NodeValue.compareAlways((NodeValue)nv1, (NodeValue)nv2));
    }

    @org.junit.Test
    public void testCompareGeneral4() {
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createURI((String)"test:abc"));
        NodeValue nv2 = NodeValue.makeNode((Node)Node.createURI((String)"test:xyz"));
        int x = NodeValue.compareAlways((NodeValue)nv1, (NodeValue)nv2);
        TestXSDFuncOp.assertEquals((String)("Does not compare " + nv1 + " & " + nv2), (int)-1, (int)NodeValue.compareAlways((NodeValue)nv1, (NodeValue)nv2));
    }

    @org.junit.Test
    public void testAbs1() {
        NodeValue nv = NodeValue.makeInteger((long)2L);
        NodeValue r = XSDFuncOp.abs((NodeValue)nv);
        TestXSDFuncOp.assertTrue((String)("Not an integer: " + r), (boolean)r.isInteger());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueInteger: " + r), (boolean)(r instanceof NodeValueInteger));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (long)2L, (long)r.getInteger().longValue());
    }

    @org.junit.Test
    public void testAbs2() {
        NodeValue nv = NodeValue.makeInteger((long)-2L);
        NodeValue r = XSDFuncOp.abs((NodeValue)nv);
        TestXSDFuncOp.assertTrue((String)("Not an integer: " + r), (boolean)r.isInteger());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueInteger: " + r), (boolean)(r instanceof NodeValueInteger));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (long)2L, (long)r.getInteger().longValue());
    }

    @org.junit.Test
    public void testAbs3() {
        NodeValue nv = NodeValue.makeDecimal((long)2L);
        NodeValue r = XSDFuncOp.abs((NodeValue)nv);
        TestXSDFuncOp.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (double)2.0, (double)r.getDecimal().doubleValue(), (double)0.0);
    }

    @org.junit.Test
    public void testAbs4() {
        NodeValue nv = NodeValue.makeDecimal((long)-2L);
        NodeValue r = XSDFuncOp.abs((NodeValue)nv);
        TestXSDFuncOp.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (double)2.0, (double)r.getDecimal().doubleValue(), (double)0.0);
    }

    @org.junit.Test
    public void testAbs5() {
        NodeValue nv = NodeValue.makeFloat((float)2.0f);
        NodeValue r = XSDFuncOp.abs((NodeValue)nv);
        TestXSDFuncOp.assertTrue((String)("Not an float: " + r), (boolean)r.isFloat());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (double)2.0, (double)r.getFloat(), (double)0.0);
    }

    @org.junit.Test
    public void testAbs6() {
        NodeValue nv = NodeValue.makeFloat((float)-2.0f);
        NodeValue r = XSDFuncOp.abs((NodeValue)nv);
        TestXSDFuncOp.assertTrue((String)("Not an float: " + r), (boolean)r.isFloat());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (double)2.0, (double)r.getFloat(), (double)0.0);
    }

    @org.junit.Test
    public void testAbs7() {
        NodeValue nv = NodeValue.makeDouble((double)2.0);
        NodeValue r = XSDFuncOp.abs((NodeValue)nv);
        TestXSDFuncOp.assertTrue((String)("Not an double: " + r), (boolean)r.isDouble());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (double)2.0, (double)r.getDouble(), (double)0.0);
    }

    @org.junit.Test
    public void testAbs8() {
        NodeValue nv = NodeValue.makeDouble((double)-2.0);
        NodeValue r = XSDFuncOp.abs((NodeValue)nv);
        TestXSDFuncOp.assertTrue((String)("Not an double: " + r), (boolean)r.isDouble());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (double)2.0, (double)r.getDouble(), (double)0.0);
    }

    @org.junit.Test
    public void testCeiling1() {
        NodeValue nv = NodeValue.makeDecimal((double)2.6);
        NodeValue r = XSDFuncOp.ceiling((NodeValue)nv);
        TestXSDFuncOp.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (long)3L, (long)r.getDecimal().longValue());
    }

    @org.junit.Test
    public void testCeiling2() {
        NodeValue nv = NodeValue.makeDecimal((double)-3.6);
        NodeValue r = XSDFuncOp.ceiling((NodeValue)nv);
        TestXSDFuncOp.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (long)-3L, (long)r.getDecimal().longValue());
    }

    @org.junit.Test
    public void testCeiling3() {
        NodeValue nv = NodeValue.makeDouble((double)2.6);
        NodeValue r = XSDFuncOp.ceiling((NodeValue)nv);
        TestXSDFuncOp.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDouble());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (double)3.0, (double)r.getDouble(), (double)0.0);
    }

    @org.junit.Test
    public void testCeiling4() {
        NodeValue nv = NodeValue.makeDouble((double)-3.6);
        NodeValue r = XSDFuncOp.ceiling((NodeValue)nv);
        TestXSDFuncOp.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDouble());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (double)-3.0, (double)r.getDouble(), (double)0.0);
    }

    @org.junit.Test
    public void testCeiling5() {
        NodeValue nv = NodeValue.makeInteger((long)3L);
        NodeValue r = XSDFuncOp.ceiling((NodeValue)nv);
        TestXSDFuncOp.assertTrue((String)("Not an integer: " + r), (boolean)r.isInteger());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueInteger: " + r), (boolean)(r instanceof NodeValueInteger));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (long)3L, (long)r.getInteger().longValue());
    }

    @org.junit.Test
    public void testFloor1() {
        NodeValue nv = NodeValue.makeDecimal((double)2.6);
        NodeValue r = XSDFuncOp.floor((NodeValue)nv);
        TestXSDFuncOp.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (long)2L, (long)r.getDecimal().longValue());
    }

    @org.junit.Test
    public void testFloor2() {
        NodeValue nv = NodeValue.makeDecimal((double)-3.6);
        NodeValue r = XSDFuncOp.floor((NodeValue)nv);
        TestXSDFuncOp.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (long)-4L, (long)r.getDecimal().longValue());
    }

    @org.junit.Test
    public void testFloor3() {
        NodeValue nv = NodeValue.makeDouble((double)2.6);
        NodeValue r = XSDFuncOp.floor((NodeValue)nv);
        TestXSDFuncOp.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDouble());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (double)2.0, (double)r.getDouble(), (double)0.0);
    }

    @org.junit.Test
    public void testFloor4() {
        NodeValue nv = NodeValue.makeDouble((double)-3.6);
        NodeValue r = XSDFuncOp.floor((NodeValue)nv);
        TestXSDFuncOp.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDouble());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (double)-4.0, (double)r.getDouble(), (double)0.0);
    }

    @org.junit.Test
    public void testFloor5() {
        NodeValue nv = NodeValue.makeInteger((long)3L);
        NodeValue r = XSDFuncOp.floor((NodeValue)nv);
        TestXSDFuncOp.assertTrue((String)("Not an integer: " + r), (boolean)r.isInteger());
        TestXSDFuncOp.assertTrue((String)("Not a NodeValueInteger: " + r), (boolean)(r instanceof NodeValueInteger));
        TestXSDFuncOp.assertEquals((String)"Wrong result", (long)3L, (long)r.getInteger().longValue());
    }

    @org.junit.Test
    public void testSqrt1() {
        NodeValue four = NodeValue.makeInteger((long)4L);
        NodeValue two = NodeValue.makeInteger((long)2L);
        NodeValue result = XSDFuncOp.sqrt((NodeValue)four);
        TestXSDFuncOp.assertTrue((boolean)result.isDecimal());
        TestXSDFuncOp.assertTrue((boolean)NodeValue.sameAs((NodeValue)two, (NodeValue)result));
        TestXSDFuncOp.assertTrue((boolean)two.asNode().sameValueAs((Object)result.asNode()));
    }

    @org.junit.Test
    public void testSqrt2() {
        NodeValue four = NodeValue.makeDouble((double)4.0);
        NodeValue two = NodeValue.makeInteger((long)2L);
        NodeValue result = XSDFuncOp.sqrt((NodeValue)four);
        TestXSDFuncOp.assertTrue((boolean)result.isDouble());
        TestXSDFuncOp.assertTrue((boolean)NodeValue.sameAs((NodeValue)two, (NodeValue)result));
        TestXSDFuncOp.assertNotNull((Object)result.asNode());
    }

    private static void testDateTimeCast(NodeValue nv, XSDDatatype xsd, NodeValue nvResult) {
        NodeValue nv2 = XSDFuncOp.dateTimeCast((NodeValue)nv, (XSDDatatype)xsd);
        Assert.assertEquals((Object)nvResult, (Object)nv2);
    }

    @org.junit.Test
    public void cast_gregorian_01() {
        TestXSDFuncOp.testDateTimeCast(nv_dt, XSDDatatype.XSDdateTime, nv_dt);
    }

    @org.junit.Test
    public void cast_gregorian_02() {
        TestXSDFuncOp.testDateTimeCast(nv_dt, XSDDatatype.XSDdate, nv_d);
    }

    @org.junit.Test
    public void cast_gregorian_03() {
        TestXSDFuncOp.testDateTimeCast(nv_dt, XSDDatatype.XSDgYear, nv_gy);
    }

    @org.junit.Test
    public void cast_gregorian_04() {
        TestXSDFuncOp.testDateTimeCast(nv_dt, XSDDatatype.XSDgYearMonth, nv_gym);
    }

    @org.junit.Test
    public void cast_gregorian_05() {
        TestXSDFuncOp.testDateTimeCast(nv_dt, XSDDatatype.XSDgMonthDay, nv_gmd);
    }

    @org.junit.Test
    public void cast_gregorian_06() {
        TestXSDFuncOp.testDateTimeCast(nv_dt, XSDDatatype.XSDgMonth, nv_gm);
    }

    @org.junit.Test
    public void cast_gregorian_07() {
        TestXSDFuncOp.testDateTimeCast(nv_dt, XSDDatatype.XSDgDay, nv_gd);
    }

    @org.junit.Test
    public void cast_gregorian_08() {
        TestXSDFuncOp.testDateTimeCast(nv_dt, XSDDatatype.XSDtime, nv_t);
    }

    @org.junit.Test
    public void cast_gregorian_10() {
        TestXSDFuncOp.testDateTimeCast(nv_d, XSDDatatype.XSDdateTime, NodeValue.makeNode((String)"2010-03-22T00:00:00", (XSDDatatype)XSDDatatype.XSDdateTime));
    }

    @org.junit.Test
    public void cast_gregorian_11() {
        TestXSDFuncOp.testDateTimeCast(nv_d, XSDDatatype.XSDdate, nv_d);
    }

    @org.junit.Test
    public void cast_gregorian_12() {
        TestXSDFuncOp.testDateTimeCast(nv_d, XSDDatatype.XSDgYear, nv_gy);
    }

    @org.junit.Test
    public void cast_gregorian_13() {
        TestXSDFuncOp.testDateTimeCast(nv_d, XSDDatatype.XSDgYearMonth, nv_gym);
    }

    @org.junit.Test
    public void cast_gregorian_14() {
        TestXSDFuncOp.testDateTimeCast(nv_d, XSDDatatype.XSDgMonthDay, nv_gmd);
    }

    @org.junit.Test
    public void cast_gregorian_15() {
        TestXSDFuncOp.testDateTimeCast(nv_d, XSDDatatype.XSDgMonth, nv_gm);
    }

    @org.junit.Test
    public void cast_gregorian_16() {
        TestXSDFuncOp.testDateTimeCast(nv_d, XSDDatatype.XSDgDay, nv_gd);
    }

    @org.junit.Test
    public void cast_gregorian_21() {
        TestXSDFuncOp.testDateTimeCast(nv_gym, XSDDatatype.XSDgYearMonth, nv_gym);
    }

    @org.junit.Test
    public void cast_gregorian_22() {
        TestXSDFuncOp.testDateTimeCast(nv_gy, XSDDatatype.XSDgYear, nv_gy);
    }

    @org.junit.Test
    public void cast_gregorian_23() {
        TestXSDFuncOp.testDateTimeCast(nv_gmd, XSDDatatype.XSDgMonthDay, nv_gmd);
    }

    @org.junit.Test
    public void cast_gregorian_24() {
        TestXSDFuncOp.testDateTimeCast(nv_gm, XSDDatatype.XSDgMonth, nv_gm);
    }

    @org.junit.Test
    public void cast_gregorian_25() {
        TestXSDFuncOp.testDateTimeCast(nv_gd, XSDDatatype.XSDgDay, nv_gd);
    }

    @org.junit.Test(expected=ExprEvalTypeException.class)
    public void cast_gregorian_31() {
        TestXSDFuncOp.testDateTimeCast(nv_gym, XSDDatatype.XSDdate, nv_d);
    }

    @org.junit.Test(expected=ExprEvalTypeException.class)
    public void cast_gregorian_32() {
        TestXSDFuncOp.testDateTimeCast(nv_gy, XSDDatatype.XSDdate, NodeValue.makeDate((String)"2010-01-01"));
    }

    @org.junit.Test(expected=ExprEvalTypeException.class)
    public void cast_gregorian_33() {
        TestXSDFuncOp.testDateTimeCast(nv_gmd, XSDDatatype.XSDdate, nv_d);
    }

    @org.junit.Test(expected=ExprEvalTypeException.class)
    public void cast_gregorian_34() {
        TestXSDFuncOp.testDateTimeCast(nv_gm, XSDDatatype.XSDdate, nv_d);
    }

    @org.junit.Test(expected=ExprEvalTypeException.class)
    public void cast_gregorian_35() {
        TestXSDFuncOp.testDateTimeCast(nv_gd, XSDDatatype.XSDdate, nv_d);
    }

    @org.junit.Test(expected=ExprEvalTypeException.class)
    public void cast_err_gregorian_01() {
        TestXSDFuncOp.testDateTimeCast(NodeValue.makeBoolean((boolean)false), XSDDatatype.XSDgDay, nv_gd);
    }
}

