/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.openjena.atlas.iterator.Iter;

public abstract class TestDataset {
    static Model model1 = ModelFactory.createDefaultModel();
    static Model model2 = ModelFactory.createDefaultModel();
    static Resource s1 = model1.createResource("s1");
    static Resource s2 = model1.createResource("s2");
    static Property p1 = model1.createProperty("p1");
    static Property p2 = model1.createProperty("p2");
    static Resource o1 = model1.createResource("o1");
    static Resource o2 = model1.createResource("o2");

    protected abstract DataSource create();

    @Test
    public void dataset_01() {
        DataSource ds = this.create();
        Assert.assertNotNull((Object)ds.getDefaultModel());
        Assert.assertNotNull((Object)ds.asDatasetGraph());
    }

    @Test
    public void dataset_02() {
        DataSource ds = this.create();
        ds.getDefaultModel().add(s1, p1, (RDFNode)o1);
        Assert.assertTrue((boolean)model1.isIsomorphicWith(ds.getDefaultModel()));
    }

    @Test
    public void datasource_01() {
        DataSource ds = this.create();
        ds.setDefaultModel(model2);
        Assert.assertTrue((boolean)model2.isIsomorphicWith(ds.getDefaultModel()));
    }

    @Test
    public void datasource_02() {
        String graphName = "http://example/";
        DataSource ds = this.create();
        ds.addNamedModel(graphName, model1);
        Assert.assertTrue((boolean)ds.containsNamedModel(graphName));
        List x = Iter.toList((Iterator)ds.listNames());
        Assert.assertEquals((int)1, (int)x.size());
        Assert.assertEquals((String)graphName, (String)((String)x.get(0)));
        Assert.assertFalse((boolean)model1.isIsomorphicWith(ds.getDefaultModel()));
        Model m = ds.getNamedModel(graphName);
        Assert.assertNotNull((Object)m);
        Assert.assertTrue((boolean)model1.isIsomorphicWith(m));
        ds.removeNamedModel(graphName);
        Model m2 = ds.getNamedModel(graphName);
        Assert.assertNull((Object)m2);
    }

    @Test
    public void datasource_03() {
        String graphName = "http://example/";
        DataSource ds = this.create();
        ds.addNamedModel(graphName, model1);
        ds.replaceNamedModel(graphName, model2);
        Assert.assertTrue((boolean)ds.containsNamedModel(graphName));
        List x = Iter.toList((Iterator)ds.listNames());
        Assert.assertEquals((int)1, (int)x.size());
        Assert.assertEquals((String)graphName, (String)((String)x.get(0)));
        Assert.assertFalse((boolean)model1.isIsomorphicWith(ds.getNamedModel(graphName)));
        Assert.assertTrue((boolean)model2.isIsomorphicWith(ds.getNamedModel(graphName)));
    }

    static {
        model1.add(s1, p1, (RDFNode)o1);
        model2.add(s2, p2, (RDFNode)o2);
    }
}

