/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.sparql.core.DatasetGraphCaching;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSG_Mem
extends DatasetGraphCaching {
    List<Triple> triples = new ArrayList<Triple>();
    List<Quad> quads = new ArrayList<Quad>();

    private int indexTriple(Triple triple) {
        for (int i = 0; i < this.triples.size(); ++i) {
            Triple t = this.triples.get(i);
            if (!t.equals((Object)triple)) continue;
            return i;
        }
        return -1;
    }

    private int indexQuad(Quad quad) {
        for (int i = 0; i < this.triples.size(); ++i) {
            Quad q = this.quads.get(i);
            if (!q.equals((Object)quad)) continue;
            return i;
        }
        return -1;
    }

    public Iterator<Quad> findInDftGraph(Node s, Node p, Node o) {
        ArrayList<Quad> results = new ArrayList<Quad>();
        for (Triple t : this.triples) {
            if (!this.matches(t, s, p, o)) continue;
            results.add(new Quad(Quad.tripleInQuad, t));
        }
        return results.iterator();
    }

    public Iterator<Quad> findInSpecificNamedGraph(Node g, Node s, Node p, Node o) {
        ArrayList<Quad> results = new ArrayList<Quad>();
        for (Quad q : this.quads) {
            if (!this.matches(q, g, s, p, o)) continue;
            results.add(q);
        }
        return results.iterator();
    }

    public Iterator<Quad> findInAnyNamedGraphs(Node s, Node p, Node o) {
        ArrayList<Quad> results = new ArrayList<Quad>();
        for (Quad q : this.quads) {
            if (!this.matches(q, Node.ANY, s, p, o)) continue;
            results.add(q);
        }
        return results.iterator();
    }

    private boolean matches(Triple t, Node s, Node p, Node o) {
        if (s == null) {
            s = Node.ANY;
        }
        if (p == null) {
            p = Node.ANY;
        }
        if (o == null) {
            o = Node.ANY;
        }
        return t.matches(s, p, o);
    }

    private boolean matches(Quad q, Node g, Node s, Node p, Node o) {
        if (g == null) {
            g = Node.ANY;
        }
        if (s == null) {
            s = Node.ANY;
        }
        if (p == null) {
            p = Node.ANY;
        }
        if (o == null) {
            o = Node.ANY;
        }
        return q.matches(g, s, p, o);
    }

    protected void addToDftGraph(Node s, Node p, Node o) {
        Triple t = new Triple(s, p, o);
        if (!this.triples.contains(t)) {
            this.triples.add(t);
        }
    }

    protected void addToNamedGraph(Node g, Node s, Node p, Node o) {
        Quad q = new Quad(g, s, p, o);
        if (!this.quads.contains(q)) {
            this.quads.add(q);
        }
    }

    protected void deleteFromDftGraph(Node s, Node p, Node o) {
        this.triples.remove(new Triple(s, p, o));
    }

    protected void deleteFromNamedGraph(Node g, Node s, Node p, Node o) {
        this.quads.remove(new Quad(g, s, p, o));
    }

    protected Graph _createDefaultGraph() {
        return new GraphDft();
    }

    protected Graph _createNamedGraph(Node graphNode) {
        return new GraphNamed(graphNode);
    }

    protected boolean _containsGraph(Node graphNode) {
        return this.graphNodes().contains(graphNode);
    }

    public Iterator<Node> listGraphNodes() {
        return this.graphNodes().iterator();
    }

    private Set<Node> graphNodes() {
        HashSet<Node> x = new HashSet<Node>();
        for (Quad q : this.quads) {
            x.add(q.getGraph());
        }
        return x;
    }

    protected void _close() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GraphNamed
    extends GraphBase {
        private final Node graphName;

        GraphNamed(Node gname) {
            this.graphName = gname;
        }

        public void performAdd(Triple t) {
            Quad q = new Quad(this.graphName, t);
            if (!DSG_Mem.this.quads.contains(q)) {
                DSG_Mem.this.quads.add(q);
            }
        }

        public void performDelete(Triple t) {
            Quad q = new Quad(this.graphName, t);
            DSG_Mem.this.quads.remove(q);
        }

        protected ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
            ArrayList<Triple> results = new ArrayList<Triple>();
            for (Quad q : DSG_Mem.this.quads) {
                if (!DSG_Mem.this.matches(q, this.graphName, m.getMatchSubject(), m.getMatchPredicate(), m.getMatchObject())) continue;
                results.add(q.asTriple());
            }
            return WrappedIterator.create(results.iterator());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GraphDft
    extends GraphBase {
        GraphDft() {
        }

        public void performAdd(Triple t) {
            if (!DSG_Mem.this.triples.contains(t)) {
                DSG_Mem.this.triples.add(t);
            }
        }

        public void performDelete(Triple t) {
            DSG_Mem.this.triples.remove(t);
        }

        protected ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
            ArrayList<Triple> results = new ArrayList<Triple>();
            for (Triple t : DSG_Mem.this.triples) {
                if (!t.matches(m.getMatchSubject(), m.getMatchPredicate(), m.getMatchObject())) continue;
                results.add(t);
            }
            return WrappedIterator.create(results.iterator());
        }
    }
}

