/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.api;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.util.graph.GraphFactory;
import com.hp.hpl.jena.vocabulary.OWL;
import junit.framework.TestCase;
import org.junit.Test;

public class TestAPI
extends TestCase {
    private static final String ns = "http://example/ns#";
    static Model m = GraphFactory.makeJenaDefaultModel();
    static Resource r1 = m.createResource();
    static Property p1 = m.createProperty("http://example/ns#p1");
    static Property p2 = m.createProperty("http://example/ns#p2");
    static Property p3 = m.createProperty("http://example/ns#p3");

    public void setUp() {
    }

    public void tearDown() {
    }

    @Test
    public void testInitialBindingsConstruct() {
        QueryExecution qExec = this.makeQExec("CONSTRUCT {?s ?p ?z} {?s ?p 'x1'}");
        QuerySolutionMap init = new QuerySolutionMap();
        init.add("z", (RDFNode)m.createLiteral("zzz"));
        qExec.setInitialBinding((QuerySolution)init);
        Model r = qExec.execConstruct();
        TestAPI.assertTrue((String)"Empty model", (r.size() > 0L ? 1 : 0) != 0);
        Property p1 = m.createProperty("http://example/ns#p1");
        TestAPI.assertTrue((String)"Empty model", (boolean)r.contains(null, p1, init.get("z")));
        qExec.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_API1() {
        QueryExecution qExec = this.makeQExec("SELECT * {?s ?p ?o}");
        try {
            ResultSet rs = qExec.execSelect();
            TestAPI.assertTrue((String)"No results", (boolean)rs.hasNext());
            QuerySolution qs = rs.nextSolution();
            Resource qr = qs.getResource("s");
            TestAPI.assertSame((String)"Not the same model as queried", (Object)qr.getModel(), (Object)m);
        }
        finally {
            qExec.close();
        }
    }

    @Test
    public void testInitialBindings0() {
        QuerySolutionMap smap1 = new QuerySolutionMap();
        QuerySolutionMap smap2 = new QuerySolutionMap();
        smap1.add("o", (RDFNode)m.createLiteral("y1"));
        smap2.addAll(smap1);
        TestAPI.assertTrue((boolean)smap2.contains("o"));
        smap2.clear();
        TestAPI.assertFalse((boolean)smap2.contains("o"));
        TestAPI.assertTrue((boolean)smap1.contains("o"));
        QuerySolutionMap smap3 = new QuerySolutionMap();
        smap2.addAll((QuerySolution)smap1);
        TestAPI.assertTrue((boolean)smap2.contains("o"));
    }

    @Test
    public void testInitialBindings1() {
        QueryExecution qExec = this.makeQExec("SELECT * {?s ?p ?o}");
        QuerySolutionMap init = new QuerySolutionMap();
        init.add("o", (RDFNode)m.createLiteral("y1"));
        qExec.setInitialBinding((QuerySolution)init);
        int count = this.queryAndCount(qExec);
        TestAPI.assertEquals((String)"Initial binding didn't restrict query properly", (int)1, (int)count);
    }

    @Test
    public void testInitialBindings2() {
        QueryExecution qExec = this.makeQExec("SELECT * {?s ?p ?o}");
        QuerySolutionMap init = new QuerySolutionMap();
        init.add("z", (RDFNode)m.createLiteral("zzz"));
        qExec.setInitialBinding((QuerySolution)init);
        int count = this.queryAndCount(qExec);
        TestAPI.assertEquals((String)"Initial binding restricted query improperly", (int)3, (int)count);
    }

    @Test
    public void testInitialBindings3() {
        QueryExecution qExec = this.makeQExec("SELECT * {?s ?p 'x1'}");
        QuerySolutionMap init = new QuerySolutionMap();
        init.add("z", (RDFNode)m.createLiteral("zzz"));
        qExec.setInitialBinding((QuerySolution)init);
        ResultSet rs = qExec.execSelect();
        QuerySolution qs = rs.nextSolution();
        TestAPI.assertTrue((String)"Initial setting not set correctly now", (boolean)qs.getLiteral("z").getLexicalForm().equals("zzz"));
        qExec.close();
    }

    @Test
    public void testInitialBindings4() {
        String queryString = "PREFIX : <http://example/ns#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nSELECT * \nWHERE { \n    ?x :p1 ?z .    NOT EXISTS { \n        ?x rdfs:label ?z . \n    }\n}";
        Query query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)m);
        QuerySolutionMap map = new QuerySolutionMap();
        map.add("this", (RDFNode)OWL.Thing);
        qexec.setInitialBinding((QuerySolution)map);
        ResultSet rs = qexec.execSelect();
        while (rs.hasNext()) {
            QuerySolution qs = rs.nextSolution();
        }
        qexec.close();
    }

    private QueryExecution makeQExec(String queryString) {
        Query q = QueryFactory.create((String)queryString);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Model)m);
        return qExec;
    }

    private int queryAndCount(String queryString) {
        QueryExecution qExec = this.makeQExec(queryString);
        return this.queryAndCount(qExec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int queryAndCount(QueryExecution qExec) {
        try {
            ResultSet rs = qExec.execSelect();
            int n = ResultSetFormatter.consume((ResultSet)rs);
            return n;
        }
        finally {
            qExec.close();
        }
    }

    static {
        m.add(r1, p1, "x1");
        m.add(r1, p2, "X2");
        m.add(r1, p3, "y1");
    }
}

