/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.builders.BuilderGraph;
import java.util.Iterator;
import java.util.List;
import org.junit.Test;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.StrUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUnionGraph
extends BaseTest {
    static String x = StrUtils.strjoinNL((String[])new String[]{"(dataset", "  (graph (<s> <p> <o>) (<x> <p> <o>) (<x2> <p> <o1>) (<x2> <p> <o3>) (<x2> <p> <o3>) (<x2> <p> <o4>))", "  (graph <g1> (triple <s1> <p1> <o1>))", "  (graph <g2> (triple <s2> <p2> <o2>))", "  (graph <g3> (triple <s2> <p2> <o2>))", ")"});
    static DatasetGraph dsg = BuilderGraph.buildDataset((Item)SSE.parse((String)x));

    @Test
    public void union_graph_triples_1() {
        List<Binding> results = this.exec("(graph <" + Quad.unionGraph + "> (bgp (<s2> ?p ?o)))", false);
        TestUnionGraph.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void union_graph_triples_2() {
        List<Binding> results = this.exec("(graph <" + Quad.unionGraph + "> (bgp (<x2> ?p ?o)))", false);
        TestUnionGraph.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void union_graph_quads_1() {
        List<Binding> results = this.exec("(graph <" + Quad.unionGraph + "> (bgp (<s2> ?p ?o)))", true);
        TestUnionGraph.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void union_graph_quads_2() {
        List<Binding> results = this.exec("(graph <" + Quad.unionGraph + "> (bgp (<x2> ?p ?o)))", true);
        TestUnionGraph.assertEquals((long)0L, (long)results.size());
    }

    private List<Binding> exec(String pattern, boolean applyQuad) {
        Op op = SSE.parseOp((String)pattern);
        if (applyQuad) {
            op = Algebra.toQuadForm((Op)op);
        }
        Op op2 = Algebra.unionDefaultGraph((Op)op);
        QueryIterator qIter = Algebra.exec((Op)op, (DatasetGraph)dsg);
        return Iter.toList((Iterator)qIter);
    }
}

