/*
 * Decompiled with CFR 0.152.
 */
package jena.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import jena.schemagen;
import junit.framework.TestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Test_schemagen
extends TestCase {
    String PREFIX = "@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .\n@prefix rdf:    <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n@prefix owl: <http://www.w3.org/2002/07/owl#> .\n@prefix ex: <http://example.com/sg#> .\n";
    private static Logger log = LoggerFactory.getLogger(Test_schemagen.class);

    public void testNoBaseURI0() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[0], new String[]{".*public static final Resource A =.*"}, new String[0]);
    }

    public void testClass0() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl"}, new String[]{".*public static final Resource A.*"}, new String[0]);
    }

    public void testClass1() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a rdfs:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl"}, new String[0], new String[]{".*public static final Resource A.*"});
    }

    public void testClass2() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs"}, new String[0], new String[]{".*public static final Resource A.*"});
    }

    public void testClass3() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a rdfs:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs"}, new String[]{".*public static final Resource A.*"}, new String[0]);
    }

    public void testProperty0() throws Exception {
        String SOURCE = this.PREFIX + "ex:p a owl:ObjectProperty .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl"}, new String[]{".*public static final Property p.*"}, new String[0]);
    }

    public void testProperty1() throws Exception {
        String SOURCE = this.PREFIX + "ex:p a rdf:Property .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl"}, new String[]{".*public static final Property p.*"}, new String[0]);
    }

    public void testProperty2() throws Exception {
        String SOURCE = this.PREFIX + "ex:p a owl:ObjectProperty .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs"}, new String[0], new String[]{".*public static final Property p.*"});
    }

    public void testProperty3() throws Exception {
        String SOURCE = this.PREFIX + "ex:p a rdf:Property .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs"}, new String[]{".*public static final Property p.*"}, new String[0]);
    }

    public void testInstance0() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class . ex:i a ex:A .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl"}, new String[]{".*public static final Resource i.*"}, new String[0]);
    }

    public void testInstance1() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a rdfs:Class . ex:i a ex:A .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl"}, new String[]{".*public static final Resource i.*"}, new String[0]);
    }

    public void testInstance3() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a rdfs:Class . ex:i a ex:A .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs"}, new String[]{".*public static final Resource i.*"}, new String[0]);
    }

    public void testInstance4() throws Exception {
        String SOURCE = this.PREFIX + "@prefix ex2: <http://example.org/otherNS#>. ex2:A a rdfs:Class . ex:i a ex2:A .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs"}, new String[]{".*public static final Resource i.*"}, new String[0]);
    }

    public void testInstance5() throws Exception {
        String SOURCE = "@prefix :        <http://ontology.earthster.org/eco/impact#> .\n@prefix core:    <http://ontology.earthster.org/eco/core#> .\n@prefix ecoinvent:  <http://ontology.earthster.org/eco/ecoinvent#> .\n@prefix owl:     <http://www.w3.org/2002/07/owl#> .\n@prefix rdf:     <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n@prefix rdfs:    <http://www.w3.org/2000/01/rdf-schema#> .\n@prefix xsd:     <http://www.w3.org/2001/XMLSchema#> .\n\n<http://ontology.earthster.org/eco/impact>\n      rdf:type owl:Ontology ;\n      owl:imports <http://ontology.earthster.org/eco/ecoinvent> , <http://ontology.earthster.org/eco/core> ;\n      owl:versionInfo \"Created with TopBraid Composer\"^^xsd:string .\n\n:CD-CML2001-AbioticDepletion\n      rdf:type core:ImpactAssessmentMethodCategoryDescription ;\n      rdfs:label \"abiotic resource depletion\"^^xsd:string ;\n      core:hasImpactCategory\n              :abioticDepletion .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"--owl", "--inference"}, new String[]{".*public static final Resource CD_CML2001_AbioticDepletion.*"}, new String[]{".*valtype.*"});
    }

    public void testRC0() throws Exception {
        String SOURCE = this.PREFIX + "ex:class a owl:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl"}, new String[0], new String[]{".*public static final Resource class .*"});
    }

    public void testComment0() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class ; rdfs:comment \"commentcomment\" .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl"}, new String[]{" */\\*\\* <p>commentcomment</p> \\*/ *"}, new String[0]);
    }

    public void testComment1() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class ; rdfs:comment \"commentcomment\" .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl", "--nocomments"}, new String[0], new String[]{" */\\*\\* <p>commentcomment</p> \\*/ *"});
    }

    public void testComment2() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class ; rdfs:comment \"commentcomment\" .";
        SchemaGenAux sga = new SchemaGenAux(){

            protected void go(String[] args) {
                this.go((schemagen.SchemagenOptions)new schemagen.SchemagenOptionsImpl(args));
            }
        };
        this.testSchemagenOutput(SOURCE, sga, new String[]{"-a", "http://example.com/sg#", "--owl", "-i", "file:\\\\C:\\Users\\fubar/vocabs/test.ttl"}, new String[]{".*Vocabulary definitions from file:\\\\\\\\C:\\\\Users\\\\fubar/vocabs/test.ttl.*"}, new String[0]);
    }

    public void testComment3() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class ; rdfs:comment \"commentcomment\" .";
        SchemaGenAux sga = new SchemaGenAux(){

            protected void go(String[] args) {
                this.go((schemagen.SchemagenOptions)new schemagen.SchemagenOptionsImpl(args));
            }
        };
        this.testSchemagenOutput(SOURCE, sga, new String[]{"-a", "http://example.com/sg#", "--owl", "-i", "C:\\Users\\fubar/vocabs/test.ttl"}, new String[]{".*Vocabulary definitions from C:\\\\Users\\\\fubar/vocabs/test.ttl.*"}, new String[0]);
    }

    public void testOntClass0() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl", "--ontology"}, new String[]{".*public static final OntClass A.*"}, new String[0]);
    }

    public void testOntClass1() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a rdfs:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl", "--ontology"}, new String[0], new String[]{".*public static final OntClass A.*"});
    }

    public void testOntClass2() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs", "--ontology"}, new String[0], new String[]{".*public static final OntClass A.*"});
    }

    public void testOntClass3() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a rdfs:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs", "--ontology"}, new String[]{".*public static final OntClass A.*"}, new String[0]);
    }

    public void testOntProperty0() throws Exception {
        String SOURCE = this.PREFIX + "ex:p a owl:ObjectProperty .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl", "--ontology"}, new String[]{".*public static final ObjectProperty p.*"}, new String[0]);
    }

    public void testOntProperty1() throws Exception {
        String SOURCE = this.PREFIX + "ex:p a rdf:Property .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl", "--ontology"}, new String[]{".*public static final OntProperty p.*"}, new String[0]);
    }

    public void testOntProperty2() throws Exception {
        String SOURCE = this.PREFIX + "ex:p a owl:ObjectProperty .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs", "--ontology"}, new String[0], new String[]{".*public static final ObjectProperty p.*"});
    }

    public void testOntProperty3() throws Exception {
        String SOURCE = this.PREFIX + "ex:p a rdf:Property .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs", "--ontology"}, new String[]{".*public static final OntProperty p.*"}, new String[0]);
    }

    public void testHeader() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--ontology", "--header", "/* header */\n%package%\n%imports%\n"}, new String[]{"/\\* header \\*/"}, new String[0]);
    }

    public void testFooter() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--ontology", "--footer", "/* footer */"}, new String[]{"/\\* footer \\*/"}, new String[0]);
    }

    public void testPackage() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--ontology", "--package", "test.test"}, new String[]{"package test.test;\\s*"}, new String[0]);
    }

    public void testClassname() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class .";
        SchemaGenAux fixture = new SchemaGenAux(){

            protected void go(String[] args) {
                SchemagenOptionsFixture sgf = new SchemagenOptionsFixture(args){

                    public Resource getInputOption() {
                        return ResourceFactory.createResource((String)"http://example.org/soggy");
                    }
                };
                this.go((schemagen.SchemagenOptions)sgf);
            }
        };
        this.testSchemagenOutput(SOURCE, fixture, new String[]{"-a", "http://example.com/soggy#", "--ontology", "--package", "test.test", "-n", "Sg"}, new String[0], new String[0]);
    }

    public void testClassdec() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--ontology", "--classdec", "\n    implements java.lang.Cloneable\n"}, new String[]{"\\s*implements java.lang.Cloneable\\s*"}, new String[0]);
    }

    public void testDeclarations() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--ontology", "--declarations", "protected String m_gnole = \"Fungle\";;\n"}, new String[]{".*Fungle.*"}, new String[0]);
    }

    public void testNoClasses() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--ontology", "--noclasses"}, new String[0], new String[]{".*OntClass A.*"});
    }

    public void testNoProperties() throws Exception {
        String SOURCE = this.PREFIX + "ex:p a owl:ObjectProperty .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl", "--ontology", "--noproperties"}, new String[0], new String[]{".*Property p.*"});
    }

    public void testNoIndividuals() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class . ex:i a ex:A .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl", "--noindividuals"}, new String[]{".*Resource A.*"}, new String[]{".*Resource i.*"});
    }

    public void testNoHeader() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class . ex:i a ex:A .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl", "--noheader"}, new String[0], new String[]{"/\\*\\*.*"});
    }

    public void testUCNames() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class . ex:i a ex:A .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl", "--uppercase"}, new String[]{".*Resource A.*", ".*Resource I.*"}, new String[0]);
    }

    public void testInference0() throws Exception {
        String SOURCE = this.PREFIX + "ex:p rdfs:domain ex:A .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl"}, new String[0], new String[]{".*Resource A.*", ".*Property p.*"});
    }

    public void testInference1() throws Exception {
        String SOURCE = this.PREFIX + "ex:p rdfs:domain ex:A .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl", "--inference"}, new String[]{".*Resource A.*", ".*Property p.*"}, new String[0]);
    }

    public void testInference2() throws Exception {
        String SOURCE = this.PREFIX + "ex:p rdfs:domain ex:A .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs", "--inference"}, new String[]{".*Resource A.*", ".*Property p.*"}, new String[0]);
    }

    public void testStrictIndividuals0() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class . ex:i a ex:A . <http://example.com/different#j> a ex:A .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs"}, new String[]{".*Resource i.*", ".*Resource j.*"}, new String[0]);
    }

    public void testStrictIndividuals1() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class . ex:i a ex:A . <http://example.com/different#j> a ex:A .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs", "--strictIndividuals"}, new String[]{".*Resource i.*"}, new String[]{".*Resource j.*"});
    }

    public void testLineEnd0() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class . ex:i a ex:A . ex:p a rdf:Property .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs", "--strictIndividuals"}, new String[0], new String[]{".*\r.*"});
    }

    public void testLineEnd1() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class . ex:i a ex:A . ex:p a rdf:Property .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--rdfs", "--dos"}, new String[]{".*\\r"}, new String[]{".*[^\r]"});
    }

    public void testIncludeSource0() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class . ex:i a ex:A . ex:p a owl:ObjectProperty .";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl", "--includeSource"}, new String[]{".*private static final String SOURCE.*", ".*ex:A *(a|rdf:type) *owl:Class.*"}, new String[0]);
    }

    public void testIncludeSource1() throws Exception {
        String SOURCE = this.PREFIX + "ex:A a owl:Class ; rdfs:comment \"comment\".";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl", "--includeSource"}, new String[]{".*\\\\\"comment\\\\\".*\""}, new String[0]);
    }

    public void testIncludeSource2() throws Exception {
        String SOURCE = this.PREFIX + "@prefix skos: <http://www.w3.org/2004/02/skos/core#>.\n" + " <http://purl.org/dc/elements/1.1/relation> skos:note \"\"\"A second property with the same name as this property has been declared in the dcterms: namespace (http://purl.org/dc/terms/).  See the Introduction to the document \"DCMI Metadata Terms\" (http://dublincore.org/documents/dcmi-terms/) for an explanation.\"\"\".";
        this.testSchemagenOutput(SOURCE, null, new String[]{"-a", "http://example.com/sg#", "--owl", "--includeSource"}, new String[0], new String[0]);
    }

    protected String testSchemagenOutput(String source, SchemaGenAux sg, String[] args, String[] posPatterns, String[] negPatterns) throws Exception {
        sg = sg == null ? new SchemaGenAux() : sg;
        Model m = ModelFactory.createDefaultModel();
        m.read((Reader)new StringReader(source), "http://example.com/sg#", "N3");
        sg.setSource(m);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        sg.setOutput(new PrintStream(buf));
        sg.testGo(args);
        String result = buf.toString();
        StringTokenizer tokens = new StringTokenizer(result, "\n");
        boolean[] foundPos = new boolean[posPatterns.length];
        while (tokens.hasMoreTokens()) {
            Pattern pat;
            String line = tokens.nextToken();
            int i = 0;
            while (i < posPatterns.length) {
                pat = Pattern.compile(posPatterns[i]);
                int n = i++;
                foundPos[n] = foundPos[n] | pat.matcher(line).matches();
            }
            for (i = 0; i < negPatterns.length; ++i) {
                pat = Pattern.compile(negPatterns[i]);
                Test_schemagen.assertFalse((String)("negative match pattern ||" + negPatterns[i] + "|| matched on line: " + line), (boolean)pat.matcher(line).matches());
            }
        }
        for (int i = 0; i < posPatterns.length; ++i) {
            String msg = "Expecting a positive match to pattern: ||" + posPatterns[i] + "||";
            Test_schemagen.assertTrue((String)(msg + " in:\n" + result), (boolean)foundPos[i]);
        }
        this.testCompile(result, "Sg");
        return result;
    }

    protected void testCompile(String source, String defaultClassName) throws Exception {
        String className = defaultClassName;
        String key = "public class ";
        int i = source.indexOf(key);
        if (i > 0) {
            className = source.substring(i += key.length(), source.indexOf(" ", i));
        }
        File tmpDir = FileUtils.getScratchDirectory((String)"schemagen");
        File srcFile = new File(tmpDir, className + ".java");
        FileWriter out = new FileWriter(srcFile);
        out.write(source);
        out.close();
        try {
            Class<?> tp = Class.forName("javax.tools.ToolProvider");
            Method gsjc = tp.getMethod("getSystemJavaCompiler", new Class[0]);
            Object sjc = gsjc.invoke(null, new Object[0]);
            Class<?> jc = Class.forName("javax.tools.JavaCompiler");
            Method jcRun = jc.getMethod("run", InputStream.class, OutputStream.class, OutputStream.class, String[].class);
            String[] args = new String[]{"-classpath", this.getClassPath(tmpDir), "-d", tmpDir.getPath(), srcFile.getPath()};
            int success = (Integer)jcRun.invoke(sjc, null, null, null, args);
            Test_schemagen.assertEquals((String)"Errors reported from compilation of schemagen output", (int)0, (int)success);
        }
        catch (ClassNotFoundException nf) {
            log.debug("javax.tools not found (no tools.jar on classpath?). schemagen compilation test skipped.");
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            Test_schemagen.fail((String)e.getMessage());
        }
        ArrayList<File> toClean = new ArrayList<File>();
        toClean.add(tmpDir);
        while (!toClean.isEmpty()) {
            File f = (File)toClean.remove(0);
            f.deleteOnExit();
            if (!f.isDirectory()) continue;
            for (File g : f.listFiles()) {
                toClean.add(g);
            }
        }
    }

    protected String getClassPath(File tmpDir) {
        Properties pp = System.getProperties();
        return pp.getProperty("surefire.test.class.path", pp.getProperty("java.class.path"));
    }

    static class SchemagenOptionsFixture
    extends schemagen.SchemagenOptionsImpl {
        public SchemagenOptionsFixture(String[] args) {
            super(args);
        }

        public Resource getInputOption() {
            return ResourceFactory.createResource((String)"http://example.org/sg");
        }
    }

    static class SchemaGenAux
    extends schemagen {
        protected PrintStream m_auxOutput;
        protected Model m_auxSource;

        SchemaGenAux() {
        }

        public void setOutput(PrintStream out) {
            this.m_auxOutput = out;
        }

        public void setSource(Model m) {
            this.m_auxSource = m;
        }

        protected void selectInput() {
            this.m_source.add(this.m_auxSource);
            this.m_source.setNsPrefixes((PrefixMapping)this.m_auxSource);
        }

        protected void selectOutput() {
            super.selectOutput();
            this.m_output = this.m_auxOutput;
        }

        public void testGo(String[] args) {
            this.go(args);
        }

        protected void go(String[] args) {
            this.go((schemagen.SchemagenOptions)new SchemagenOptionsFixture(args));
        }

        protected void abort(String msg, Exception e) {
            throw new RuntimeException(msg, e);
        }
    }
}

