/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput;

import com.hp.hpl.jena.xmloutput.TestXMLFeatures;
import com.hp.hpl.jena.xmloutput.XMLOutputTestBase;
import java.io.IOException;

public class TestXMLAbbrev
extends XMLOutputTestBase {
    public TestXMLAbbrev(String name) {
        super(name, "RDF/XML-ABBREV");
    }

    public void testNoPropAttr() throws IOException {
        this.check(TestXMLFeatures.file1, null, "prop1=", XMLOutputTestBase.Change.blockRules("propertyAttr"));
    }

    public void testNoDamlCollection() throws IOException {
        this.check("testing/abbreviated/daml.rdf", null, "[\"']daml:collection[\"']", XMLOutputTestBase.Change.blockRules("daml:collection"));
    }

    public void testNoRdfCollection() throws IOException {
        this.check("testing/abbreviated/collection.rdf", null, "[\"']Collection[\"']", XMLOutputTestBase.Change.blockRules("parseTypeCollectionPropertyElt"));
    }

    public void testNoLi() throws IOException {
        this.check("testing/abbreviated/container.rdf", null, "rdf:li", XMLOutputTestBase.Change.blockRules("section-List-Expand"));
    }

    public void testNoID() throws IOException {
        this.check("testing/abbreviated/container.rdf", "rdf:ID", XMLOutputTestBase.Change.blockRules("idAttr"), "http://example.org/foo");
    }

    public void testNoID2() throws IOException {
        this.check("testing/abbreviated/container.rdf", "rdf:ID", XMLOutputTestBase.Change.blockRules("idAttr"), "http://example.org/foo#");
    }

    public void testNoResource() throws IOException {
        this.check("testing/abbreviated/container.rdf", "['\"]Resource[\"']", XMLOutputTestBase.Change.blockRules("parseTypeResourcePropertyElt"), "http://example.org/foo#");
    }

    public void testPropAttrs() throws IOException {
        this.check("testing/abbreviated/namespaces.rdf", ":prop0 *=", null, XMLOutputTestBase.Change.blockRules(""));
    }

    public void testNoPropAttrs() throws IOException {
        this.check("testing/abbreviated/namespaces.rdf", null, ":prop0 *=", XMLOutputTestBase.Change.none());
    }

    public void testNoReification() throws IOException {
        String filename = "testing/abbreviated/reification.rdf";
        String base = "http://example.org/foo";
        this.check(filename, null, "rdf:subject", null, false, XMLOutputTestBase.Change.blockRules("section-Reification"), base);
    }

    public void testNoCookUp() throws IOException {
        this.check("testing/abbreviated/cookup.rdf", null, "j.cook.up", XMLOutputTestBase.Change.blockRules(""));
    }
}

