/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.util.FileManager;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public class TestWriterFeatures
extends ModelTestBase {
    private static String testFileBase = "file:testing/abbreviated";

    public TestWriterFeatures(String name) {
        super(name);
    }

    private void checkReadWriteRead(String filename, String writerName, String propertyName, String propertyValue) {
        Model model = TestWriterFeatures.createMemModel();
        FileManager.get().readModel(model, filename);
        StringWriter sw = new StringWriter();
        RDFWriter w = model.getWriter(writerName);
        if (propertyName != null) {
            w.setProperty(propertyName, (Object)propertyValue);
        }
        w.write(model, (Writer)sw, null);
        try {
            sw.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        Model model2 = TestWriterFeatures.createMemModel();
        model2.read((Reader)new StringReader(sw.toString()), filename);
        TestWriterFeatures.assertTrue((boolean)model.isIsomorphicWith(model2));
    }

    private void checkReadWriteRead(String filename, String propertyName, String propertyValue) {
        this.checkReadWriteRead(filename, "RDF/XML", propertyName, propertyValue);
        this.checkReadWriteRead(filename, "RDF/XML-ABBREV", propertyName, propertyValue);
    }

    public void testEntity_0() {
        this.checkReadWriteRead(testFileBase + "/entities_1.ttl", "showXmlDeclaration", "true");
    }

    public void testEntity_1() {
        this.checkReadWriteRead(testFileBase + "/entities_1.ttl", "showDoctypeDeclaration", "true");
    }

    public void testEntity_2() {
        this.checkReadWriteRead(testFileBase + "/entities_2.ttl", "showDoctypeDeclaration", "true");
    }

    public void testEntity_3() {
        this.checkReadWriteRead(testFileBase + "/entities_3.ttl", "showDoctypeDeclaration", "true");
    }
}

