/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.vocabulary.test;

import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.OWL2;
import com.hp.hpl.jena.vocabulary.test.VocabTestBase;

public class TestOWL2Vocabulary
extends VocabTestBase {
    public TestOWL2Vocabulary(String name) {
        super(name);
    }

    public void testOWL2SharesOWL1URI() {
        TestOWL2Vocabulary.assertEquals((String)OWL.getURI(), (String)OWL2.getURI());
    }

    public void testOWL2TermSpellings() {
        this.assertResource(OWL2.AllDifferent, "AllDifferent");
        this.assertResource(OWL2.AllDisjointClasses, "AllDisjointClasses");
        this.assertResource(OWL2.AllDisjointProperties, "AllDisjointProperties");
        this.assertResource(OWL2.Annotation, "Annotation");
        this.assertResource(OWL2.AnnotationProperty, "AnnotationProperty");
        this.assertResource(OWL2.AsymmetricProperty, "AsymmetricProperty");
        this.assertResource(OWL2.Axiom, "Axiom");
        this.assertResource(OWL2.Class, "Class");
        this.assertResource(OWL2.DataRange, "DataRange");
        this.assertResource(OWL2.DatatypeProperty, "DatatypeProperty");
        this.assertResource(OWL2.DeprecatedClass, "DeprecatedClass");
        this.assertResource(OWL2.DeprecatedProperty, "DeprecatedProperty");
        this.assertResource(OWL2.FunctionalProperty, "FunctionalProperty");
        this.assertResource(OWL2.InverseFunctionalProperty, "InverseFunctionalProperty");
        this.assertResource(OWL2.IrreflexiveProperty, "IrreflexiveProperty");
        this.assertResource(OWL2.NamedIndividual, "NamedIndividual");
        this.assertResource(OWL2.NegativePropertyAssertion, "NegativePropertyAssertion");
        this.assertResource(OWL2.Nothing, "Nothing");
        this.assertResource(OWL2.ObjectProperty, "ObjectProperty");
        this.assertResource(OWL2.Ontology, "Ontology");
        this.assertResource(OWL2.OntologyProperty, "OntologyProperty");
        this.assertResource(OWL2.ReflexiveProperty, "ReflexiveProperty");
        this.assertResource(OWL2.Restriction, "Restriction");
        this.assertResource(OWL2.SymmetricProperty, "SymmetricProperty");
        this.assertResource(OWL2.Thing, "Thing");
        this.assertResource(OWL2.TransitiveProperty, "TransitiveProperty");
        this.assertProperty(OWL2.allValuesFrom, "allValuesFrom");
        this.assertProperty(OWL2.annotatedProperty, "annotatedProperty");
        this.assertProperty(OWL2.annotatedSource, "annotatedSource");
        this.assertProperty(OWL2.annotatedTarget, "annotatedTarget");
        this.assertProperty(OWL2.assertionProperty, "assertionProperty");
        this.assertProperty(OWL2.backwardCompatibleWith, "backwardCompatibleWith");
        this.assertProperty(OWL2.bottomDataProperty, "bottomDataProperty");
        this.assertProperty(OWL2.bottomObjectProperty, "bottomObjectProperty");
        this.assertProperty(OWL2.cardinality, "cardinality");
        this.assertProperty(OWL2.complementOf, "complementOf");
        this.assertProperty(OWL2.datatypeComplementOf, "datatypeComplementOf");
        this.assertProperty(OWL2.deprecated, "deprecated");
        this.assertProperty(OWL2.differentFrom, "differentFrom");
        this.assertProperty(OWL2.disjointUnionOf, "disjointUnionOf");
        this.assertProperty(OWL2.disjointWith, "disjointWith");
        this.assertProperty(OWL2.distinctMembers, "distinctMembers");
        this.assertProperty(OWL2.equivalentClass, "equivalentClass");
        this.assertProperty(OWL2.equivalentProperty, "equivalentProperty");
        this.assertProperty(OWL2.hasKey, "hasKey");
        this.assertProperty(OWL2.hasSelf, "hasSelf");
        this.assertProperty(OWL2.hasValue, "hasValue");
        this.assertProperty(OWL2.imports, "imports");
        this.assertProperty(OWL2.incompatibleWith, "incompatibleWith");
        this.assertProperty(OWL2.intersectionOf, "intersectionOf");
        this.assertProperty(OWL2.inverseOf, "inverseOf");
        this.assertProperty(OWL2.maxCardinality, "maxCardinality");
        this.assertProperty(OWL2.maxQualifiedCardinality, "maxQualifiedCardinality");
        this.assertProperty(OWL2.members, "members");
        this.assertProperty(OWL2.minCardinality, "minCardinality");
        this.assertProperty(OWL2.minQualifiedCardinality, "minQualifiedCardinality");
        this.assertProperty(OWL2.onClass, "onClass");
        this.assertProperty(OWL2.onDataRange, "onDataRange");
        this.assertProperty(OWL2.onDatatype, "onDatatype");
        this.assertProperty(OWL2.onProperties, "onProperties");
        this.assertProperty(OWL2.onProperty, "onProperty");
        this.assertProperty(OWL2.oneOf, "oneOf");
        this.assertProperty(OWL2.priorVersion, "priorVersion");
        this.assertProperty(OWL2.propertyChainAxiom, "propertyChainAxiom");
        this.assertProperty(OWL2.propertyDisjointWith, "propertyDisjointWith");
        this.assertProperty(OWL2.qualifiedCardinality, "qualifiedCardinality");
        this.assertProperty(OWL2.sameAs, "sameAs");
        this.assertProperty(OWL2.someValuesFrom, "someValuesFrom");
        this.assertProperty(OWL2.sourceIndividual, "sourceIndividual");
        this.assertProperty(OWL2.targetIndividual, "targetIndividual");
        this.assertProperty(OWL2.targetValue, "targetValue");
        this.assertProperty(OWL2.topDataProperty, "topDataProperty");
        this.assertProperty(OWL2.topObjectProperty, "topObjectProperty");
        this.assertProperty(OWL2.unionOf, "unionOf");
        this.assertProperty(OWL2.versionIRI, "versionIRI");
        this.assertProperty(OWL2.versionInfo, "versionInfo");
        this.assertProperty(OWL2.withRestrictions, "withRestrictions");
    }

    public void testSharedOWLTerms() {
        TestOWL2Vocabulary.assertEquals((Object)OWL2.AllDifferent, (Object)OWL.AllDifferent);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.AnnotationProperty, (Object)OWL.AnnotationProperty);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.Class, (Object)OWL.Class);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.DataRange, (Object)OWL.DataRange);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.DatatypeProperty, (Object)OWL.DatatypeProperty);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.DeprecatedClass, (Object)OWL.DeprecatedClass);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.DeprecatedProperty, (Object)OWL.DeprecatedProperty);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.FunctionalProperty, (Object)OWL.FunctionalProperty);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.InverseFunctionalProperty, (Object)OWL.InverseFunctionalProperty);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.Nothing, (Object)OWL.Nothing);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.ObjectProperty, (Object)OWL.ObjectProperty);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.Ontology, (Object)OWL.Ontology);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.OntologyProperty, (Object)OWL.OntologyProperty);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.Restriction, (Object)OWL.Restriction);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.SymmetricProperty, (Object)OWL.SymmetricProperty);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.Thing, (Object)OWL.Thing);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.TransitiveProperty, (Object)OWL.TransitiveProperty);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.allValuesFrom, (Object)OWL.allValuesFrom);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.backwardCompatibleWith, (Object)OWL.backwardCompatibleWith);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.cardinality, (Object)OWL.cardinality);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.complementOf, (Object)OWL.complementOf);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.differentFrom, (Object)OWL.differentFrom);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.disjointWith, (Object)OWL.disjointWith);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.distinctMembers, (Object)OWL.distinctMembers);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.equivalentClass, (Object)OWL.equivalentClass);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.equivalentProperty, (Object)OWL.equivalentProperty);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.hasValue, (Object)OWL.hasValue);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.imports, (Object)OWL.imports);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.incompatibleWith, (Object)OWL.incompatibleWith);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.intersectionOf, (Object)OWL.intersectionOf);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.inverseOf, (Object)OWL.inverseOf);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.maxCardinality, (Object)OWL.maxCardinality);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.minCardinality, (Object)OWL.minCardinality);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.onProperty, (Object)OWL.onProperty);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.oneOf, (Object)OWL.oneOf);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.priorVersion, (Object)OWL.priorVersion);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.sameAs, (Object)OWL.sameAs);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.someValuesFrom, (Object)OWL.someValuesFrom);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.unionOf, (Object)OWL.unionOf);
        TestOWL2Vocabulary.assertEquals((Object)OWL2.versionInfo, (Object)OWL.versionInfo);
    }

    private void assertProperty(Property p, String local) {
        this.assertProperty(OWL2.getURI() + local, p);
    }

    private void assertResource(Resource r, String local) {
        this.assertResource(OWL2.getURI() + local, r);
    }
}

