/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.iterator.test;

import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestAsCollection
extends ModelTestBase {
    public TestAsCollection(String name) {
        super(name);
    }

    public void testAsList() {
        this.testReturnsList("");
        this.testReturnsList("understanding");
        this.testReturnsList("understanding is");
        this.testReturnsList("understanding is a three-edged sword");
    }

    public void testAsSet() {
        this.testReturnsSet("");
        this.testReturnsSet("x");
        this.testReturnsSet("x x");
        this.testReturnsSet("x y x");
        this.testReturnsSet("a b c d e f a c f x");
        this.testReturnsSet("the avalanch has already started");
    }

    private Set<String> testReturnsSet(String elements) {
        Set<String> result = TestAsCollection.setOfStrings(elements);
        TestAsCollection.assertEquals(result, (Object)WrappedIterator.create(result.iterator()).toSet());
        return result;
    }

    private void testReturnsList(String elements) {
        List<String> L = TestAsCollection.listOfStrings(elements);
        TestAsCollection.assertEquals(L, (Object)WrappedIterator.create(L.iterator()).toList());
    }
}

