/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared.uuid;

import com.hp.hpl.jena.shared.uuid.Bits;
import junit.framework.TestCase;

public class TestBits
extends TestCase {
    public void testMask1() {
        long v = Bits.mask((int)0, (int)1);
        this.check(1L, v);
    }

    public void testMask2() {
        long v = Bits.mask((int)0, (int)2);
        this.check(3L, v);
    }

    public void testMask3() {
        long v = Bits.mask((int)1, (int)2);
        this.check(2L, v);
    }

    public void testMask4() {
        long v = Bits.mask((int)0, (int)64);
        this.check(-1L, v);
    }

    public void testMask5() {
        long v = Bits.mask((int)16, (int)48);
        this.check(0xFFFFFFFF0000L, v);
    }

    public void testMask6() {
        long v = Bits.mask((int)16, (int)64);
        this.check(-65536L, v);
    }

    public void testMask7() {
        long v = Bits.mask((int)0, (int)0);
        this.check(0L, v);
    }

    public void testMaskZero1() {
        long v = Bits.maskZero((int)0, (int)1);
        this.check(-2L, v);
    }

    public void testMaskZero2() {
        long v = Bits.maskZero((int)0, (int)2);
        this.check(-4L, v);
    }

    public void testMaskZero3() {
        long v = Bits.maskZero((int)1, (int)2);
        this.check(-3L, v);
    }

    public void testMaskZero4() {
        long v = Bits.maskZero((int)0, (int)64);
        this.check(0L, v);
    }

    public void testMaskZero5() {
        long v = Bits.maskZero((int)16, (int)48);
        this.check(-281474976645121L, v);
    }

    public void testMaskZero6() {
        long v = Bits.maskZero((int)16, (int)64);
        this.check(65535L, v);
    }

    public void testMaskZero7() {
        long v = Bits.maskZero((int)0, (int)0);
        this.check(-1L, v);
    }

    public void testClear1() {
        long v = 61680L;
        v = Bits.clear((long)v, (int)4, (int)8);
        String s = Long.toHexString(v);
        this.check(61440L, v);
    }

    public void testClear2() {
        long v = Long.MIN_VALUE;
        v = Bits.clear((long)v, (int)63, (int)64);
        String s = Long.toHexString(v);
        this.check(0L, v);
    }

    public void testClear3() {
        long v = -4611686018427387904L;
        v = Bits.clear((long)v, (int)63, (int)64);
        String s = Long.toHexString(v);
        this.check(0x4000000000000000L, v);
    }

    public void testClear4() {
        long v = -1L;
        v = Bits.clear((long)v, (int)63, (int)64);
        String s = Long.toHexString(v);
        this.check(Long.MAX_VALUE, v);
    }

    public void testClear5() {
        long v = -1L;
        v = Bits.clear((long)v, (int)32, (int)64);
        String s = Long.toHexString(v);
        this.check(0xFFFFFFFFL, v);
    }

    public void testClear6() {
        long v = -1L;
        v = Bits.clear((long)v, (int)0, (int)32);
        String s = Long.toHexString(v);
        this.check(-4294967296L, v);
    }

    public void testClear7() {
        long v = -1L;
        v = Bits.clear((long)v, (int)0, (int)0);
        String s = Long.toHexString(v);
        this.check(-1L, v);
    }

    public void testSet1() {
        long v = 0L;
        v = Bits.set((long)v, (int)0, (int)1);
        this.check(1L, v);
    }

    public void testSet2() {
        long v = 1L;
        v = Bits.set((long)v, (int)0, (int)1);
        this.check(1L, v);
    }

    public void testSet3() {
        long v = 240L;
        v = Bits.set((long)v, (int)0, (int)1);
        this.check(241L, v);
    }

    public void testSet4() {
        long v = -1085102592571150096L;
        v = Bits.set((long)v, (int)0, (int)8);
        this.check(-1085102592571150081L, v);
    }

    public void testSet5() {
        long v = 0L;
        v = Bits.set((long)v, (int)16, (int)48);
        this.check(0xFFFFFFFF0000L, v);
    }

    public void testSet6() {
        long v = 0L;
        v = Bits.set((long)v, (int)63, (int)64);
        this.check(Long.MIN_VALUE, v);
    }

    public void testSet7() {
        long v = 0L;
        v = Bits.set((long)v, (int)62, (int)64);
        this.check(-4611686018427387904L, v);
    }

    public void testSet8() {
        long v = 0L;
        v = Bits.set((long)v, (int)0, (int)64);
        this.check(-1L, v);
    }

    public void testSet9() {
        long v = 0L;
        v = Bits.set((long)v, (int)10, (int)10);
        this.check(0L, v);
    }

    public void testSetBit1() {
        long v = 0L;
        v = Bits.set((long)v, (int)0);
        this.check(1L, v);
    }

    public void testSetBit2() {
        long v = 0L;
        v = Bits.set((long)v, (int)1);
        this.check(2L, v);
    }

    public void testSetBit3() {
        long v = 1L;
        v = Bits.set((long)v, (int)0);
        this.check(1L, v);
    }

    public void testSetBit4() {
        long v = -1L;
        v = Bits.set((long)v, (int)0);
        this.check(-1L, v);
    }

    public void testSetBit5() {
        long v = 0L;
        v = Bits.set((long)v, (int)62);
        this.check(0x4000000000000000L, v);
    }

    public void testSetBit6() {
        long v = 0L;
        v = Bits.set((long)v, (int)63);
        this.check(Long.MIN_VALUE, v);
    }

    public void testBitTest1() {
        long v = 0L;
        TestBits.assertTrue((boolean)Bits.test((long)v, (boolean)false, (int)0));
    }

    public void testBitTest2() {
        long v = 1L;
        TestBits.assertTrue((boolean)Bits.test((long)v, (boolean)true, (int)0));
    }

    public void testBitTest3() {
        long v = -1L;
        TestBits.assertTrue((boolean)Bits.test((long)v, (boolean)true, (int)63));
    }

    public void testBitTest4() {
        long v = Long.MAX_VALUE;
        TestBits.assertTrue((boolean)Bits.test((long)v, (boolean)false, (int)63));
    }

    public void testBitsTest1() {
        long v = -81985529216486896L;
        TestBits.assertTrue((boolean)Bits.test((long)v, (long)0L, (int)0, (int)4));
    }

    public void testBitsTest2() {
        long v = -81985529216486896L;
        TestBits.assertTrue((boolean)Bits.test((long)v, (long)16L, (int)0, (int)8));
    }

    public void testBitsTest3() {
        long v = -81985529216486896L;
        TestBits.assertTrue((boolean)Bits.test((long)v, (long)v, (int)0, (int)64));
    }

    public void testBitsTest4() {
        long v = -81985529216486896L;
        TestBits.assertFalse((boolean)Bits.test((long)v, (long)0L, (int)0, (int)64));
    }

    public void testBitsTest5() {
        long v = -81985529216486896L;
        TestBits.assertTrue((boolean)Bits.test((long)v, (long)205163983011840L, (int)16, (int)48));
    }

    public void testAccess1() {
        long v = -1L;
        v = Bits.access((long)v, (int)4, (int)8);
        this.check(240L, v);
    }

    public void testAccess2() {
        long v = -81985529216486896L;
        v = Bits.access((long)v, (int)0, (int)8);
        this.check(16L, v);
    }

    public void testAccess3() {
        long v = -81985529216486896L;
        v = Bits.access((long)v, (int)0, (int)64);
        this.check(-81985529216486896L, v);
    }

    public void testAccess4() {
        long v = -81985529216486896L;
        v = Bits.access((long)v, (int)62, (int)64);
        this.check(-4611686018427387904L, v);
    }

    public void testAccess5() {
        long v = -81985529216486896L;
        v = Bits.access((long)v, (int)0, (int)2);
        this.check(0L, v);
    }

    public void testPack1() {
        long v = 0L;
        v = Bits.pack((long)v, (long)15L, (int)0, (int)4);
        this.check(15L, v);
    }

    public void testPack2() {
        long v = 240L;
        v = Bits.pack((long)v, (long)2L, (int)0, (int)4);
        this.check(242L, v);
    }

    public void testPack3() {
        long v = -1L;
        v = Bits.pack((long)v, (long)2L, (int)0, (int)8);
        this.check(-254L, v);
    }

    public void testPack4() {
        long v = -4294967296L;
        v = Bits.pack((long)v, (long)2L, (int)16, (int)32);
        this.check(-4294836224L, v);
    }

    public void testPack5() {
        long v = -4294967296L;
        v = Bits.pack((long)v, (long)65535L, (int)16, (int)32);
        this.check(-65536L, v);
    }

    public void testUnpack1() {
        long v = -6067004223159161907L;
        v = Bits.unpack((long)v, (int)0, (int)4);
        this.check(13L, v);
    }

    public void testUnpack2() {
        long v = -6067004223159161907L;
        v = Bits.unpack((long)v, (int)63, (int)64);
        this.check(1L, v);
    }

    public void testUnpack3() {
        long v = -6067004223159161907L;
        v = Bits.unpack((long)v, (int)56, (int)64);
        this.check(171L, v);
    }

    public void testUnpack4() {
        long v = -6067173106999841843L;
        v = Bits.unpack((long)v, (int)32, (int)48);
        this.check(4660L, v);
    }

    public void testUnpackStr1() {
        String s = "ABCD";
        long v = Bits.unpack((String)s, (int)0, (int)4);
        this.check(43981L, v);
    }

    public void testUnpackStr2() {
        String s = "ABCD";
        long v = Bits.unpack((String)s, (int)2, (int)4);
        this.check(205L, v);
    }

    public void testUnpackStr3() {
        String s = "ABCD";
        long v = Bits.unpack((String)s, (int)0, (int)2);
        this.check(171L, v);
    }

    private void check(long expected, long actual) {
        this.check(null, expected, actual);
    }

    private void check(String msg, long expected, long actual) {
        if (expected == actual) {
            return;
        }
        String s = "Expected: " + Long.toHexString(expected) + " : Got: " + Long.toHexString(actual);
        if (msg != null) {
            s = msg + ": " + s;
        }
        TestBits.assertFalse((String)s, (boolean)true);
    }
}

