/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.regression.NewRegressionBase;
import junit.framework.TestSuite;

public class NewRegressionLiterals
extends NewRegressionBase {
    public NewRegressionLiterals(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(NewRegressionLiterals.class);
    }

    protected Model getModel() {
        return ModelFactory.createDefaultModel();
    }

    public void testBooleans() {
        Model m = this.getModel();
        NewRegressionLiterals.assertTrue((boolean)m.createTypedLiteral(true).getBoolean());
        NewRegressionLiterals.assertFalse((boolean)m.createTypedLiteral(false).getBoolean());
    }

    public void testByteLiterals() {
        Model m = this.getModel();
        this.testByte(m, (byte)0);
        this.testByte(m, (byte)-1);
        this.testByte(m, (byte)-128);
        this.testByte(m, (byte)127);
    }

    public void testShortLiterals() {
        Model m = this.getModel();
        this.testShort(m, (short)0);
        this.testShort(m, (short)-1);
        this.testShort(m, (short)Short.MIN_VALUE);
        this.testShort(m, (short)Short.MAX_VALUE);
    }

    public void testIntLiterals() {
        Model m = this.getModel();
        this.testInt(m, 0);
        this.testInt(m, -1);
        this.testInt(m, Integer.MIN_VALUE);
        this.testInt(m, Integer.MAX_VALUE);
    }

    public void testLongLiterals() {
        Model m = this.getModel();
        this.testLong(m, 0L);
        this.testLong(m, -1L);
        this.testLong(m, Long.MIN_VALUE);
        this.testLong(m, Long.MAX_VALUE);
    }

    public void testFloatLiterals() {
        Model m = this.getModel();
        this.testFloat(m, 0.0f);
        this.testFloat(m, 1.0f);
        this.testFloat(m, -1.0f);
        this.testFloat(m, 12345.679f);
        this.testFloat(m, Float.MIN_VALUE);
        this.testFloat(m, Float.MAX_VALUE);
    }

    public void testDoubleLiterals() {
        Model m = this.getModel();
        this.testDouble(m, 0.0);
        this.testDouble(m, 1.0);
        this.testDouble(m, -1.0);
        this.testDouble(m, 12345.678901);
        this.testDouble(m, Double.MIN_VALUE);
        this.testDouble(m, Double.MAX_VALUE);
    }

    public void testCharacterLiterals() {
        Model m = this.getModel();
        this.testCharacter(m, 'A');
        this.testCharacter(m, 'a');
        this.testCharacter(m, '#');
        this.testCharacter(m, '@');
        this.testCharacter(m, '0');
        this.testCharacter(m, '9');
        this.testCharacter(m, '\u1234');
        this.testCharacter(m, '\u5678');
    }

    public void testPlainStringLiterals() {
        Model m = this.getModel();
        this.testPlainString(m, "");
        this.testPlainString(m, "A test string");
        this.testPlainString(m, "Another test string");
    }

    public void testLanguagedStringLiterals() {
        Model m = this.getModel();
        this.testLanguagedString(m, "", "en");
        this.testLanguagedString(m, "chat", "fr");
    }

    public void testStringLiteralEquality() {
        Model m = this.getModel();
        NewRegressionLiterals.assertEquals((Object)m.createLiteral("A"), (Object)m.createLiteral("A"));
        NewRegressionLiterals.assertEquals((Object)m.createLiteral("Alpha"), (Object)m.createLiteral("Alpha"));
        NewRegressionLiterals.assertDiffer(m.createLiteral("Alpha"), m.createLiteral("Beta"));
        NewRegressionLiterals.assertDiffer(m.createLiteral("A", "en"), m.createLiteral("A"));
        NewRegressionLiterals.assertDiffer(m.createLiteral("A"), m.createLiteral("A", "en"));
        NewRegressionLiterals.assertDiffer(m.createLiteral("A", "en"), m.createLiteral("A", "fr"));
        NewRegressionLiterals.assertEquals((Object)m.createLiteral("A", "en"), (Object)m.createLiteral("A", "en"));
    }

    protected void testByte(Model m, byte tv) {
        Literal l = m.createTypedLiteral((int)tv);
        NewRegressionLiterals.assertEquals((byte)tv, (byte)l.getByte());
        NewRegressionLiterals.assertEquals((short)tv, (short)l.getShort());
        NewRegressionLiterals.assertEquals((int)tv, (int)l.getInt());
        NewRegressionLiterals.assertEquals((long)tv, (long)l.getLong());
    }

    protected void testShort(Model m, short tv) {
        Literal l = m.createTypedLiteral((int)tv);
        try {
            NewRegressionLiterals.assertEquals((short)tv, (short)l.getByte());
            this.assertInRange(-128L, tv, 127L);
        }
        catch (NumberFormatException e) {
            this.assertOutsideRange(-128L, tv, 127L);
        }
        catch (IllegalArgumentException e) {
            this.assertOutsideRange(-128L, tv, 127L);
        }
        NewRegressionLiterals.assertEquals((short)tv, (short)l.getShort());
        NewRegressionLiterals.assertEquals((int)tv, (int)l.getInt());
        NewRegressionLiterals.assertEquals((long)tv, (long)l.getLong());
    }

    protected void testInt(Model m, int tv) {
        Literal l = m.createTypedLiteral(tv);
        try {
            NewRegressionLiterals.assertEquals((int)tv, (int)l.getByte());
            this.assertInRange(-128L, tv, 127L);
        }
        catch (NumberFormatException e) {
            this.assertOutsideRange(-128L, tv, 127L);
        }
        catch (IllegalArgumentException e) {
            this.assertOutsideRange(-128L, tv, 127L);
        }
        try {
            NewRegressionLiterals.assertEquals((int)tv, (int)l.getShort());
            this.assertInRange(-32768L, tv, 32767L);
        }
        catch (NumberFormatException e) {
            this.assertOutsideRange(-32768L, tv, 32767L);
        }
        catch (IllegalArgumentException e) {
            this.assertOutsideRange(-32768L, tv, 32767L);
        }
        NewRegressionLiterals.assertEquals((int)tv, (int)l.getInt());
        NewRegressionLiterals.assertEquals((long)tv, (long)l.getLong());
    }

    protected void testLong(Model m, long tv) {
        Literal l = m.createTypedLiteral(tv);
        try {
            NewRegressionLiterals.assertEquals((long)tv, (long)l.getByte());
            this.assertInRange(-128L, tv, 127L);
        }
        catch (NumberFormatException e) {
            this.assertOutsideRange(-128L, tv, 127L);
        }
        catch (IllegalArgumentException e) {
            this.assertOutsideRange(-128L, tv, 127L);
        }
        try {
            NewRegressionLiterals.assertEquals((long)tv, (long)l.getShort());
            this.assertInRange(-32768L, tv, 32767L);
        }
        catch (NumberFormatException e) {
            this.assertOutsideRange(-32768L, tv, 32767L);
        }
        catch (IllegalArgumentException e) {
            this.assertOutsideRange(-32768L, tv, 32767L);
        }
        try {
            NewRegressionLiterals.assertEquals((long)tv, (long)l.getInt());
            this.assertInRange(Integer.MIN_VALUE, tv, Integer.MAX_VALUE);
        }
        catch (NumberFormatException e) {
            this.assertOutsideRange(Integer.MIN_VALUE, tv, Integer.MAX_VALUE);
        }
        catch (IllegalArgumentException e) {
            this.assertOutsideRange(Integer.MIN_VALUE, tv, Integer.MAX_VALUE);
        }
        NewRegressionLiterals.assertEquals((long)tv, (long)l.getLong());
    }

    protected void assertOutsideRange(long min, long x, long max) {
        if (min <= x && x <= max) {
            NewRegressionLiterals.fail((String)("inside range: " + x + " min: " + min + " max: " + max));
        }
    }

    protected void assertInRange(long min, long x, long max) {
        if (min <= x && x <= max) {
            return;
        }
        NewRegressionLiterals.fail((String)("outside range: " + x + " min: " + min + " max: " + max));
    }

    protected void testFloat(Model m, float tv) {
        NewRegressionLiterals.assertEquals((float)tv, (float)m.createTypedLiteral(tv).getFloat(), (float)5.0E-6f);
    }

    protected void testDouble(Model m, double tv) {
        double delta = 5.0E-9;
        NewRegressionLiterals.assertEquals((double)tv, (double)m.createTypedLiteral(tv).getDouble(), (double)5.0E-9);
    }

    protected void testCharacter(Model m, char tv) {
        NewRegressionLiterals.assertEquals((char)tv, (char)m.createTypedLiteral(tv).getChar());
    }

    protected void testLanguagedString(Model m, String tv, String lang) {
        Literal l = m.createLiteral(tv, lang);
        NewRegressionLiterals.assertEquals((String)tv, (String)l.getString());
        NewRegressionLiterals.assertEquals((String)tv, (String)l.getLexicalForm());
        NewRegressionLiterals.assertEquals((String)lang, (String)l.getLanguage());
    }

    protected void testPlainString(Model m, String tv) {
        Literal l = m.createLiteral(tv);
        NewRegressionLiterals.assertEquals((String)tv, (String)l.getString());
        NewRegressionLiterals.assertEquals((String)tv, (String)l.getLexicalForm());
        NewRegressionLiterals.assertEquals((String)"", (String)l.getLanguage());
    }
}

