/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.test.ReasonerTester;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasoner;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasonerFactory;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestReasoners
extends TestCase {
    public TestReasoners(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestReasoners.class);
    }

    public void testTransitiveReasoner() throws IOException {
        ReasonerTester tester = new ReasonerTester("transitive/manifest.rdf");
        ReasonerFactory rf = TransitiveReasonerFactory.theInstance();
        TestReasoners.assertTrue((String)"transitive reasoner tests", (boolean)tester.runTests(rf, this, null));
    }

    public void testTransitiveRebind() {
        Graph data = Factory.createGraphMem();
        Node C1 = Node.createURI((String)"C1");
        Node C2 = Node.createURI((String)"C2");
        Node C3 = Node.createURI((String)"C3");
        Node C4 = Node.createURI((String)"C4");
        data.add(new Triple(C1, RDFS.subClassOf.asNode(), C2));
        data.add(new Triple(C2, RDFS.subClassOf.asNode(), C3));
        Reasoner reasoner = TransitiveReasonerFactory.theInstance().create(null);
        TestReasoners.assertTrue((boolean)reasoner.supportsProperty(RDFS.subClassOf));
        TestReasoners.assertTrue((!reasoner.supportsProperty(RDFS.domain) ? (byte)1 : 0) != 0);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, infgraph.find(C1, null, null), new Object[]{new Triple(C1, RDFS.subClassOf.asNode(), C1), new Triple(C1, RDFS.subClassOf.asNode(), C2), new Triple(C1, RDFS.subClassOf.asNode(), C3)});
        Graph data2 = Factory.createGraphMem();
        data2.add(new Triple(C1, RDFS.subClassOf.asNode(), C2));
        data2.add(new Triple(C2, RDFS.subClassOf.asNode(), C4));
        infgraph.rebind(data2);
        Node a = Node.createURI((String)"a");
        Node b = Node.createURI((String)"b");
        Node c = Node.createURI((String)"c");
        infgraph.add(new Triple(a, RDFS.subClassOf.asNode(), b));
        infgraph.add(new Triple(b, RDFS.subClassOf.asNode(), c));
        TestUtil.assertIteratorValues(this, infgraph.find(b, RDFS.subClassOf.asNode(), null), new Object[]{new Triple(b, RDFS.subClassOf.asNode(), c), new Triple(b, RDFS.subClassOf.asNode(), b)});
        TestUtil.assertIteratorValues(this, infgraph.find(a, RDFS.subClassOf.asNode(), null), new Object[]{new Triple(a, RDFS.subClassOf.asNode(), a), new Triple(a, RDFS.subClassOf.asNode(), b), new Triple(a, RDFS.subClassOf.asNode(), c)});
        Node p = Node.createURI((String)"p");
        Node q = Node.createURI((String)"q");
        Node r = Node.createURI((String)"r");
        infgraph.add(new Triple(p, RDFS.subPropertyOf.asNode(), q));
        infgraph.add(new Triple(q, RDFS.subPropertyOf.asNode(), r));
        TestUtil.assertIteratorValues(this, infgraph.find(q, RDFS.subPropertyOf.asNode(), null), new Object[]{new Triple(q, RDFS.subPropertyOf.asNode(), q), new Triple(q, RDFS.subPropertyOf.asNode(), r)});
        TestUtil.assertIteratorValues(this, infgraph.find(p, RDFS.subPropertyOf.asNode(), null), new Object[]{new Triple(p, RDFS.subPropertyOf.asNode(), p), new Triple(p, RDFS.subPropertyOf.asNode(), q), new Triple(p, RDFS.subPropertyOf.asNode(), r)});
    }

    public void testTransitiveRemove() {
        Graph data = Factory.createGraphMem();
        Node a = Node.createURI((String)"a");
        Node b = Node.createURI((String)"b");
        Node c = Node.createURI((String)"c");
        Node d = Node.createURI((String)"d");
        Node e = Node.createURI((String)"e");
        Node closedP = RDFS.subClassOf.asNode();
        data.add(new Triple(a, RDFS.subClassOf.asNode(), b));
        data.add(new Triple(a, RDFS.subClassOf.asNode(), c));
        data.add(new Triple(b, RDFS.subClassOf.asNode(), d));
        data.add(new Triple(c, RDFS.subClassOf.asNode(), d));
        data.add(new Triple(d, RDFS.subClassOf.asNode(), e));
        Reasoner reasoner = TransitiveReasonerFactory.theInstance().create(null);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, infgraph.find(a, RDFS.subClassOf.asNode(), null), new Object[]{new Triple(a, closedP, a), new Triple(a, closedP, b), new Triple(a, closedP, b), new Triple(a, closedP, c), new Triple(a, closedP, d), new Triple(a, closedP, e)});
        TestUtil.assertIteratorValues(this, infgraph.find(b, RDFS.subClassOf.asNode(), null), new Object[]{new Triple(b, closedP, b), new Triple(b, closedP, d), new Triple(b, closedP, e)});
        infgraph.delete(new Triple(b, closedP, d));
        TestUtil.assertIteratorValues(this, infgraph.find(a, RDFS.subClassOf.asNode(), null), new Object[]{new Triple(a, closedP, a), new Triple(a, closedP, b), new Triple(a, closedP, b), new Triple(a, closedP, c), new Triple(a, closedP, d), new Triple(a, closedP, e)});
        TestUtil.assertIteratorValues(this, infgraph.find(b, RDFS.subClassOf.asNode(), null), new Object[]{new Triple(b, closedP, b)});
        infgraph.delete(new Triple(a, closedP, c));
        TestUtil.assertIteratorValues(this, infgraph.find(a, RDFS.subClassOf.asNode(), null), new Object[]{new Triple(a, closedP, a), new Triple(a, closedP, b)});
        TestUtil.assertIteratorValues(this, infgraph.find(b, RDFS.subClassOf.asNode(), null), new Object[]{new Triple(b, closedP, b)});
        TestUtil.assertIteratorValues(this, data.find(null, RDFS.subClassOf.asNode(), null), new Object[]{new Triple(a, closedP, b), new Triple(c, closedP, d), new Triple(d, closedP, e)});
    }

    public void testTransitiveMetaLevel() {
        this.doTestMetaLevel(TransitiveReasonerFactory.theInstance());
    }

    public void testRDFSMetaLevel() {
        this.doTestMetaLevel(RDFSRuleReasonerFactory.theInstance());
    }

    public void doTestMetaLevel(ReasonerFactory rf) {
        Graph data = Factory.createGraphMem();
        Node c1 = Node.createURI((String)"C1");
        Node c2 = Node.createURI((String)"C2");
        Node c3 = Node.createURI((String)"C3");
        Node p = Node.createURI((String)"p");
        Node q = Node.createURI((String)"q");
        Node sC = RDFS.subClassOf.asNode();
        Node sP = RDFS.subPropertyOf.asNode();
        Node ty = RDF.type.asNode();
        data.add(new Triple(c2, sC, c3));
        data.add(new Triple(c1, p, c2));
        Reasoner reasoner = rf.create(null);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, infgraph.find(c1, sC, null), new Object[0]);
        infgraph.add(new Triple(p, q, sC));
        TestUtil.assertIteratorValues(this, infgraph.find(c1, sC, null), new Object[0]);
        infgraph.add(new Triple(q, sP, sP));
        TestUtil.assertIteratorValues(this, infgraph.find(c1, sC, null), new Object[]{new Triple(c1, sC, c1), new Triple(c1, sC, c2), new Triple(c1, sC, c3)});
        infgraph.delete(new Triple(p, q, sC));
        TestUtil.assertIteratorValues(this, infgraph.find(c1, sC, null), new Object[0]);
    }

    public void testTransitiveReduction() {
        Model test = FileManager.get().loadModel("testing/reasoners/bugs/subpropertyModel.n3");
        Property dp = test.getProperty(TransitiveReasoner.directSubPropertyOf.getURI());
        this.doTestTransitiveReduction(test, dp);
    }

    public void doTestTransitiveReduction(Model model, Property dp) {
        InfModel im = ModelFactory.createInfModel((Reasoner)ReasonerRegistry.getTransitiveReasoner(), (Model)model);
        ResIterator i = im.listSubjects();
        while (i.hasNext()) {
            Resource base = i.nextResource();
            ArrayList<RDFNode> directLinks = new ArrayList<RDFNode>();
            NodeIterator j = im.listObjectsOfProperty(base, dp);
            while (j.hasNext()) {
                directLinks.add(j.next());
            }
            for (int n = 0; n < directLinks.size(); ++n) {
                Resource d1 = (Resource)directLinks.get(n);
                for (int m = n + 1; m < directLinks.size(); ++m) {
                    Resource d2 = (Resource)directLinks.get(m);
                    if (!im.contains(d1, dp, (RDFNode)d2) || base.equals(d1) || base.equals(d2)) continue;
                    TestReasoners.assertTrue((String)"Triangle discovered in transitive reduction", (boolean)false);
                }
            }
        }
    }

    public void testTransitiveSpecReuse() {
        OntModel om1 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_TRANS_INF);
        Resource c1 = om1.createResource("urn:x-hp:eg/Class1");
        Resource c2 = om1.createResource("urn:x-hp:eg/Class2");
        Resource c3 = om1.createResource("urn:x-hp:eg/Class3");
        om1.add(c1, RDFS.subClassOf, (RDFNode)c2);
        om1.add(c2, RDFS.subClassOf, (RDFNode)c3);
        om1.prepare();
        TestReasoners.assertFalse((boolean)om1.isEmpty());
        OntModel om2 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_TRANS_INF);
        StmtIterator si = om2.listStatements();
        boolean ok = !si.hasNext();
        si.close();
        TestReasoners.assertTrue((String)"Transitive reasoner state leak", (boolean)ok);
    }

    public void testTransitiveBindReuse() {
        Reasoner r = ReasonerRegistry.getTransitiveReasoner();
        InfModel om1 = ModelFactory.createInfModel((Reasoner)r, (Model)ModelFactory.createDefaultModel());
        Resource c1 = om1.createResource("urn:x-hp:eg/Class1");
        Resource c2 = om1.createResource("urn:x-hp:eg/Class2");
        Resource c3 = om1.createResource("urn:x-hp:eg/Class3");
        om1.add(c1, RDFS.subClassOf, (RDFNode)c2);
        om1.add(c2, RDFS.subClassOf, (RDFNode)c3);
        om1.prepare();
        TestReasoners.assertFalse((boolean)om1.isEmpty());
        InfModel om2 = ModelFactory.createInfModel((Reasoner)r, (Model)ModelFactory.createDefaultModel());
        StmtIterator si = om2.listStatements();
        boolean ok = !si.hasNext();
        si.close();
        TestReasoners.assertTrue((String)"Transitive reasoner state leak", (boolean)ok);
    }

    public void testRDFSRebind() {
        Graph data = Factory.createGraphMem();
        Node C1 = Node.createURI((String)"C1");
        Node C2 = Node.createURI((String)"C2");
        Node C3 = Node.createURI((String)"C3");
        Node C4 = Node.createURI((String)"C4");
        data.add(new Triple(C1, RDFS.subClassOf.asNode(), C2));
        data.add(new Triple(C2, RDFS.subClassOf.asNode(), C3));
        Reasoner reasoner = RDFSRuleReasonerFactory.theInstance().create(null);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, infgraph.find(C1, RDFS.subClassOf.asNode(), null), new Object[]{new Triple(C1, RDFS.subClassOf.asNode(), C1), new Triple(C1, RDFS.subClassOf.asNode(), C2), new Triple(C1, RDFS.subClassOf.asNode(), C3)});
        Graph data2 = Factory.createGraphMem();
        data2.add(new Triple(C1, RDFS.subClassOf.asNode(), C2));
        data2.add(new Triple(C2, RDFS.subClassOf.asNode(), C4));
        infgraph.rebind(data2);
        TestUtil.assertIteratorValues(this, infgraph.find(C1, RDFS.subClassOf.asNode(), null), new Object[]{new Triple(C1, RDFS.subClassOf.asNode(), C1), new Triple(C1, RDFS.subClassOf.asNode(), C2), new Triple(C1, RDFS.subClassOf.asNode(), C4)});
    }

    public void testRDFSRemove() {
        InfModel m = ModelFactory.createRDFSModel((Model)ModelFactory.createDefaultModel());
        String NS = "urn:x-hp:eg/";
        Property p = m.createProperty(NS, "p");
        Resource D = m.createResource(NS + "D");
        Resource i = m.createResource(NS + "i");
        Resource c = m.createResource(NS + "c");
        Resource d = m.createResource(NS + "d");
        p.addProperty(RDFS.domain, (RDFNode)D);
        i.addProperty(p, (RDFNode)c);
        i.addProperty(p, (RDFNode)d);
        TestUtil.assertIteratorValues(this, i.listProperties(), new Object[]{m.createStatement(i, p, (RDFNode)c), m.createStatement(i, p, (RDFNode)d), m.createStatement(i, RDF.type, (RDFNode)D), m.createStatement(i, RDF.type, (RDFNode)RDFS.Resource)});
        i.removeAll(p);
        TestUtil.assertIteratorValues(this, i.listProperties(), new Object[0]);
    }

    public void testTransitiveCycleBug() {
        Model m = FileManager.get().loadModel("file:testing/reasoners/bugs/unbroken.n3");
        OntModel om = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.RDFS_MEM_TRANS_INF, (Model)m);
        OntClass rootClass = om.getOntClass(RDFS.Resource.getURI());
        Resource c = m.getResource("c");
        Set direct = rootClass.listSubClasses(true).toSet();
        TestReasoners.assertFalse((boolean)direct.contains(c));
    }

    public void testModelFactoryRDFS() {
        Model data = ModelFactory.createDefaultModel();
        Property p = data.createProperty("urn:x-hp:ex/p");
        Resource a = data.createResource("urn:x-hp:ex/a");
        Resource b = data.createResource("urn:x-hp:ex/b");
        Resource C = data.createResource("urn:x-hp:ex/c");
        data.add((Resource)p, RDFS.range, (RDFNode)C).add(a, p, (RDFNode)b);
        InfModel result = ModelFactory.createRDFSModel((Model)data);
        StmtIterator i = result.listStatements(b, RDF.type, (RDFNode)null);
        TestUtil.assertIteratorValues(this, i, new Object[]{data.createStatement(b, RDF.type, (RDFNode)RDFS.Resource), data.createStatement(b, RDF.type, (RDFNode)C)});
    }

    public void testTransitiveFindWithPremises() {
        this.doTestFindWithPremises(TransitiveReasonerFactory.theInstance());
    }

    public void testRDFSFindWithPremises() {
        this.doTestFindWithPremises(RDFSRuleReasonerFactory.theInstance());
    }

    public void doTestFindWithPremises(ReasonerFactory rf) {
        Node c1 = Node.createURI((String)"C1");
        Node c2 = Node.createURI((String)"C2");
        Node c3 = Node.createURI((String)"C3");
        Node sC = RDFS.subClassOf.asNode();
        Graph data = Factory.createGraphMem();
        data.add(new Triple(c2, sC, c3));
        Graph premise = Factory.createGraphMem();
        premise.add(new Triple(c1, sC, c2));
        Reasoner reasoner = rf.create(null);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, infgraph.find(c1, sC, null), new Object[0]);
        TestUtil.assertIteratorValues(this, infgraph.find(c1, sC, null, premise), new Object[]{new Triple(c1, sC, c2), new Triple(c1, sC, c3), new Triple(c1, sC, c1)});
        TestUtil.assertIteratorValues(this, infgraph.find(c1, sC, null), new Object[0]);
    }

    public void testDuplicateStatements() {
        String NS = "http://swt/test#";
        OntModelSpec s = new OntModelSpec(ModelFactory.createMemModelMaker(), null, null, "http://www.daml.org/2001/03/daml+oil#");
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM_RULE_INF, null);
        OntClass documentC = model.createClass(NS + "DOCUMENT");
        OntClass topicC = model.createClass(NS + "TOPIC");
        ObjectProperty hasTopicP = model.createObjectProperty(NS + "hasTopic");
        hasTopicP.addDomain((Resource)documentC);
        hasTopicP.addRange((Resource)topicC);
        ObjectProperty hasDocP = model.createObjectProperty(NS + "hasDocument");
        hasDocP.addDomain((Resource)topicC);
        hasDocP.addRange((Resource)documentC);
        hasDocP.setInverseOf((Property)hasTopicP);
        Individual fooTopic = model.createIndividual(NS + "fooTopic", (Resource)topicC);
        Individual fooDoc = model.createIndividual(NS + "fooDoc", (Resource)documentC);
        fooDoc.addProperty((Property)hasTopicP, (RDFNode)fooTopic);
        TestUtil.assertIteratorLength(fooDoc.listProperties((Property)hasTopicP), 1);
    }
}

