/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestOWLMisc
extends TestCase {
    public static final String NS = "http://jena.hpl.hp.com/example#";

    public TestOWLMisc(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestOWLMisc.class);
    }

    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
    }

    public void testSameAsDifferentFrom() {
        this.doTestSameAsDifferentFrom(OntModelSpec.OWL_MEM_MINI_RULE_INF);
        this.doTestSameAsDifferentFrom(OntModelSpec.OWL_MEM_RULE_INF);
    }

    public void doTestSameAsDifferentFrom(OntModelSpec os) {
        String test = "[ a owl:AllDifferent ; owl:distinctMembers ( :limited1 :limited2 :limited3 ) ] .\n:limited4 owl:sameAs :limited1 .";
        OntModel inf = ModelFactory.createOntologyModel((OntModelSpec)os, (Model)TestOWLMisc.modelFromN3(test));
        Resource l4 = inf.getResource("http://jena.hpl.hp.com/example#limited4");
        Resource l2 = inf.getResource("http://jena.hpl.hp.com/example#limited2");
        Resource l3 = inf.getResource("http://jena.hpl.hp.com/example#limited3");
        TestOWLMisc.assertTrue((boolean)inf.contains(l4, OWL.differentFrom, (RDFNode)l2));
        TestOWLMisc.assertTrue((boolean)inf.contains(l4, OWL.differentFrom, (RDFNode)l3));
    }

    public void testDatatypeRangeValidation() throws IOException {
        String uri = "http://www.daml.org/2001/03/daml+oil-ex-dt";
        String filename = "testing/xsd/daml+oil-ex-dt.xsd";
        TypeMapper tm = TypeMapper.getInstance();
        XSDDatatype.loadUserDefined((String)uri, (Reader)new FileReader(filename), null, (TypeMapper)tm);
        RDFDatatype over12Type = tm.getSafeTypeByName(uri + "#over12");
        this.doTestDatatypeRangeValidation(over12Type, OntModelSpec.OWL_MEM_MICRO_RULE_INF);
        this.doTestDatatypeRangeValidation(over12Type, OntModelSpec.OWL_MEM_MINI_RULE_INF);
        this.doTestDatatypeRangeValidation(over12Type, OntModelSpec.OWL_MEM_RULE_INF);
    }

    private void doTestDatatypeRangeValidation(RDFDatatype over12Type, OntModelSpec spec) {
        String NS = NS;
        OntModel ont = ModelFactory.createOntologyModel((OntModelSpec)spec);
        Resource over12 = ont.createResource(over12Type.getURI());
        DatatypeProperty hasValue = ont.createDatatypeProperty(NS + "hasValue");
        hasValue.addRange(over12);
        ont.createResource(NS + "a").addProperty((Property)hasValue, "15", over12Type);
        ont.createResource(NS + "b").addProperty((Property)hasValue, "16", (RDFDatatype)XSDDatatype.XSDinteger);
        ont.createResource(NS + "c").addProperty((Property)hasValue, "10", (RDFDatatype)XSDDatatype.XSDinteger);
        ValidityReport validity = ont.validate();
        TestOWLMisc.assertTrue((!validity.isValid() ? (byte)1 : 0) != 0);
        ValidityReport.Report report = (ValidityReport.Report)validity.getReports().next();
        Triple culprit = (Triple)report.getExtension();
        TestOWLMisc.assertEquals((String)culprit.getSubject().getURI(), (String)(NS + "c"));
        TestOWLMisc.assertEquals((Object)culprit.getPredicate(), (Object)hasValue.asNode());
    }

    public void testOWLPropertyAxioms() {
        Model data = ModelFactory.createDefaultModel();
        Resource fp = data.createResource("urn:x-hp:eg/fp");
        Resource ifp = data.createResource("urn:x-hp:eg/ifp");
        Resource tp = data.createResource("urn:x-hp:eg/tp");
        Resource sp = data.createResource("urn:x-hp:eg/sp");
        data.add(fp, RDF.type, (RDFNode)OWL.FunctionalProperty);
        data.add(ifp, RDF.type, (RDFNode)OWL.InverseFunctionalProperty);
        data.add(tp, RDF.type, (RDFNode)OWL.TransitiveProperty);
        data.add(sp, RDF.type, (RDFNode)OWL.SymmetricProperty);
        InfModel infmodel = ModelFactory.createInfModel((Reasoner)ReasonerRegistry.getOWLReasoner(), (Model)data);
        TestOWLMisc.assertTrue((String)"property class axioms", (boolean)infmodel.contains(fp, RDF.type, (RDFNode)RDF.Property));
        TestOWLMisc.assertTrue((String)"property class axioms", (boolean)infmodel.contains(ifp, RDF.type, (RDFNode)RDF.Property));
        TestOWLMisc.assertTrue((String)"property class axioms", (boolean)infmodel.contains(tp, RDF.type, (RDFNode)RDF.Property));
        TestOWLMisc.assertTrue((String)"property class axioms", (boolean)infmodel.contains(sp, RDF.type, (RDFNode)RDF.Property));
        TestOWLMisc.assertTrue((String)"property class axioms", (boolean)infmodel.contains(ifp, RDF.type, (RDFNode)OWL.ObjectProperty));
        TestOWLMisc.assertTrue((String)"property class axioms", (boolean)infmodel.contains(tp, RDF.type, (RDFNode)OWL.ObjectProperty));
        TestOWLMisc.assertTrue((String)"property class axioms", (boolean)infmodel.contains(sp, RDF.type, (RDFNode)OWL.ObjectProperty));
    }

    public void testEquivalentClass1() {
        Model base = ModelFactory.createDefaultModel();
        base.read("file:testing/reasoners/bugs/equivalentClassTest.owl");
        InfModel test = ModelFactory.createInfModel((Reasoner)ReasonerRegistry.getOWLReasoner(), (Model)base);
        String NAMESPACE = "urn:foo#";
        Resource A = test.getResource(NAMESPACE + "A");
        Resource B = test.getResource(NAMESPACE + "B");
        TestOWLMisc.assertTrue((String)"hasValue equiv deduction", (boolean)test.contains(A, OWL.equivalentClass, (RDFNode)B));
    }

    public void hiddenTestOWLLoop() {
        Model data = FileManager.get().loadModel("file:testing/reasoners/bugs/loop.owl");
        InfModel infmodel = ModelFactory.createInfModel((Reasoner)ReasonerRegistry.getOWLReasoner(), (Model)data);
        ((FBRuleInfGraph)infmodel.getGraph()).setTraceOn(true);
        String baseURI = "http://jena.hpl.hp.com/eg#";
        Resource C = infmodel.getResource(baseURI + "C");
        Resource I = infmodel.getResource(baseURI + "i");
        Property R = infmodel.getProperty(baseURI, "R");
        System.out.println("Check that the instance does have an R property");
        Statement s = I.getProperty(R);
        System.out.println(" - " + s);
        System.out.println("And that the type of the R property is C");
        Statement s2 = ((Resource)s.getObject()).getProperty(RDF.type);
        System.out.println(" - " + s2);
        System.out.println("But does that have an R property?");
        Statement s3 = ((Resource)s.getObject()).getProperty(R);
        System.out.println(" - " + s3);
        System.out.println("List all instances of C");
        int count = 0;
        StmtIterator i = infmodel.listStatements(null, RDF.type, (RDFNode)C);
        while (i.hasNext()) {
            Statement st = (Statement)i.next();
            System.out.println(" - " + st);
            ++count;
        }
        System.out.println("OK");
    }

    public void testRangeBug() {
        String baseuri;
        Resource surname;
        Statement s;
        Model model = FileManager.get().loadModel("file:testing/reasoners/bugs/rangeBug.owl");
        Reasoner r = ReasonerRegistry.getOWLReasoner();
        InfModel omodel = ModelFactory.createInfModel((Reasoner)r, (Model)model);
        TestOWLMisc.assertTrue((!omodel.contains(s = omodel.createStatement(surname = omodel.getResource((baseuri = "http://decsai.ugr.es/~ontoserver/bacarex2.owl#") + "surname"), RDFS.range, (RDFNode)OWL.Nothing)) ? (byte)1 : 0) != 0);
    }

    public void testLiteralBug() {
        Model model = FileManager.get().loadModel("file:testing/reasoners/bugs/dtValidation.owl");
        Reasoner r = ReasonerRegistry.getOWLReasoner();
        InfModel infmodel = ModelFactory.createInfModel((Reasoner)r, (Model)model);
        ValidityReport validity = infmodel.validate();
        TestOWLMisc.assertTrue((boolean)validity.isValid());
    }

    public void testCardinality1() {
        Model base = ModelFactory.createDefaultModel();
        base.read("file:testing/reasoners/bugs/cardFPTest.owl");
        InfModel test = ModelFactory.createInfModel((Reasoner)ReasonerRegistry.getOWLReasoner(), (Model)base);
        String NAMESPACE = "urn:foo#";
        Resource aDocument = test.getResource(NAMESPACE + "aDocument");
        Resource documentType = test.getResource(NAMESPACE + "Document");
        TestOWLMisc.assertTrue((String)"Cardinality-based classification", (boolean)test.contains(aDocument, RDF.type, (RDFNode)documentType));
    }

    public static Model modelFromN3(String src) {
        String fullSource = "@prefix owl: <http://www.w3.org/2002/07/owl#> .\n@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .\n@prefix owl:  <http://www.w3.org/2002/07/owl#> .\n@prefix xsd:  <http://www.w3.org/2001/XMLSchema#> .\n@prefix eg: <http://jena.hpl.hp.com/example#>.\n@prefix : <http://jena.hpl.hp.com/example#> .\n" + src + "\n";
        Model result = ModelFactory.createDefaultModel();
        result.read((Reader)new StringReader(fullSource), "", "N3");
        return result;
    }
}

