/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.graph.impl.LiteralLabelFactory;
import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.rdf.listeners.StatementListener;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.Builtin;
import com.hp.hpl.jena.reasoner.rulesys.BuiltinRegistry;
import com.hp.hpl.jena.reasoner.rulesys.DAMLMicroReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.PrintUtil;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestBugs
extends TestCase {
    public static final String INPUT_SUBCLASS = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><rdf:RDF    xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"    xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\"    xmlns:daml=\"http://www.daml.org/2001/03/daml+oil#\"    xmlns:ex=\"http://localhost:8080/axis/daml/a.daml#\"    xml:base=\"http://localhost:8080/axis/daml/a.daml\">     <daml:Ontology rdf:about=\"\">        <daml:imports rdf:resource=\"http://www.daml.org/2001/03/daml+oil\"/>    </daml:Ontology>     <daml:Class rdf:ID=\"cls1\"/>    <daml:Class rdf:ID=\"cls2\">        <daml:subClassOf rdf:resource=\"#cls1\"/>    </daml:Class>    <ex:cls2 rdf:ID=\"test\"/></rdf:RDF>";
    public static final String INPUT_SUBPROPERTY = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><rdf:RDF    xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"    xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\"    xmlns:daml=\"http://www.daml.org/2001/03/daml+oil#\"    xmlns=\"urn:x-hp-jena:test#\"    xml:base=\"urn:x-hp-jena:test\">     <daml:Ontology rdf:about=\"\">        <daml:imports rdf:resource=\"http://www.daml.org/2001/03/daml+oil\"/>    </daml:Ontology>     <daml:Class rdf:ID=\"A\"/>    <daml:ObjectProperty rdf:ID=\"p\" />    <daml:ObjectProperty rdf:ID=\"q\">        <daml:subPropertyOf rdf:resource=\"#p\"/>    </daml:ObjectProperty>    <A rdf:ID=\"a0\"/>    <A rdf:ID=\"a1\">       <q rdf:resource=\"#a0\" />    </A></rdf:RDF>";

    public TestBugs(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestBugs.class);
    }

    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
    }

    public void testIntersectionNPE() {
        Model base = ModelFactory.createDefaultModel();
        base.read("file:testing/reasoners/bugs/bad-intersection.owl");
        boolean foundBadList = false;
        try {
            InfGraph infgraph = ReasonerRegistry.getOWLReasoner().bind(base.getGraph());
            ExtendedIterator ci = infgraph.find(null, RDF.Nodes.type, OWL.Class.asNode());
            ci.close();
        }
        catch (ReasonerException e) {
            foundBadList = true;
        }
        TestBugs.assertTrue((String)"Correctly detected the illegal list", (boolean)foundBadList);
    }

    public void testFunctorCCE() {
        Model base = ModelFactory.createDefaultModel();
        base.read("file:testing/reasoners/bugs/cceTest.owl");
        InfModel test = ModelFactory.createInfModel((Reasoner)ReasonerRegistry.getOWLReasoner(), (Model)base);
        this.anyInstancesOfNothing((Model)test);
        ResIterator rIter = test.listSubjects();
        while (rIter.hasNext()) {
            rIter.nextResource();
        }
    }

    private boolean anyInstancesOfNothing(Model model) {
        boolean hasAny = false;
        try {
            StmtIterator it = model.listStatements(null, RDF.type, (RDFNode)OWL.Nothing);
            hasAny = it.hasNext();
            it.close();
        }
        catch (ConversionException x) {
            hasAny = false;
        }
        return hasAny;
    }

    public void testSubClass() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.DAML_MEM_RDFS_INF, null);
        model.getDocumentManager().setMetadataSearchPath("file:etc/ont-policy-test.rdf", true);
        String base = "http://localhost:8080/axis/daml/a.daml#";
        model.read((InputStream)new ByteArrayInputStream(INPUT_SUBCLASS.getBytes()), base);
        OntResource res = (OntResource)model.getResource(base + "test").as(OntResource.class);
        OntClass cls1 = (OntClass)model.getResource(base + "cls1").as(OntClass.class);
        OntClass cls2 = (OntClass)model.getResource(base + "cls2").as(OntClass.class);
        TestBugs.assertTrue((String)"cls2 should be a super-class of cls1", (boolean)cls2.hasSuperClass((Resource)cls1));
        TestBugs.assertTrue((String)"res should have rdf:type cls1", (boolean)res.hasRDFType((Resource)cls1));
        TestBugs.assertTrue((String)"res should have rdf:type cls2", (boolean)res.hasRDFType((Resource)cls2));
    }

    public void testSubProperty() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.DAML_MEM_RDFS_INF, null);
        model.getDocumentManager().setMetadataSearchPath("file:etc/ont-policy-test.rdf", true);
        String base = "urn:x-hp-jena:test#";
        model.read((InputStream)new ByteArrayInputStream(INPUT_SUBPROPERTY.getBytes()), base);
        OntResource a0 = (OntResource)model.getResource(base + "a0").as(OntResource.class);
        OntResource a1 = (OntResource)model.getResource(base + "a1").as(OntResource.class);
        ObjectProperty p = model.getObjectProperty(base + "p");
        ObjectProperty q = model.getObjectProperty(base + "q");
        TestBugs.assertTrue((String)"subProp relation present", (boolean)q.hasProperty(RDFS.subPropertyOf, (RDFNode)p));
        TestBugs.assertTrue((String)"a1 q a0", (boolean)a1.hasProperty((Property)q, (RDFNode)a0));
        TestBugs.assertTrue((String)"a1 p a0", (boolean)a1.hasProperty((Property)p, (RDFNode)a0));
    }

    public void testDeleteBug() {
        Model modelo = ModelFactory.createDefaultModel();
        modelo.read("file:testing/reasoners/bugs/deleteBug.owl");
        OntModel modeloOnt = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_RULE_INF, (Model)modelo);
        Individual indi = modeloOnt.getIndividual("http://decsai.ugr.es/~ontoserver/bacarex2.owl#JS");
        indi.remove();
        StmtIterator it = modeloOnt.listStatements((Resource)indi, null, (RDFNode)null);
        boolean ok = !it.hasNext();
        it.close();
        TestBugs.assertTrue((boolean)ok);
    }

    public void testDeteleBug2() {
        Model m = ModelFactory.createDefaultModel();
        String NS = "urn:x-hp:eg/";
        Resource r = m.createResource(NS + "r");
        Resource A = m.createResource(NS + "A");
        Resource B = m.createResource(NS + "B");
        Statement s = m.createStatement(r, RDF.type, (RDFNode)A);
        m.add(s);
        String rules = "(?r rdf:type eg:A) -> (?r rdf:type eg:B).";
        GenericRuleReasoner grr = new GenericRuleReasoner(Rule.parseRules((String)rules));
        InfModel im = ModelFactory.createInfModel((Reasoner)grr, (Model)m);
        TestBugs.assertTrue((boolean)im.contains(r, RDF.type, (RDFNode)B));
        TestBugs.assertTrue((boolean)im.getDeductionsModel().contains(r, RDF.type, (RDFNode)B));
        im.remove(s);
        TestBugs.assertFalse((boolean)im.contains(r, RDF.type, (RDFNode)B));
        TestBugs.assertFalse((boolean)im.getDeductionsModel().contains(r, RDF.type, (RDFNode)B));
    }

    public void testHide() {
        String NS = "http://jena.hpl.hp.com/bugs#";
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_RULE_INF, null);
        OntClass c = m.createClass(NS + "C");
        Individual i = m.createIndividual((Resource)c);
        StmtIterator res = m.listStatements(null, RDF.type, (RDFNode)c);
        TestUtil.assertIteratorValues(this, res, new Statement[]{m.createStatement((Resource)i, RDF.type, (RDFNode)c)});
    }

    public void testHideXSDRange() {
        OntModelSpec[] specs = new OntModelSpec[]{OntModelSpec.OWL_MEM_RULE_INF, OntModelSpec.OWL_MEM_RDFS_INF, OntModelSpec.OWL_MEM_MINI_RULE_INF, OntModelSpec.OWL_MEM_MICRO_RULE_INF};
        for (int os = 0; os < specs.length; ++os) {
            OntModelSpec spec = specs[os];
            OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
            ExtendedIterator i = m.listOntProperties();
            while (i.hasNext()) {
                Resource r = (Resource)i.next();
                if (r.getURI() == null || !r.getURI().startsWith("urn:x-hp-jena:rubrik/")) continue;
                TestBugs.assertTrue((String)("Rubrik internal property leaked out: " + r + "(" + os + ")"), (boolean)false);
            }
        }
    }

    public void testBindSchemaValidate() {
        Reasoner reasoner = ReasonerRegistry.getOWLReasoner();
        Model schema = FileManager.get().loadModel("file:testing/reasoners/bugs/sbug.owl");
        Model data = FileManager.get().loadModel("file:testing/reasoners/bugs/sbug.rdf");
        InfModel infu = ModelFactory.createInfModel((Reasoner)reasoner, (Model)data.union(schema));
        ValidityReport validity = infu.validate();
        TestBugs.assertTrue((!validity.isValid() ? (byte)1 : 0) != 0);
        InfModel inf = ModelFactory.createInfModel((Reasoner)reasoner.bindSchema(schema), (Model)data);
        validity = inf.validate();
        TestBugs.assertTrue((!validity.isValid() ? (byte)1 : 0) != 0);
    }

    public void testGenericDeleteBug() {
        Model data = ModelFactory.createDefaultModel();
        String NS = "urn:x-hp:eg/";
        Property p = data.createProperty(NS, "p");
        Resource x = data.createResource(NS + "x");
        Resource y = data.createResource(NS + "y");
        Statement sy = data.createStatement(y, p, "foo");
        data.add(sy);
        data.add(x, p, "foo");
        String rule = "[(?x eg:p ?m) (?y eg:p ?m) -> (?x eg:same ?y) (?y eg:same ?x)]";
        GenericRuleReasoner reasoner = (GenericRuleReasoner)GenericRuleReasonerFactory.theInstance().create(null);
        reasoner.setMode(GenericRuleReasoner.FORWARD_RETE);
        reasoner.setRules(Rule.parseRules((String)rule));
        InfModel inf = ModelFactory.createInfModel((Reasoner)reasoner, (Model)data);
        TestUtil.assertIteratorLength(inf.listStatements(y, null, (RDFNode)null), 3);
        inf.remove(sy);
        TestUtil.assertIteratorLength(inf.listStatements(y, null, (RDFNode)null), 0);
    }

    public void testRETEInc() {
        String rule = "(?x ?p ?y) -> (?p rdf:type rdf:Property) .";
        GenericRuleReasoner r = new GenericRuleReasoner(Rule.parseRules((String)rule));
        InfModel m = ModelFactory.createInfModel((Reasoner)r, (Model)ModelFactory.createDefaultModel());
        Resource source = m.createResource("urn:alfie:testResource");
        Property prop = m.createProperty("urn:alfie:testProperty");
        Statement s1 = m.createStatement(source, prop, "value1");
        Statement s2 = m.createStatement(source, prop, "value2");
        m.add(s1);
        this.assertIsProperty((Model)m, prop);
        m.add(s2);
        m.remove(s1);
        this.assertIsProperty((Model)m, prop);
    }

    public void testRETEDec() {
        String rule = "(?x ?p ?y) -> (?p rdf:type rdf:Property) .";
        GenericRuleReasoner r = new GenericRuleReasoner(Rule.parseRules((String)rule));
        InfModel m = ModelFactory.createInfModel((Reasoner)r, (Model)ModelFactory.createDefaultModel());
        Resource source = m.createResource("urn:alfie:testResource");
        Property prop = m.createProperty("urn:alfie:testProperty");
        Statement s1 = m.createStatement(source, prop, "value1");
        m.createStatement(source, prop, "value2");
        m.add((Resource)prop, RDF.type, (RDFNode)RDF.Property);
        m.add(s1);
        m.prepare();
        m.remove(s1);
        this.assertIsProperty((Model)m, prop);
    }

    private void assertIsProperty(Model m, Property prop) {
        TestBugs.assertTrue((boolean)m.contains((Resource)prop, RDF.type, (RDFNode)RDF.Property));
    }

    public void testHideOnOWLThing() {
        Reasoner r = ReasonerRegistry.getOWLReasoner();
        Model data = ModelFactory.createDefaultModel();
        InfModel inf = ModelFactory.createInfModel((Reasoner)r, (Model)data);
        StmtIterator things = inf.listStatements(null, RDF.type, (RDFNode)OWL.Thing);
        TestUtil.assertIteratorLength(things, 0);
    }

    public void testSomeDatatype() throws IOException {
        String uri = "http://www.daml.org/2001/03/daml+oil-ex-dt";
        String filename = "testing/xsd/daml+oil-ex-dt.xsd";
        TypeMapper tm = TypeMapper.getInstance();
        XSDDatatype.loadUserDefined((String)uri, (Reader)new FileReader(filename), null, (TypeMapper)tm);
        Model data = ModelFactory.createDefaultModel();
        data.read("file:testing/reasoners/bugs/userDatatypes.owl");
        InfModel inf = ModelFactory.createInfModel((Reasoner)ReasonerRegistry.getOWLReasoner(), (Model)data);
        String egNS = "http://jena.hpl.hp.com/eg#";
        Resource meR = inf.getResource(egNS + "me");
        Resource TestR = inf.getResource(egNS + "Test");
        TestBugs.assertTrue((String)"somevalues inf for datatypes", (boolean)inf.contains(meR, RDF.type, (RDFNode)TestR));
        Resource Test2R = inf.getResource(egNS + "Test2");
        Resource me2R = inf.getResource(egNS + "me2");
        TestBugs.assertTrue((String)"somevalues inf for datatypes", (boolean)inf.contains(me2R, RDF.type, (RDFNode)Test2R));
        TestBugs.assertTrue((String)"somevalues inf for user datatypes", (boolean)inf.contains(meR, RDF.type, (RDFNode)Test2R));
    }

    public void testDAMLMicroReasonerSupports() {
        Reasoner r = DAMLMicroReasonerFactory.theInstance().create(null);
        TestBugs.assertTrue((String)"Should support daml:subClassOf", (boolean)r.supportsProperty(DAML_OIL.subClassOf));
        TestBugs.assertTrue((String)"Should support daml:subPropertyOf", (boolean)r.supportsProperty(DAML_OIL.subPropertyOf));
        TestBugs.assertTrue((String)"Should support daml:domain", (boolean)r.supportsProperty(DAML_OIL.domain));
        TestBugs.assertTrue((String)"Should support daml:range", (boolean)r.supportsProperty(DAML_OIL.range));
    }

    public static Model modelFromN3(String src) {
        String fullSource = "@prefix owl: <http://www.w3.org/2002/07/owl#> .\n@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .\n@prefix eg: <http://jena.hpl.hp.com/eg#> .\n@prefix : <#> .\n" + src + "\n";
        Model result = ModelFactory.createDefaultModel();
        result.read((Reader)new StringReader(fullSource), "", "N3");
        return result;
    }

    public void test_oh_01() {
        String NS = "http://www.idi.ntnu.no/~herje/ja/";
        Resource[] expected = new Resource[]{ResourceFactory.createResource((String)(NS + "reiseliv.owl#Reiseliv")), ResourceFactory.createResource((String)(NS + "hotell.owl#Hotell")), ResourceFactory.createResource((String)(NS + "restaurant.owl#Restaurant")), ResourceFactory.createResource((String)(NS + "restaurant.owl#UteRestaurant")), ResourceFactory.createResource((String)(NS + "restaurant.owl#UteBadRestaurant")), ResourceFactory.createResource((String)(NS + "restaurant.owl#UteDoRestaurant")), ResourceFactory.createResource((String)(NS + "restaurant.owl#SkogRestaurant"))};
        this.test_oh_01scan(OntModelSpec.OWL_MEM, "No inf", expected);
        this.test_oh_01scan(OntModelSpec.OWL_MEM_MINI_RULE_INF, "Mini rule inf", expected);
        this.test_oh_01scan(OntModelSpec.OWL_MEM_MICRO_RULE_INF, "Micro rule inf", expected);
        this.test_oh_01scan(OntModelSpec.OWL_MEM_RULE_INF, "Full rule inf", expected);
    }

    public void test_der_validation() {
        Model abox = FileManager.get().loadModel("file:testing/reasoners/owl/nondetbug.rdf");
        List rules = FBRuleReasoner.loadRules((String)"testing/reasoners/owl/nondetbug.rules");
        GenericRuleReasoner r = new GenericRuleReasoner(rules);
        for (int i = 0; i < 10; ++i) {
            InfModel im = ModelFactory.createInfModel((Reasoner)r, (Model)abox);
            TestBugs.assertTrue((String)("failed on count " + i), (boolean)im.contains(null, ReasonerVocabulary.RB_VALIDATION_REPORT, (RDFNode)null));
        }
    }

    private void test_oh_01scan(OntModelSpec s, String prompt, Resource[] expected) {
        String NS = "http://www.idi.ntnu.no/~herje/ja/reiseliv.owl#";
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)s, null);
        m.read("file:testing/ontology/bugs/test_oh_01.owl");
        OntClass r = m.getOntClass(NS + "Reiseliv");
        ArrayList<OntClass> q = new ArrayList<OntClass>();
        HashSet<OntClass> seen = new HashSet<OntClass>();
        q.add(r);
        while (!q.isEmpty()) {
            OntClass c = (OntClass)q.remove(0);
            seen.add(c);
            ExtendedIterator i = c.listSubClasses(true);
            while (i.hasNext()) {
                OntClass ontClass = (OntClass)i.next();
                if (seen.contains(ontClass)) continue;
                q.add(ontClass);
            }
        }
        int mask = (1 << expected.length) - 1;
        for (int j = 0; j < expected.length; ++j) {
            if (!seen.contains(expected[j])) continue;
            mask &= ~(1 << j);
        }
        for (Resource resource : seen) {
            boolean isExpected = false;
            for (int j = 0; !isExpected && j < expected.length; ++j) {
                isExpected = expected[j].equals(resource);
            }
            if (isExpected) continue;
        }
        TestBugs.assertEquals((String)"Some expected results were not seen", (int)0, (int)mask);
    }

    public void test_domainInf() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_RULE_INF, null);
        String NS = "http://m3t4.com/ont/#";
        OntClass c1 = m.createClass(NS + "c1");
        OntClass c2 = m.createClass(NS + "c2");
        OntClass c3 = m.createClass(NS + "c3");
        ObjectProperty p1 = m.createObjectProperty(NS + "p1");
        UnionClass uc = m.createUnionClass(null, null);
        uc.addOperand((Resource)c1);
        TestBugs.assertEquals((String)"Size should be 1", (int)1, (int)uc.getOperands().size());
        TestBugs.assertTrue((String)"uc should have c1 as union member", (boolean)uc.getOperands().contains((RDFNode)c1));
        uc.addOperand((Resource)c2);
        TestBugs.assertEquals((String)"Size should be 2", (int)2, (int)uc.getOperands().size());
        TestUtil.assertIteratorValues(this, uc.listOperands(), new Object[]{c1, c2});
        uc.addOperand((Resource)c3);
        TestBugs.assertEquals((String)"Size should be 3", (int)3, (int)uc.getOperands().size());
        TestUtil.assertIteratorValues(this, uc.listOperands(), new Object[]{c1, c2, c3});
        p1.addDomain((Resource)uc);
    }

    public void testNonmonotonicCR() {
        String ruleSrc = "(eg:IndA eg:scoreA ?score), sum(?score 40 ?total), noValue(eg:IndA eg:flag_1 'true') -> drop(0), (eg:IndA eg:scoreA ?total), (eg:IndA eg:flag_1 'true').(eg:IndA eg:scoreA ?score), sum(?score 33 ?total), noValue(eg:IndA eg:flag_2 'true') -> drop(0), (eg:IndA eg:scoreA ?total), (eg:IndA eg:flag_2 'true').";
        List rules = Rule.parseRules((String)ruleSrc);
        Model data = ModelFactory.createDefaultModel();
        String NS = "urn:x-hp:eg/";
        Resource i = data.createResource(NS + "IndA");
        Property scoreA = data.createProperty(NS, "scoreA");
        i.addProperty(scoreA, (RDFNode)data.createTypedLiteral(100));
        GenericRuleReasoner reasoner = new GenericRuleReasoner(rules);
        InfModel inf = ModelFactory.createInfModel((Reasoner)reasoner, (Model)data);
        NodeIterator values = inf.listObjectsOfProperty(i, scoreA);
        TestUtil.assertIteratorValues(this, values, new Object[]{data.createTypedLiteral(173)});
    }

    public void testIncrementalIU() {
        OntModel ontmodel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_MINI_RULE_INF);
        String homeuri = "http://abc/bcd/";
        Object[] ind = new Individual[6];
        OntClass classb = ontmodel.createClass(homeuri + "C");
        for (int i = 0; i < 6; ++i) {
            ind[i] = classb.createIndividual(homeuri + String.valueOf(i));
        }
        Object[] subind = new Individual[]{ind[0], ind[1], ind[2]};
        EnumeratedClass class1 = ontmodel.createEnumeratedClass(homeuri + "C1", ontmodel.createList((RDFNode[])subind));
        EnumeratedClass class2 = ontmodel.createEnumeratedClass(homeuri + "C2", ontmodel.createList((RDFNode[])ind));
        RDFList list = ontmodel.createList(new RDFNode[]{class1, class2});
        IntersectionClass classI = ontmodel.createIntersectionClass(null, list);
        UnionClass classU = ontmodel.createUnionClass(null, list);
        TestUtil.assertIteratorValues(this, classI.listInstances(), subind);
        TestUtil.assertIteratorValues(this, classU.listInstances(), ind);
    }

    public void testFactRules() {
        Model facts = ModelFactory.createDefaultModel();
        String NS = "urn:x-hp:eg/";
        Property p = facts.createProperty(NS + "p");
        List rules = Rule.parseRules((String)"makeTemp(?x) -> (?x, eg:p, eg:z). makeTemp(?x) makeTemp(?y) -> (?x, eg:p, ?y) . (?x, eg:p, eg:z) -> (?a, eg:p, eg:b). -> [ (eg:a eg:p eg:y) <- ].");
        GenericRuleReasoner reasoner = new GenericRuleReasoner(rules);
        InfModel inf = ModelFactory.createInfModel((Reasoner)reasoner, (Model)facts);
        inf.prepare();
        TestUtil.assertIteratorLength(inf.listStatements(null, p, (RDFNode)null), 4);
    }

    public void testFactChainRules() {
        Model facts = ModelFactory.createDefaultModel();
        String NS = "urn:x-hp:eg/";
        Property mother = facts.createProperty(NS + "mother");
        Property female = facts.createProperty(NS + "Female");
        mother.addProperty(RDFS.range, (RDFNode)female);
        List rules = Rule.parseRules((String)"-> tableAll(). \n[rdfs6:  (?p rdfs:subPropertyOf ?q), notEqual(?p,?q) -> [ (?a ?q ?b) <- (?a ?p ?b)] ] \n-> (eg:range rdfs:subPropertyOf rdfs:range). \n-> (rdfs:range rdfs:subPropertyOf eg:range). \n");
        GenericRuleReasoner reasoner = new GenericRuleReasoner(rules);
        reasoner.setTransitiveClosureCaching(true);
        InfModel inf = ModelFactory.createInfModel((Reasoner)reasoner, (Model)facts);
        Property egRange = inf.createProperty(NS + "range");
        TestUtil.assertIteratorValues(this, inf.listStatements(null, egRange, (RDFNode)null), new Object[]{inf.createStatement((Resource)mother, egRange, (RDFNode)female)});
    }

    public void testEmptyRemove() {
        List rules = Rule.parseRules((String)"-> (eg:i eg:prop eg:foo) .(?X eg:prop ?V) -> (?X eg:prop2 ?V) .(?X eg:prop eg:foo) noValue(?X eg:guard 'done') -> remove(0) (?X eg:guard 'done') .");
        GenericRuleReasoner reasoner = new GenericRuleReasoner(rules);
        InfModel im = ModelFactory.createInfModel((Reasoner)reasoner, (Model)ModelFactory.createDefaultModel());
        Resource i = im.createResource("urn:x-hp:eg/i");
        Property guard = im.createProperty("urn:x-hp:eg/guard");
        TestUtil.assertIteratorValues(this, im.listStatements(), new Object[]{im.createStatement(i, guard, "done")});
    }

    public void testBackwardDupRemoval() {
        String NS = "urn:x-hp:eg/";
        Model base = ModelFactory.createDefaultModel();
        Resource i = base.createResource(NS + "i");
        Resource a = base.createResource(NS + "a");
        Property p = base.createProperty(NS, "p");
        Property q = base.createProperty(NS, "q");
        Property r = base.createProperty(NS, "r");
        base.add(i, p, (RDFNode)a);
        base.add(i, q, (RDFNode)a);
        List rules = Rule.parseRules((String)"(eg:i eg:r eg:a) <- (eg:i eg:p eg:a). (eg:i eg:r eg:a) <- (eg:i eg:q eg:a).");
        GenericRuleReasoner reasoner = new GenericRuleReasoner(rules);
        reasoner.setMode(GenericRuleReasoner.BACKWARD);
        InfModel im = ModelFactory.createInfModel((Reasoner)reasoner, (Model)base);
        TestUtil.assertIteratorLength(im.listStatements(i, r, (RDFNode)a), 1);
    }

    public void testGroundClosure() {
        Flag myFlag = new Flag();
        BuiltinRegistry.theRegistry.register((Builtin)myFlag);
        String NS = "http://ont.com/";
        PrintUtil.registerPrefix((String)"ns", (String)NS);
        String rules = "[r1: (ns:a ns:p ns:b) <- (ns:a ns:p ns:a)] [r2: (ns:a ns:p ns:b) <- flag()] [rt: (?a ns:q ?b) <- (?a ns:p ?b)] ";
        Model m = ModelFactory.createDefaultModel();
        Resource a = m.createResource(NS + "a");
        Resource b = m.createResource(NS + "b");
        Property p = m.createProperty(NS + "p");
        Property q = m.createProperty(NS + "q");
        m.add(a, p, (RDFNode)a);
        GenericRuleReasoner reasoner = new GenericRuleReasoner(Rule.parseRules((String)rules));
        InfModel infModel = ModelFactory.createInfModel((Reasoner)reasoner, (Model)m);
        TestBugs.assertTrue((boolean)infModel.contains(a, q, (RDFNode)b));
        TestBugs.assertTrue((!myFlag.fired ? (byte)1 : 0) != 0);
    }

    public void testGroundClosure2() {
        Flag myFlag = new Flag();
        BuiltinRegistry.theRegistry.register((Builtin)myFlag);
        List rules = Rule.rulesFromURL((String)"file:testing/reasoners/bugs/groundClosure2.rules");
        GenericRuleReasoner reasoner = new GenericRuleReasoner(rules);
        InfModel inf = ModelFactory.createInfModel((Reasoner)reasoner, (Model)ModelFactory.createDefaultModel());
        String NS = "http://jena.hpl.hp.com/example#";
        Resource Phil = inf.getResource(NS + "Phil");
        Resource Paul = inf.getResource(NS + "Paul");
        Property parent = inf.getProperty(NS + "parent");
        TestBugs.assertTrue((boolean)inf.contains(Paul, parent, (RDFNode)Phil));
        TestBugs.assertTrue((!myFlag.fired ? (byte)1 : 0) != 0);
    }

    public void testCMEInTrans() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM_TRANS_INF);
        model.read("file:testing/reasoners/bugs/tgcCMEbug.owl");
    }

    public void testIndCardValidation() {
        String NS = "http://dummy#";
        OntModel tBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        OntClass moleculeClass = tBox.createClass("http://dummy#Molecule");
        ObjectProperty molecule2atomOntProperty = tBox.createObjectProperty("http://dummy#molecule2atom");
        molecule2atomOntProperty.setDomain((Resource)moleculeClass);
        molecule2atomOntProperty.setRange(RDF.Bag);
        CardinalityRestriction molecule2atomCardinalityRestriction = tBox.createCardinalityRestriction(null, (Property)molecule2atomOntProperty, 1);
        moleculeClass.addSuperClass((Resource)molecule2atomCardinalityRestriction);
        Reasoner reasoner = ReasonerRegistry.getOWLReasoner();
        reasoner = reasoner.bindSchema((Model)tBox);
        Model model = ModelFactory.createDefaultModel();
        InfModel aBox = ModelFactory.createInfModel((Reasoner)reasoner, (Model)model);
        Bag bag1 = aBox.createBag();
        Bag bag2 = aBox.createBag();
        bag1.addProperty(OWL.differentFrom, (RDFNode)bag2);
        Resource molecule = aBox.createResource();
        molecule.addProperty((Property)molecule2atomOntProperty, (RDFNode)bag1);
        molecule.addProperty((Property)molecule2atomOntProperty, (RDFNode)bag2);
        TestBugs.assertTrue((boolean)aBox.contains(molecule, RDF.type, (RDFNode)moleculeClass));
        TestBugs.assertFalse((boolean)aBox.validate().isValid());
    }

    public void testDeductionListener() {
        String NS = "urn:x-hp:eg/";
        Model base = ModelFactory.createDefaultModel();
        Resource i = base.createResource("urn:x-hp:eg/i");
        Property p = base.createProperty("urn:x-hp:eg/p");
        i.addProperty(p, "foo");
        List rules = Rule.parseRules((String)"(?x eg:p ?y) -> (?x eg:q ?y). ");
        GenericRuleReasoner reasoner = new GenericRuleReasoner(rules);
        InfModel infModel = ModelFactory.createInfModel((Reasoner)reasoner, (Model)base);
        TestListener listener = new TestListener();
        infModel.getDeductionsModel().register((ModelChangedListener)listener);
        infModel.rebind();
        infModel.prepare();
        TestBugs.assertEquals((Object)"foo", (Object)listener.getLastValue());
        i.removeAll(p);
        i.addProperty(p, "bar");
        infModel.rebind();
        infModel.prepare();
        TestBugs.assertEquals((Object)"bar", (Object)listener.getLastValue());
    }

    public void testOntModelGetDeductions() {
        List rules = Rule.parseRules((String)"(?x rdfs:subClassOf ?y) (?i rdf:type ?x) -> (?i rdf:type ?y).");
        GenericRuleReasoner reasoner = new GenericRuleReasoner(rules);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);
        spec.setReasoner((Reasoner)reasoner);
        OntModel om = ModelFactory.createOntologyModel((OntModelSpec)spec);
        OntClass A = om.createClass("urn:x-hp:eg/A");
        OntClass B = om.createClass("urn:x-hp:eg/B");
        OntResource i = om.createOntResource("urn:x-hp:eg/i");
        A.addSuperClass((Resource)B);
        i.addRDFType((Resource)A);
        Model deductions = om.getDeductionsModel();
        i.removeRDFType((Resource)A);
        deductions = om.getDeductionsModel();
        TestBugs.assertFalse((String)"Deductions model updating correctly", (boolean)deductions.contains((Resource)i, RDF.type, (RDFNode)B));
    }

    public void testLiteralsInErrorReports() {
        RDFNode culprit = this.doTestLiteralsInErrorReports("-> (eg:a eg:p 42).  (?X rb:violation error('test', 'arg')) <- (?S eg:p ?X).");
        TestBugs.assertEquals((Object)culprit, (Object)ResourceFactory.createTypedLiteral((Object)new Integer(42)));
        culprit = this.doTestLiteralsInErrorReports("-> (eg:a eg:p 'foo').  (?X rb:violation error('test', 'arg')) <- (?S eg:p ?X).");
        TestBugs.assertEquals((Object)culprit, (Object)ResourceFactory.createPlainLiteral((String)"foo"));
        BuiltinRegistry.theRegistry.register((Builtin)new SomeTriple());
        culprit = this.doTestLiteralsInErrorReports("-> (eg:a eg:p 42).  (?X rb:violation error('test', 'arg')) <- (?S eg:p ?Y), someTriple(?X).");
        TestBugs.assertTrue((boolean)culprit.isLiteral());
        Object val = ((Literal)culprit).getValue();
        TestBugs.assertTrue((boolean)(val instanceof Triple));
    }

    private RDFNode doTestLiteralsInErrorReports(String rules) {
        GenericRuleReasoner reasoner = new GenericRuleReasoner(Rule.parseRules((String)rules));
        InfModel im = ModelFactory.createInfModel((Reasoner)reasoner, (Model)ModelFactory.createDefaultModel());
        ValidityReport validity = im.validate();
        TestBugs.assertTrue((!validity.isValid() ? (byte)1 : 0) != 0);
        ValidityReport.Report report = (ValidityReport.Report)validity.getReports().next();
        TestBugs.assertTrue((boolean)(report.getExtension() instanceof RDFNode));
        return (RDFNode)report.getExtension();
    }

    public void testRDFSSimple() {
        this.doTestRDFSSimple("default");
        this.doTestRDFSSimple("simple");
    }

    private void doTestRDFSSimple(String level) {
        Model model = ModelFactory.createDefaultModel();
        String NS = "http://jena.hpl.hp.com/example#";
        Property prop = model.createProperty(NS + "prop");
        model.add((Resource)prop, RDF.type, (RDFNode)RDF.Property);
        Reasoner reasoner = RDFSRuleReasonerFactory.theInstance().create(null);
        reasoner.setParameter(ReasonerVocabulary.PROPsetRDFSLevel, (Object)level);
        InfModel im = ModelFactory.createInfModel((Reasoner)reasoner, (Model)model);
        TestBugs.assertTrue((boolean)im.contains((Resource)prop, RDFS.subPropertyOf, (RDFNode)prop));
    }

    public void testLayeredValidation() {
        Model ont = FileManager.get().loadModel("testing/reasoners/bugs/layeredValidation.owl");
        InfModel infModel = ModelFactory.createInfModel((Reasoner)ReasonerRegistry.getOWLReasoner(), (Model)ont);
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_RULE_INF, (Model)infModel);
        ValidityReport validity = model.validate();
        TestBugs.assertTrue((boolean)validity.isClean());
    }

    private static class SomeTriple
    extends BaseBuiltin {
        private SomeTriple() {
        }

        public String getName() {
            return "someTriple";
        }

        public int getArgLength() {
            return 1;
        }

        public boolean bodyCall(Node[] args, int length, RuleContext context) {
            this.checkArgs(length, context);
            BindingEnvironment env = context.getEnv();
            Triple t = new Triple(Node.createAnon(), Node.createURI((String)"http://jena.hpl.hp.com/example#"), Node.createAnon());
            Node l = Node.createLiteral((LiteralLabel)LiteralLabelFactory.create((Object)t));
            return env.bind(args[0], l);
        }
    }

    private static class Flag
    extends BaseBuiltin {
        public boolean fired = false;

        private Flag() {
        }

        public String getName() {
            return "flag";
        }

        public boolean bodyCall(Node[] args, int length, RuleContext context) {
            this.fired = true;
            return true;
        }
    }

    private class TestListener
    extends StatementListener {
        final Property Q = ResourceFactory.createProperty((String)"urn:x-hp:eg/q");
        RDFNode lastValue = null;

        private TestListener() {
        }

        public Object getLastValue() {
            if (this.lastValue != null && this.lastValue.isLiteral()) {
                return ((Literal)this.lastValue).getLexicalForm();
            }
            return this.lastValue;
        }

        public void addedStatement(Statement s) {
            if (s.getPredicate().equals(this.Q)) {
                this.lastValue = s.getObject();
            }
        }
    }
}

